/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.AccessRowSequence;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class TransposeFilter
extends BasicFilter {
    public static final ColumnInfo HEADING_INFO = new ColumnInfo("Heading", String.class, "Name of the column of which this row is the transpose");

    public TransposeFilter() {
        super("transpose", "[-namecol <col-id>]");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Transposes the input table so that columns become rows", "and vice versa.", "The <code>-namecol</code> flag can be used to specify a column", "in the input table which will provide the column names for", "the output table.", "The first column of the output table will contain the", "column names of the input table.", "</p>", TransposeFilter.explainSyntax(new String[]{"col-id"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String namcol = null;
        while (argIt.hasNext()) {
            String arg = argIt.next();
            if (!arg.equals("-namecol") || !argIt.hasNext()) continue;
            argIt.remove();
            namcol = argIt.next();
            argIt.remove();
        }
        final String nameCol = namcol;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) throws IOException {
                int iNameCol = nameCol == null ? -1 : new ColumnIdentifier(base).getColumnIndex(nameCol);
                base = StoragePolicy.getDefaultPolicy().randomTable(base);
                return new TransposeTable(base, iNameCol);
            }
        };
    }

    private static class TransposeTable
    extends WrapperStarTable {
        private final StarTable base_;
        private final int jNameCol_;
        private final int nBaseCol_;
        private final int nBaseRow_;
        private final ColumnInfo[] colInfos_;
        private final RowEvaluator.Decoder<?>[] decoders_;

        TransposeTable(StarTable base, int jNameCol) throws IOException {
            super(base);
            this.base_ = base;
            this.jNameCol_ = jNameCol;
            ColumnInfo nameInfo = jNameCol >= 0 ? base.getColumnInfo(jNameCol) : null;
            this.nBaseCol_ = base.getColumnCount();
            this.nBaseRow_ = TransposeTable.checkedLongToInt((long)base.getRowCount());
            RowEvaluator rowEval = new RowEvaluator(this.nBaseRow_);
            for (int iBaseCol = 0; iBaseCol < this.nBaseCol_; ++iBaseCol) {
                if (iBaseCol == jNameCol) continue;
                String[] baseCol = new String[this.nBaseRow_];
                for (int iBaseRow = 0; iBaseRow < this.nBaseRow_; ++iBaseRow) {
                    baseCol[iBaseRow] = TransposeTable.asString(this.base_.getCell((long)iBaseRow, iBaseCol));
                }
                rowEval.submitRow(Arrays.asList(baseCol));
            }
            RowEvaluator.Metadata meta = rowEval.getMetadata();
            assert (meta.nrow_ == this.getRowCount());
            this.decoders_ = meta.decoders_;
            this.colInfos_ = meta.colInfos_;
            for (int iBaseRow = 0; iBaseRow < this.nBaseRow_; ++iBaseRow) {
                String colName = null;
                if (this.jNameCol_ >= 0) {
                    Object colNameObj = this.base_.getCell((long)iBaseRow, this.jNameCol_);
                    colName = nameInfo.formatValue(colNameObj, 32);
                }
                if (Tables.isBlank(colName)) {
                    colName = "col" + (iBaseRow + 1);
                }
                this.colInfos_[iBaseRow].setName(colName);
            }
        }

        public ColumnInfo getColumnInfo(int icol) {
            return icol == 0 ? HEADING_INFO : this.colInfos_[icol - 1];
        }

        public boolean isRandom() {
            return true;
        }

        public int getColumnCount() {
            return 1 + this.nBaseRow_;
        }

        public long getRowCount() {
            return this.nBaseCol_ - (this.jNameCol_ >= 0 ? 1 : 0);
        }

        public Object getCell(long lrow, int icol) throws IOException {
            int iBaseCol = this.getBaseColumnForRow(lrow);
            if (icol == 0) {
                return this.base_.getColumnInfo(iBaseCol).getName();
            }
            Object baseCell = this.base_.getCell((long)(icol - 1), iBaseCol);
            return Tables.isBlank((Object)baseCell) ? null : this.decoders_[icol - 1].decode(TransposeTable.asString(baseCell));
        }

        public Object[] getRow(long lrow) throws IOException {
            int ncol = 1 + this.nBaseRow_;
            Object[] row = new Object[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                row[icol] = this.getCell(lrow, icol);
            }
            return row;
        }

        public RowAccess getRowAccess() throws IOException {
            final RowAccess baseAcc = this.base_.getRowAccess();
            final int ncol = this.getColumnCount();
            return new RowAccess(){
                long irow_ = -1L;
                int iBaseCol_ = -1;
                final Object[] row_ = new Object[ncol];

                public void setRowIndex(long irow) {
                    if (irow != this.irow_) {
                        this.irow_ = irow;
                        this.iBaseCol_ = this.getBaseColumnForRow(irow);
                    }
                }

                public Object getCell(int icol) throws IOException {
                    if (icol == 0) {
                        return base_.getColumnInfo(this.iBaseCol_).getName();
                    }
                    baseAcc.setRowIndex((long)(icol - 1));
                    Object baseCell = baseAcc.getCell(this.iBaseCol_);
                    return Tables.isBlank((Object)baseCell) ? null : decoders_[icol - 1].decode(TransposeTable.asString(baseCell));
                }

                public Object[] getRow() throws IOException {
                    for (int icol = 0; icol < ncol; ++icol) {
                        this.row_[icol] = this.getCell(icol);
                    }
                    return this.row_;
                }

                public void close() throws IOException {
                    baseAcc.close();
                }
            };
        }

        public RowSequence getRowSequence() throws IOException {
            return AccessRowSequence.createInstance((StarTable)this);
        }

        public RowSplittable getRowSplittable() throws IOException {
            return Tables.getDefaultRowSplittable((StarTable)this);
        }

        private int getBaseColumnForRow(long lrow) {
            int irow = TransposeTable.checkedLongToInt((long)lrow);
            if (irow < this.jNameCol_ || this.jNameCol_ < 0) {
                return irow;
            }
            return irow + 1;
        }

        private static String asString(Object obj) {
            return Tables.isBlank((Object)obj) ? null : obj.toString();
        }
    }
}

