/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.AsciiMocCoverage;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.MocCoverage;
import uk.ac.starlink.ttools.cone.UrlMocCoverage;
import uk.ac.starlink.util.URLUtils;

public class Coverage {
    private static final Map<String, MocCoverage> mocMap_ = new HashMap<String, MocCoverage>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.func");
    public static final double SPHERE_STERADIAN = Math.PI * 4;
    public static final double SPHERE_SQDEG = 41252.96124941927;

    private Coverage() {
    }

    public static boolean inMoc(String moc, double ra, double dec) {
        return Coverage.nearMoc(moc, ra, dec, 0.0);
    }

    public static boolean nearMoc(String moc, double ra, double dec, double distanceDeg) {
        MocCoverage cov = Coverage.getMocCoverage(moc);
        return cov == null || cov.getAmount() == Coverage.Amount.NO_DATA ? false : cov.discOverlaps(ra, dec, distanceDeg);
    }

    public static double mocSkyProportion(String moc) {
        MocCoverage cov = Coverage.getMocCoverage(moc);
        return cov == null || cov.getAmount() == Coverage.Amount.NO_DATA ? Double.NaN : cov.getMoc().getCoverage();
    }

    public static long mocTileCount(String moc) {
        MocCoverage cov = Coverage.getMocCoverage(moc);
        return cov == null || cov.getAmount() == Coverage.Amount.NO_DATA ? 0L : (long)cov.getMoc().getNbCoding();
    }

    private static MocCoverage getMocCoverage(String mocTxt) {
        if (!mocMap_.containsKey(mocTxt)) {
            mocMap_.put(mocTxt, Coverage.createMocCoverage(mocTxt));
        }
        return mocMap_.get(mocTxt);
    }

    private static MocCoverage createMocCoverage(String mocTxt) {
        if (AsciiMocCoverage.looksLikeAsciiMoc(mocTxt)) {
            try {
                AsciiMocCoverage cov = new AsciiMocCoverage(mocTxt);
                cov.initCoverage();
                if (cov.getAmount() != Coverage.Amount.NO_DATA) {
                    return cov;
                }
                logger_.info("Looks like ASCII MOC but parsing failed: " + mocTxt);
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            URL url = URLUtils.makeURL((String)mocTxt);
            UrlMocCoverage cov = new UrlMocCoverage(url);
            cov.initCoverage();
            if (cov.getAmount() != Coverage.Amount.NO_DATA) {
                return cov;
            }
            logger_.config("No MOC at location: " + mocTxt);
        }
        catch (Exception e) {
            logger_.log(Level.INFO, "No MOC at location: " + mocTxt, e);
        }
        try {
            UrlMocCoverage cov = UrlMocCoverage.getVizierMoc(mocTxt, -1);
            cov.initCoverage();
            if (cov.getAmount() != Coverage.Amount.NO_DATA) {
                return cov;
            }
            logger_.config("No VizieR MOC: " + mocTxt);
        }
        catch (IOException e) {
            logger_.log(Level.INFO, "No VizieR MOC: " + mocTxt, e);
        }
        logger_.warning("Unknown MOC: " + mocTxt + " - assume no coverage");
        return null;
    }

    public static long mocUniq(int order, long index) {
        return (4L << 2 * order) + index;
    }

    public static int uniqToOrder(long uniq) {
        return 61 - Long.numberOfLeadingZeros(uniq) >> 1;
    }

    public static long uniqToIndex(long uniq) {
        return uniq - (4L << (Coverage.uniqToOrder(uniq) << 1));
    }
}

