/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.function.Function;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MappingRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowAccess;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.ttools.jel.CustomCompilationException;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELQuantity;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class JELTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final String[] exprs_;
    private final ColumnInfo[] colInfos_;
    private final CompiledExpression[] randomCompexs_;
    private final RandomJELRowReader randomReader_;
    private final int ncol_;

    public JELTable(StarTable baseTable, ColumnInfo[] colInfos, String[] exprs) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.exprs_ = exprs;
        this.colInfos_ = colInfos;
        if (this.exprs_.length != this.colInfos_.length) {
            throw new IllegalArgumentException("How many columns??");
        }
        this.ncol_ = exprs.length;
        this.randomReader_ = RandomJELRowReader.createConcurrentReader(baseTable);
        Library lib = JELUtils.getLibrary(this.randomReader_);
        this.randomCompexs_ = new CompiledExpression[this.ncol_];
        for (int i = 0; i < this.ncol_; ++i) {
            String expr = this.exprs_[i];
            ColumnInfo colInfo = this.colInfos_[i];
            try {
                this.randomCompexs_[i] = JELUtils.compile(lib, baseTable, expr);
            }
            catch (CompilationException e) {
                throw new CustomCompilationException("Bad expression " + expr + ": " + e.getMessage(), e);
            }
            Class<?> pClazz = JELUtils.getExpressionType(lib, baseTable, expr);
            Class<?> clazz = JELUtils.getWrapperType(pClazz);
            Class reqClazz = this.colInfos_[i].getContentClass();
            if (reqClazz != null && !reqClazz.isAssignableFrom(clazz)) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("Column ").append(colInfo.getName()).append(": expression ").append(expr).append(" has type ").append(clazz.getName()).append(", incompatible with required type ").append(reqClazz.getName());
                throw new IllegalArgumentException(sbuf.toString());
            }
            this.colInfos_[i].setContentClass(clazz);
        }
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public Object getCell(long irow, int icol) throws IOException {
        try {
            return this.randomReader_.evaluateAtRow(this.randomCompexs_[icol], irow);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.getCell(irow, icol);
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
        return new WrapperRowSequence((RowSequence)seqReader, this.jelMapper(seqReader));
    }

    public RowAccess getRowAccess() throws IOException {
        RowAccess baseAcc = this.baseTable_.getRowAccess();
        RandomJELRowReader jelReader = RandomJELRowReader.createAccessReader(this.baseTable_, baseAcc);
        return new WrapperRowAccess(baseAcc, this.jelMapper(jelReader));
    }

    public RowSplittable getRowSplittable() throws IOException {
        RowSplittable baseSplit = this.baseTable_.getRowSplittable();
        Function<RowSplittable, RowData> mapper = split -> {
            try {
                return this.jelMapper(new SequentialJELRowReader(this.baseTable_, (RowSplittable)split));
            }
            catch (IOException e) {
                throw new RuntimeException("Shouldn't happen", e);
            }
        };
        return new MappingRowSplittable(baseSplit, mapper);
    }

    private RowData jelMapper(final StarTableJELRowReader jelReader) throws IOException {
        final CompiledExpression[] accCompexs = JELUtils.compileExpressions(jelReader, this.exprs_);
        return new RowData(){
            final Object[] row_;
            {
                this.row_ = new Object[JELTable.this.ncol_];
            }

            public Object getCell(int icol) throws IOException {
                try {
                    return jelReader.evaluate(accCompexs[icol]);
                }
                catch (IOException | Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            public Object[] getRow() throws IOException {
                for (int icol = 0; icol < JELTable.this.ncol_; ++icol) {
                    this.row_[icol] = this.getCell(icol);
                }
                return this.row_;
            }
        };
    }

    public static StarTable createJELTable(StarTable baseTable, ValueInfo[] infos, String[] exprs) throws ExecutionException {
        int ncol = exprs.length;
        if (infos.length != ncol) {
            throw new IllegalArgumentException("Column length mismatch");
        }
        ColumnInfo[] colInfos = new ColumnInfo[ncol];
        for (int i = 0; i < ncol; ++i) {
            colInfos[i] = new ColumnInfo(infos[i]);
        }
        try {
            return new JELTable(baseTable, colInfos, exprs);
        }
        catch (CompilationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public static StarTable createJELTable(StarTable baseTable, String[] exprs) throws CompilationException {
        int ncol = exprs.length;
        DummyJELRowReader jelRdr = new DummyJELRowReader(baseTable);
        Library lib = JELUtils.getLibrary(jelRdr);
        ColumnInfo[] infos = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            String expr = exprs[icol];
            JELQuantity jq = JELUtils.compileQuantity(lib, jelRdr, expr, null);
            infos[icol] = new ColumnInfo(jq.getValueInfo());
        }
        return new JELTable(baseTable, infos, exprs);
    }
}

