/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public abstract class RandomJELEvaluator
implements Closeable {
    public abstract Object evaluateObject(long var1) throws IOException;

    public abstract double evaluateDouble(long var1) throws IOException;

    public abstract boolean evaluateBoolean(long var1) throws IOException;

    public static Supplier<RandomJELEvaluator> createEvaluatorSupplier(StarTable table, String expr) throws CompilationException {
        Function<Library, CompiledExpression> compiler = JELUtils.compiler(table, expr, null);
        return () -> {
            AccessRowReader rdr;
            try {
                rdr = new AccessRowReader(table, compiler);
            }
            catch (IOException e) {
                throw new RuntimeException("Uh oh, rethrown IOException " + e, e);
            }
            return new RandomJELEvaluator(){

                @Override
                public Object evaluateObject(long lrow) throws IOException {
                    rdr.setRowIndex(lrow);
                    return rdr.evaluateObject();
                }

                @Override
                public double evaluateDouble(long lrow) throws IOException {
                    rdr.setRowIndex(lrow);
                    return rdr.evaluateDouble();
                }

                @Override
                public boolean evaluateBoolean(long lrow) throws IOException {
                    rdr.setRowIndex(lrow);
                    return rdr.evaluateBoolean();
                }

                @Override
                public void close() throws IOException {
                    rdr.close();
                }
            };
        };
    }

    public static RandomJELEvaluator createEvaluator(StarTable table, String expr, boolean isConcurrent) throws CompilationException {
        RowReaderManager rdrMgr;
        Function<Library, CompiledExpression> compiler = JELUtils.compiler(table, expr, null);
        final Supplier<AccessRowReader> rdrSupplier = () -> {
            try {
                return new AccessRowReader(table, compiler);
            }
            catch (IOException e) {
                throw new RuntimeException("Uh oh, rethrown IOException " + e, e);
            }
        };
        if (isConcurrent) {
            final CopyOnWriteArrayList rdrList = new CopyOnWriteArrayList();
            final ThreadLocal<AccessRowReader> rdrLocal = new ThreadLocal<AccessRowReader>(){

                @Override
                protected AccessRowReader initialValue() {
                    AccessRowReader rdr = (AccessRowReader)rdrSupplier.get();
                    rdrList.add(rdr);
                    return rdr;
                }
            };
            rdrMgr = new RowReaderManager(){

                @Override
                public AccessRowReader getRowReader() {
                    return (AccessRowReader)rdrLocal.get();
                }

                @Override
                public void close() throws IOException {
                    for (AccessRowReader rdr : rdrList) {
                        rdr.close();
                    }
                }
            };
        } else {
            final AccessRowReader rdr = rdrSupplier.get();
            rdrMgr = new RowReaderManager(){

                @Override
                public AccessRowReader getRowReader() {
                    return rdr;
                }

                @Override
                public void close() throws IOException {
                    rdr.close();
                }
            };
        }
        return new RandomJELEvaluator(){

            @Override
            public Object evaluateObject(long lrow) throws IOException {
                return this.getReader(lrow).evaluateObject();
            }

            @Override
            public double evaluateDouble(long lrow) throws IOException {
                return this.getReader(lrow).evaluateDouble();
            }

            @Override
            public boolean evaluateBoolean(long lrow) throws IOException {
                return this.getReader(lrow).evaluateBoolean();
            }

            @Override
            public void close() throws IOException {
                rdrMgr.close();
            }

            AccessRowReader getReader(long lrow) throws IOException {
                AccessRowReader rdr = rdrMgr.getRowReader();
                rdr.setRowIndex(lrow);
                return rdr;
            }
        };
    }

    private static class AccessRowReader
    extends StarTableJELRowReader
    implements Closeable {
        private final CompiledExpression compEx_;
        private final RowAccess rowAccess_;
        private long lrow_;

        AccessRowReader(StarTable table, Function<Library, CompiledExpression> compiler) throws IOException {
            super(table);
            this.compEx_ = compiler.apply(JELUtils.getLibrary(this));
            this.rowAccess_ = table.getRowAccess();
            this.lrow_ = -1L;
        }

        void setRowIndex(long lrow) throws IOException {
            this.rowAccess_.setRowIndex(lrow);
            this.lrow_ = lrow;
        }

        @Override
        public long getCurrentRow() {
            return this.lrow_;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rowAccess_.getCell(icol);
        }

        @Override
        public void close() throws IOException {
            this.rowAccess_.close();
        }

        public Object evaluateObject() throws IOException {
            try {
                return this.evaluate(this.compEx_);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("Evaluation error: " + e, e);
            }
        }

        public double evaluateDouble() throws IOException {
            try {
                return this.evaluateDouble(this.compEx_);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("Evaluation error: " + e, e);
            }
        }

        public boolean evaluateBoolean() throws IOException {
            try {
                return this.evaluateBoolean(this.compEx_);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("Evaluation error: " + e, e);
            }
        }
    }

    private static interface RowReaderManager
    extends Closeable {
        public AccessRowReader getRowReader();
    }
}

