/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.IOException;
import java.util.Collection;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.PairMode;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TableMapping;

public class Match2Mapping
implements TableMapping {
    final String[] exprTuple1_;
    final String[] exprTuple2_;
    final JoinFixAction[] fixacts_;
    final MatchEngine matchEngine_;
    final PairMode pairMode_;
    final JoinType join_;
    final ValueInfo scoreInfo_;
    final ProgressIndicator progger_;
    final RowRunner runner_;

    Match2Mapping(MatchEngine matchEngine, String[] exprTuple1, String[] exprTuple2, JoinType join, PairMode pairMode, JoinFixAction fixact1, JoinFixAction fixact2, ValueInfo scoreInfo, ProgressIndicator progger, RowRunner runner) {
        this.matchEngine_ = matchEngine;
        this.exprTuple1_ = exprTuple1;
        this.exprTuple2_ = exprTuple2;
        this.join_ = join;
        this.pairMode_ = pairMode;
        this.fixacts_ = new JoinFixAction[]{fixact1, fixact2};
        this.scoreInfo_ = join.getUsedMatchFlag() ? scoreInfo : null;
        this.progger_ = progger;
        this.runner_ = runner;
    }

    @Override
    public StarTable mapTables(InputTableSpec[] inSpecs) throws IOException, TaskException {
        try {
            return this.attemptMapTables(inSpecs);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private StarTable attemptMapTables(InputTableSpec[] inSpecs) throws IOException, TaskException, InterruptedException {
        StarTable inTable1 = inSpecs[0].getWrappedTable();
        StarTable inTable2 = inSpecs[1].getWrappedTable();
        this.makeSubTable(inTable1, this.exprTuple1_);
        this.makeSubTable(inTable2, this.exprTuple2_);
        inTable1 = Tables.randomTable((StarTable)inTable1);
        inTable2 = Tables.randomTable((StarTable)inTable2);
        StarTable subTable1 = this.makeSubTable(inTable1, this.exprTuple1_);
        StarTable subTable2 = this.makeSubTable(inTable2, this.exprTuple2_);
        RowMatcher matcher = RowMatcher.createMatcher((MatchEngine)this.matchEngine_, (StarTable[])new StarTable[]{subTable1, subTable2}, (RowRunner)this.runner_);
        matcher.setIndicator(this.progger_);
        LinkSet matches = matcher.findPairMatches(this.pairMode_);
        boolean addGroups = this.pairMode_.mayProduceGroups();
        int nrows1 = Tables.checkedLongToInt((long)inTable1.getRowCount());
        int nrows2 = Tables.checkedLongToInt((long)inTable2.getRowCount());
        matches = this.join_.processLinks(matches, new int[]{nrows1, nrows2});
        boolean[] useFlags = this.join_.getUsedTableFlags();
        StarTable[] tables = new StarTable[]{useFlags[0] ? inTable1 : null, useFlags[1] ? inTable2 : null};
        Collection links = MatchStarTables.orderLinks((LinkSet)matches);
        return MatchStarTables.createInstance((ProgressIndicator)this.progger_, (RowRunner)this.runner_).makeJoinTable(tables, links, addGroups, this.fixacts_, this.scoreInfo_);
    }

    protected StarTable makeSubTable(StarTable inTable, String[] exprTuple) throws ExecutionException {
        return JELTable.createJELTable(inTable, this.matchEngine_.getTupleInfos(), exprTuple);
    }
}

