/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import uk.ac.starlink.ttools.moc.IndexBag;

public class LongBag
implements IndexBag {
    private final Set<Long> longSet_ = new HashSet<Long>();
    private final int setmax_;
    private long[] sortedLongs_;
    public static final int DFLT_SETMAX = 100000;

    public LongBag() {
        this(100000);
    }

    public LongBag(int setmax) {
        this.setmax_ = setmax;
        this.sortedLongs_ = new long[0];
    }

    @Override
    public boolean hasIndex(long lval) {
        return this.longSet_.contains(lval) || Arrays.binarySearch(this.sortedLongs_, lval) >= 0;
    }

    @Override
    public void addIndex(long lval) {
        if (Arrays.binarySearch(this.sortedLongs_, lval) < 0) {
            this.longSet_.add(lval);
            if (this.longSet_.size() > this.setmax_) {
                this.drainSet();
            }
        }
    }

    @Override
    public long getCount() {
        this.drainSet();
        return this.sortedLongs_.length;
    }

    @Override
    public PrimitiveIterator.OfLong sortedLongIterator() {
        this.drainSet();
        return Arrays.stream(this.sortedLongs_).iterator();
    }

    private void drainSet() {
        long[] array0 = this.sortedLongs_;
        long[] array1 = new long[array0.length + this.longSet_.size()];
        System.arraycopy(array0, 0, array1, 0, array0.length);
        int ix = array0.length;
        for (Long lval : this.longSet_) {
            array1[ix++] = lval;
        }
        this.longSet_.clear();
        Arrays.sort(array1);
        this.sortedLongs_ = array1;
    }
}

