/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class ChecksumMode
implements ProcessingMode {
    private final Supplier<Checksum> checksumFactory_;

    public ChecksumMode() {
        this(Adler32::new);
    }

    public ChecksumMode(Supplier<Checksum> checksumFactory) {
        this.checksumFactory_ = checksumFactory;
    }

    @Override
    public String getDescription() {
        return String.join((CharSequence)"\n", "<p>Calculates a checksum from all the data in the table.", "The checksum is written to standard output in hexadecimal;", "row and column counts are also written.", "</p>", "<p>If two tables have the same checksum", "it is extremely likely that they contain the same cell data.", "If they have a different checksum, their cell data differs.", "By default, the checksum implementation uses Adler32,", "which is fast but not cryptographically secure.", "</p>");
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[0];
    }

    @Override
    public TableConsumer createConsumer(Environment env) {
        final PrintStream out = env.getOutputStream();
        return new TableConsumer(){

            @Override
            public void consume(StarTable table) throws IOException {
                Checksum checksum = (Checksum)ChecksumMode.this.checksumFactory_.get();
                int ncol = table.getColumnCount();
                long nrow = Tables.checksumData((StarTable)table, (Checksum)checksum);
                long checkValue = checksum.getValue();
                out.println("Checksum: " + Long.toHexString(checkValue) + " \tNcol: " + ncol + " \tNrow: " + nrow);
            }
        };
    }
}

