/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Picture;

public class PictureImageIcon
implements Icon {
    private final Picture picture_;
    private final boolean caching_;
    private final Integer transparency_;
    private Image cachedImage_;
    private static final int MAX_TRY = 3;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");

    private PictureImageIcon(Picture picture, boolean caching, Integer transparency) {
        this.picture_ = picture;
        this.caching_ = caching;
        if (transparency != null) {
            switch (transparency) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown transparency " + transparency);
                }
            }
        }
        this.transparency_ = transparency;
    }

    public PictureImageIcon(Picture picture, boolean caching, int transparency) {
        this(picture, caching, (Integer)transparency);
    }

    public PictureImageIcon(Picture picture, boolean caching) {
        this(picture, caching, null);
    }

    @Override
    public int getIconWidth() {
        return this.picture_.getPictureWidth();
    }

    @Override
    public int getIconHeight() {
        return this.picture_.getPictureHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Image image;
        if (this.cachedImage_ != null) {
            image = this.cachedImage_;
        } else {
            GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
            Color bg = c == null ? Color.WHITE : c.getBackground();
            image = PictureImageIcon.createImage(this.picture_, gc, bg, this.transparency_);
            if (this.caching_) {
                this.cachedImage_ = image;
            }
        }
        g.drawImage(image, x, y, null);
    }

    public void cacheImage(GraphicsConfiguration gc, Color bg) {
        this.cachedImage_ = PictureImageIcon.createImage(this.picture_, gc, bg, this.transparency_);
    }

    public static BufferedImage createImage(Picture picture, GraphicsConfiguration gc, Color bg, Integer transparency) {
        int w = picture.getPictureWidth();
        int h = picture.getPictureHeight();
        VolatileImage vim = transparency == null ? gc.createCompatibleVolatileImage(w, h) : gc.createCompatibleVolatileImage(w, h, transparency);
        ImageCapabilities imCaps = vim.getCapabilities();
        if (logger_.isLoggable(Level.CONFIG)) {
            String msg = new StringBuffer().append("Painting picture to ").append("image: ").append(imCaps.isAccelerated() ? "accelerated" : "not accelerated").append(", ").append(imCaps.isTrueVolatile() ? "volatile" : "not volatile").toString();
            logger_.config(msg);
        }
        for (int iLost = 0; iLost < 3; ++iLost) {
            vim.validate(gc);
            Graphics2D gv = vim.createGraphics();
            PictureImageIcon.doPaint(gv, bg, picture);
            boolean lost = vim.contentsLost();
            BufferedImage im = lost ? null : vim.getSnapshot();
            lost = lost || vim.contentsLost();
            gv.dispose();
            if (!lost) {
                vim.flush();
                return im;
            }
            logger_.info("Lost volatile image during draw");
        }
        vim.flush();
        logger_.warning("Draw to volatile image failed after 3 attempts - draw direct");
        BufferedImage bim = transparency == null ? gc.createCompatibleImage(w, h) : gc.createCompatibleImage(w, h, transparency);
        Graphics2D gb = bim.createGraphics();
        PictureImageIcon.doPaint(gb, bg, picture);
        gb.dispose();
        return bim;
    }

    private static void doPaint(Graphics2D g, Color bg, Picture picture) {
        if (bg != null) {
            Color color = g.getColor();
            g.setColor(bg);
            g.fillRect(0, 0, picture.getPictureWidth(), picture.getPictureHeight());
            g.setColor(color);
        }
        try {
            picture.paintPicture(g);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Graphic plotting IO error", e);
            g.drawString(e.toString(), 10, picture.getPictureHeight() / 2);
        }
    }
}

