/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;

public abstract class Anchor {
    public static Anchor N = new HorizontalAnchor(){

        @Override
        protected int[] getOffset(Rectangle box, int pad) {
            return new int[]{-box.width / 2, box.height + pad};
        }

        public String toString() {
            return "North";
        }
    };
    public static Anchor E = new HorizontalAnchor(){

        @Override
        protected int[] getOffset(Rectangle box, int pad) {
            return new int[]{-box.width - pad, box.height / 2};
        }

        public String toString() {
            return "East";
        }
    };
    public static Anchor W = new HorizontalAnchor(){

        @Override
        protected int[] getOffset(Rectangle box, int pad) {
            return new int[]{pad, box.height / 2};
        }

        public String toString() {
            return "West";
        }
    };
    public static Anchor S = new HorizontalAnchor(){

        @Override
        protected int[] getOffset(Rectangle box, int pad) {
            return new int[]{-box.width / 2, -pad};
        }

        public String toString() {
            return "South";
        }
    };
    public static Anchor C = new HorizontalAnchor(){

        @Override
        protected int[] getOffset(Rectangle box, int pad) {
            return new int[]{-box.width / 2, box.height / 2};
        }

        public String toString() {
            return "Center";
        }
    };

    public abstract Rectangle getCaptionBounds(Caption var1, int var2, int var3, Captioner var4);

    public abstract void drawCaption(Caption var1, int var2, int var3, Captioner var4, Graphics var5);

    public static Anchor createAngledAnchor(double theta, Anchor baseAnchor) {
        return new AngledAnchor(theta, baseAnchor);
    }

    private static class AngledAnchor
    extends Anchor {
        private final double theta_;
        private final Anchor baseAnchor_;

        public AngledAnchor(double theta, Anchor baseAnchor) {
            this.theta_ = theta;
            this.baseAnchor_ = baseAnchor;
        }

        @Override
        public Rectangle getCaptionBounds(Caption label, int px, int py, Captioner captioner) {
            Rectangle baseBounds = this.baseAnchor_.getCaptionBounds(label, px, py, captioner);
            Rectangle2D.Double b0 = new Rectangle2D.Double();
            b0.setRect(baseBounds.getBounds2D());
            b0.x -= (double)px;
            b0.y -= (double)py;
            Rectangle2D.Double b1 = new Rectangle2D.Double();
            b1.add(this.rotatePoint(b0.x, b0.y));
            b1.add(this.rotatePoint(b0.x + b0.width, b0.y));
            b1.add(this.rotatePoint(b0.x + b0.width, b0.y + b0.height));
            b1.add(this.rotatePoint(b0.x, b0.y + b0.height));
            b1.x += (double)px;
            b1.y += (double)py;
            return b1.getBounds();
        }

        @Override
        public void drawCaption(Caption label, int px, int py, Captioner captioner, Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform trans0 = g2.getTransform();
            g2.translate(px, py);
            g2.rotate(this.theta_);
            this.baseAnchor_.drawCaption(label, 0, 0, captioner, g);
            g2.setTransform(trans0);
        }

        private Point2D rotatePoint(double px, double py) {
            double cos = Math.cos(this.theta_);
            double sin = Math.sin(this.theta_);
            return new Point2D.Double(cos * px - sin * py, sin * px + cos * py);
        }
    }

    public static abstract class HorizontalAnchor
    extends Anchor {
        @Override
        public Rectangle getCaptionBounds(Caption label, int px, int py, Captioner captioner) {
            Rectangle cbox = captioner.getCaptionBounds(label);
            int[] offset = this.getOffset(cbox, captioner.getPad());
            cbox.translate(px + offset[0], py + offset[1]);
            return cbox;
        }

        @Override
        public void drawCaption(Caption label, int px, int py, Captioner captioner, Graphics g) {
            Rectangle cbox = captioner.getCaptionBounds(label);
            int[] offset = this.getOffset(cbox, captioner.getPad());
            int xoff = px + offset[0];
            int yoff = py + offset[1];
            g.translate(xoff, yoff);
            captioner.drawCaption(label, g);
            g.translate(-xoff, -yoff);
        }

        protected abstract int[] getOffset(Rectangle var1, int var2);
    }
}

