/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Scalings;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;

public class BasicRanger
implements Ranger {
    private final boolean isBestEfforts_;
    private double lo_;
    private double hi_;
    private double loPos_;
    private double hiPos_;
    private boolean hasData_;
    private boolean hasPos_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public BasicRanger(boolean isBestEfforts) {
        this.isBestEfforts_ = isBestEfforts;
        this.lo_ = Double.NaN;
        this.hi_ = Double.NaN;
        this.loPos_ = Double.NaN;
        this.hiPos_ = Double.NaN;
        this.hasData_ = false;
        this.hasPos_ = false;
    }

    @Override
    public void submitDatum(double datum) {
        if (PlotUtil.isFinite(datum)) {
            if (this.hasData_) {
                if (datum < this.lo_) {
                    this.lo_ = datum;
                } else if (datum > this.hi_) {
                    this.hi_ = datum;
                }
            } else {
                this.hasData_ = true;
                this.lo_ = datum;
                this.hi_ = datum;
            }
            if (datum > 0.0) {
                if (this.hasPos_) {
                    if (datum < this.loPos_) {
                        this.loPos_ = datum;
                    } else if (datum > this.hiPos_) {
                        this.hiPos_ = datum;
                    }
                } else {
                    this.hasPos_ = true;
                    this.loPos_ = datum;
                    this.hiPos_ = datum;
                }
            }
        }
    }

    @Override
    public void add(Ranger other) {
        BasicRanger bother = (BasicRanger)other;
        this.submitDatum(bother.lo_);
        this.submitDatum(bother.hi_);
        this.submitDatum(bother.loPos_);
        this.submitDatum(bother.hiPos_);
    }

    @Override
    public Ranger createCompatibleRanger() {
        return new BasicRanger(this.isBestEfforts_);
    }

    @Override
    public Span createSpan() {
        return new BasicSpan(this.isBestEfforts_, this.lo_, this.hi_, this.loPos_, this.hiPos_);
    }

    public static double[] calculateFiniteBounds(double lo, double hi, boolean isPositive) {
        double[] dArray;
        lo = isPositive && lo <= 0.0 ? Double.NaN : lo;
        double d = hi = isPositive && hi <= 0.0 ? Double.NaN : hi;
        if (lo > hi) {
            throw new IllegalArgumentException();
        }
        if (lo < hi) {
            return new double[]{lo, hi};
        }
        if (lo == hi) {
            double[] dArray2;
            if (isPositive) {
                double[] dArray3 = new double[2];
                dArray3[0] = lo * 0.9;
                dArray2 = dArray3;
                dArray3[1] = hi * 1.1;
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = lo - 1.0;
                dArray2 = dArray4;
                dArray4[1] = hi + 1.0;
            }
            return dArray2;
        }
        if (!Double.isNaN(hi)) {
            double[] dArray5;
            if (isPositive) {
                double[] dArray6 = new double[2];
                dArray6[0] = hi * 0.001;
                dArray5 = dArray6;
                dArray6[1] = hi;
            } else {
                double[] dArray7 = new double[2];
                dArray7[0] = hi - 1.0;
                dArray5 = dArray7;
                dArray7[1] = hi;
            }
            return dArray5;
        }
        if (!Double.isNaN(lo)) {
            double[] dArray8;
            if (isPositive) {
                double[] dArray9 = new double[2];
                dArray9[0] = lo;
                dArray8 = dArray9;
                dArray9[1] = lo * 1000.0;
            } else {
                double[] dArray10 = new double[2];
                dArray10[0] = lo;
                dArray8 = dArray10;
                dArray10[1] = lo + 1.0;
            }
            return dArray8;
        }
        if (isPositive) {
            double[] dArray11 = new double[2];
            dArray11[0] = 1.0;
            dArray = dArray11;
            dArray11[1] = 10.0;
        } else {
            double[] dArray12 = new double[2];
            dArray12[0] = 0.0;
            dArray = dArray12;
            dArray12[1] = 1.0;
        }
        return dArray;
    }

    public static Scaler createRangeScaler(Scaling.RangeScaling rscaling, Subrange dataclip, Span span) {
        double[] dArray;
        double subhi;
        double[] bounds = span.getFiniteBounds(rscaling.isLogLike());
        double lo = bounds[0];
        double hi = bounds[1];
        Scaler scaler0 = rscaling.createScaler(lo, hi);
        if (Subrange.isIdentity(dataclip)) {
            return scaler0;
        }
        double sublo = Scalings.unscale(scaler0, lo, hi, dataclip.getLow());
        if (sublo < (subhi = Scalings.unscale(scaler0, lo, hi, dataclip.getHigh()))) {
            double[] dArray2 = new double[2];
            dArray2[0] = sublo;
            dArray = dArray2;
            dArray2[1] = subhi;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = subhi;
            dArray = dArray3;
            dArray3[1] = sublo;
        }
        double[] bounds1 = dArray;
        return rscaling.createScaler(bounds1[0], bounds1[1]);
    }

    private static class BasicSpan
    implements Span {
        final boolean isBestEfforts_;
        final double lo_;
        final double hi_;
        final double loPos_;
        final double hiPos_;

        BasicSpan(boolean isBestEfforts, double lo, double hi, double loPos, double hiPos) {
            this.isBestEfforts_ = isBestEfforts;
            this.lo_ = lo;
            this.hi_ = hi;
            this.loPos_ = loPos;
            this.hiPos_ = hiPos;
            assert (!(this.loPos_ > this.hiPos_));
        }

        @Override
        public double getLow() {
            return this.lo_;
        }

        @Override
        public double getHigh() {
            return this.hi_;
        }

        @Override
        public double[] getFiniteBounds(boolean isPositive) {
            return BasicRanger.calculateFiniteBounds(isPositive ? this.loPos_ : this.lo_, isPositive ? this.hiPos_ : this.hi_, isPositive);
        }

        @Override
        public Scaler createScaler(Scaling scaling, Subrange dataclip) {
            Scaling.RangeScaling rscaling;
            if (scaling instanceof Scaling.RangeScaling) {
                rscaling = (Scaling.RangeScaling)scaling;
            } else {
                if (!this.isBestEfforts_) {
                    String msg = "Inadequate span " + this + " used for scaling " + scaling;
                    assert (false) : msg;
                    logger_.warning(msg);
                }
                rscaling = scaling.isLogLike() ? Scaling.LOG : Scaling.LINEAR;
            }
            return BasicRanger.createRangeScaler(rscaling, dataclip, this);
        }

        @Override
        public Span limit(double lo, double hi) {
            if (lo > hi) {
                throw new IllegalArgumentException("Bad range: " + lo + " .. " + hi);
            }
            double lo1 = this.lo_;
            double hi1 = this.hi_;
            double loPos1 = this.loPos_;
            double hiPos1 = this.hiPos_;
            if (!Double.isNaN(lo) && !Double.isInfinite(lo)) {
                lo1 = lo;
                if (!(lo <= 0.0)) {
                    loPos1 = lo;
                }
                if (hi1 < this.lo_) {
                    hi1 = lo1;
                    hiPos1 = loPos1;
                }
            }
            if (!(Double.isNaN(hi) || Double.isInfinite(hi) || hi < lo1)) {
                hi1 = hi;
                if (!(hi <= 0.0)) {
                    hiPos1 = hi;
                }
                if (this.lo_ > hi1) {
                    lo1 = hi1;
                    loPos1 = hiPos1;
                }
            }
            return new BasicSpan(this.isBestEfforts_, lo1, hi1, loPos1, hiPos1);
        }

        public int hashCode() {
            int code = 22348;
            code = 23 * code + Float.floatToIntBits((float)this.lo_);
            code = 23 * code + Float.floatToIntBits((float)this.hi_);
            code = 23 * code + Float.floatToIntBits((float)this.loPos_);
            code = 23 * code + Float.floatToIntBits((float)this.hiPos_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof BasicSpan) {
                BasicSpan other = (BasicSpan)o;
                return PlotUtil.doubleEquals(this.lo_, other.lo_) && PlotUtil.doubleEquals(this.hi_, other.hi_) && PlotUtil.doubleEquals(this.loPos_, other.loPos_) && PlotUtil.doubleEquals(this.hiPos_, other.hiPos_);
            }
            return false;
        }
    }
}

