/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.NullCaptioner;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Surround;

public interface PlotFrame {
    public Rectangle getInternalBounds();

    public Surround getSurround();

    public Captioner getCaptioner();

    public static PlotFrame createPlotFrame(Surface surf, boolean withScroll) {
        final Surround surround = surf.getSurround(withScroll);
        final Rectangle intBounds = surf.getPlotBounds();
        final Captioner captioner = surf.getCaptioner();
        return new PlotFrame(){

            @Override
            public Rectangle getInternalBounds() {
                return intBounds;
            }

            @Override
            public Surround getSurround() {
                return surround;
            }

            @Override
            public Captioner getCaptioner() {
                return captioner;
            }
        };
    }

    public static PlotFrame createPlotFrame(Surface[] surfs, boolean withScroll, Rectangle dfltBounds) {
        Captioner captioner;
        Surround surround;
        Rectangle intBounds;
        int ns = surfs.length;
        if (ns > 0) {
            int is;
            Rectangle[] plotBounds = (Rectangle[])Arrays.stream(surfs).map(Surface::getPlotBounds).toArray(Rectangle[]::new);
            intBounds = new Rectangle(plotBounds[0]);
            for (is = 1; is < ns; ++is) {
                intBounds.add(plotBounds[is]);
            }
            surround = new Surround();
            for (is = 0; is < ns; ++is) {
                Surface surf = surfs[is];
                Rectangle box = surf.getPlotBounds();
                Surround surr = surf.getSurround(withScroll);
                Insets insets = surr.toInsets();
                if (box.x - insets.left < intBounds.x) {
                    surround.left = surround.left.union(surr.left);
                }
                if (box.y - insets.top < intBounds.y) {
                    surround.top = surround.top.union(surr.top);
                }
                if (box.x + box.width + insets.right > intBounds.x + intBounds.width) {
                    surround.right = surround.right.union(surr.right);
                }
                if (box.y + box.height + insets.bottom <= intBounds.y + intBounds.height) continue;
                surround.bottom = surround.bottom.union(surr.bottom);
            }
            captioner = surfs[0].getCaptioner();
        } else {
            intBounds = new Rectangle(dfltBounds);
            surround = new Surround();
            captioner = NullCaptioner.INSTANCE;
        }
        return new PlotFrame(){

            @Override
            public Rectangle getInternalBounds() {
                return intBounds;
            }

            @Override
            public Surround getSurround() {
                return surround;
            }

            @Override
            public Captioner getCaptioner() {
                return captioner;
            }
        };
    }
}

