/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.util.IntList;

public abstract class CoordGroup {
    private CoordGroup() {
    }

    public abstract int getBasicPositionCount();

    public abstract Coord[] getExtraCoords();

    public abstract int getExtraPositionCount();

    public abstract int getPosCoordIndex(int var1, DataGeom var2);

    public abstract int getExtraCoordIndex(int var1, DataGeom var2);

    public abstract int[] getRangeCoordIndices(DataGeom var1);

    public abstract boolean isSinglePartialPosition();

    public static CoordGroup createSinglePositionCoordGroup() {
        return new BasicCoordGroup(1, new Coord[0], 0);
    }

    public static CoordGroup createCoordGroup(int nBasicPos, Coord[] extras) {
        return new BasicCoordGroup(nBasicPos, extras, 0);
    }

    public static CoordGroup createCoordGroup(int nBasicPos, Coord[] extras, int nExtraPos) {
        return new BasicCoordGroup(nBasicPos, extras, nExtraPos);
    }

    public static CoordGroup createNoBasicCoordGroup(Coord[] coords, int nExtraPos, boolean[] rangeCoordFlags) {
        return new ExtraPosCoordGroup(coords, nExtraPos, rangeCoordFlags, false);
    }

    public static CoordGroup createPartialCoordGroup(Coord[] coords, boolean[] rangeCoordFlags) {
        return new ExtraPosCoordGroup(coords, 0, rangeCoordFlags, true);
    }

    public static CoordGroup createEmptyCoordGroup() {
        return new BasicCoordGroup(0, new Coord[0], 0);
    }

    private static int getPosCoordCount(DataGeom geom) {
        return geom == null ? 0 : geom.getPosCoords().length;
    }

    private static class ExtraPosCoordGroup
    extends CoordGroup {
        final Coord[] coords_;
        final int nExtraPos_;
        final int[] rangeCoordIndices_;
        final boolean isPartial_;

        ExtraPosCoordGroup(Coord[] coords, int nExtraPos, boolean[] rangeCoordFlags, boolean isPartial) {
            this.coords_ = coords;
            this.nExtraPos_ = nExtraPos;
            IntList ilist = new IntList();
            for (int i = 0; i < coords.length; ++i) {
                if (!rangeCoordFlags[i]) continue;
                ilist.add(i);
            }
            this.rangeCoordIndices_ = ilist.toIntArray();
            this.isPartial_ = isPartial;
        }

        @Override
        public int getBasicPositionCount() {
            return 0;
        }

        @Override
        public Coord[] getExtraCoords() {
            return this.coords_;
        }

        @Override
        public int getExtraPositionCount() {
            return this.nExtraPos_;
        }

        @Override
        public int getPosCoordIndex(int ipos, DataGeom geom) {
            return -1;
        }

        @Override
        public int getExtraCoordIndex(int iExtra, DataGeom geom) {
            return iExtra;
        }

        @Override
        public int[] getRangeCoordIndices(DataGeom geom) {
            return this.rangeCoordIndices_;
        }

        @Override
        public boolean isSinglePartialPosition() {
            return this.isPartial_;
        }
    }

    private static class BasicCoordGroup
    extends CoordGroup {
        final int nBasicPos_;
        final Coord[] extraCoords_;
        final int nExtraPos_;

        BasicCoordGroup(int nBasicPos, Coord[] extraCoords, int nExtraPos) {
            this.nBasicPos_ = nBasicPos;
            this.extraCoords_ = extraCoords;
            this.nExtraPos_ = nExtraPos;
        }

        @Override
        public int getBasicPositionCount() {
            return this.nBasicPos_;
        }

        @Override
        public Coord[] getExtraCoords() {
            return this.extraCoords_;
        }

        @Override
        public int getExtraPositionCount() {
            return this.nExtraPos_;
        }

        @Override
        public int getPosCoordIndex(int ipos, DataGeom geom) {
            return CoordGroup.getPosCoordCount(geom) * ipos;
        }

        @Override
        public int getExtraCoordIndex(int iExtra, DataGeom geom) {
            return CoordGroup.getPosCoordCount(geom) * this.nBasicPos_ + iExtra;
        }

        @Override
        public int[] getRangeCoordIndices(DataGeom geom) {
            int nRange = CoordGroup.getPosCoordCount(geom) * this.nBasicPos_ + this.nExtraPos_;
            int[] ixs = new int[nRange];
            for (int i = 0; i < nRange; ++i) {
                ixs[i] = i;
            }
            return ixs;
        }

        @Override
        public boolean isSinglePartialPosition() {
            return false;
        }
    }
}

