/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import skyview.data.AngScale;
import skyview.data.CoordinateFormatter;
import skyview.geometry.Converter;
import skyview.geometry.Projecter;
import skyview.geometry.Rotater;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;
import skyview.geometry.Util;
import uk.ac.starlink.ttools.plot2.geom.AngScale2;
import uk.ac.starlink.ttools.plot2.geom.GridLine;

public class GridLiner {
    private boolean sexagesimal;
    private int width;
    private int height;
    private Projecter projecter;
    private int xoff;
    private int yoff;
    private double lonCrowd;
    private double latCrowd;
    private static final int GRID_SAMPLE = 10;
    private static final int MAX_SAMPLE = 400;
    private static final int MIN_POINTS = 100;
    private static final int LINE_ELEMENT_MIN = 8;
    private static final int LINE_ELEMENT_MAX = 1024;
    private static final double BOUNDARY_LIMIT = 1.0E-5;
    private static final double LIMIT_EXTENSION = 0.4;
    private ArrayList<GridLine> lines = new ArrayList();
    private String label;
    private int tileXMin = 0;
    private int tileXMax = 0;
    private int tileYMin = 0;
    private int tileYMax = 0;
    private double tileDx;
    private double tileDy;
    private Scaler imageScaler;
    private static final double MAX_CURVE = Math.cos(Math.toRadians(1.0));
    private double[] latLimits;
    private double[] lonLimits;
    Converter forward;

    public GridLiner(Rectangle bounds, Rotater rotater, Projecter projecter, Scaler scaler, boolean sexagesimal, double lonCrowd, double latCrowd) {
        this.width = bounds.width;
        this.height = bounds.height;
        this.xoff = bounds.x;
        this.yoff = bounds.y;
        this.projecter = projecter;
        this.sexagesimal = sexagesimal;
        this.lonCrowd = lonCrowd;
        this.latCrowd = latCrowd;
        this.stdForward(rotater, projecter, scaler);
        try {
            this.imageScaler = scaler.inverse();
        }
        catch (TransformationException e) {
            System.err.println("Error inverting scaler in GridLiner");
            this.imageScaler = null;
        }
        this.tileDx = projecter.getXTiling();
        this.tileDy = projecter.getYTiling();
    }

    private void stdForward(Rotater rotater, Projecter projecter, Scaler scaler) {
        try {
            this.forward = new Converter();
            this.forward.add((Transformer)rotater);
            this.forward.add((Transformer)projecter);
            this.forward.add((Transformer)scaler);
        }
        catch (TransformationException e) {
            System.err.println("Error in building GridLiner:" + (Object)((Object)e));
            throw new Error("Irrecoverable error" + (Object)((Object)e));
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.xoff, this.yoff, this.width, this.height);
    }

    public void grid() throws TransformationException {
        double[] lonValues;
        this.getLimits();
        CoordinateFormatter fm = new CoordinateFormatter();
        fm.setSexagesimal(this.sexagesimal);
        if (this.sexagesimal) {
            fm.setZeroFill(true);
        }
        AngScale2 ang = new AngScale2();
        ang.setSexagesimal(this.sexagesimal);
        double[] latValues = this.scaling(ang, false, this.latLimits[0], this.latLimits[1], this.latCrowd);
        if (this.sexagesimal) {
            ang.setTime(true);
            lonValues = this.scaling(ang, true, this.lonLimits[0] / 15.0, this.lonLimits[1] / 15.0, this.lonCrowd);
            lonValues[0] = lonValues[0] * 15.0;
            lonValues[1] = lonValues[1] * 15.0;
        } else {
            lonValues = this.scaling(ang, false, this.lonLimits[0], this.lonLimits[1], this.lonCrowd);
        }
        double lonLog = Math.log10(lonValues[1]);
        if (this.sexagesimal) {
            lonLog = Math.log10(lonValues[1] / 15.0);
        }
        double latLog = Math.log10(latValues[1]);
        int lonPrec = (int)(3.0 - lonLog);
        int latPrec = (int)(3.0 - latLog);
        if (this.sexagesimal) {
            if (++lonPrec < 6 && lonPrec % 2 == 1) {
                ++lonPrec;
            }
            if (latPrec < 6 && latPrec % 2 == 1) {
                ++latPrec;
            }
        }
        this.extendLimits(0.4);
        double lonMax = this.lonLimits[1];
        if (this.lonLimits[0] > this.lonLimits[1]) {
            lonMax += 360.0;
        }
        boolean drawLon = lonValues[1] < 360.0;
        boolean drawLat = latValues[1] < 180.0;
        Converter save = this.forward;
        int mx = Math.abs(this.tileXMin);
        if (Math.abs(this.tileXMax) > mx) {
            mx = Math.abs(this.tileXMax);
        }
        for (int itileX = -mx; itileX <= mx; ++itileX) {
            for (int itileY = this.tileYMin; itileY <= this.tileYMax; ++itileY) {
                Scaler tiler = new Scaler((double)itileX * this.tileDx, (double)itileY * this.tileDy, 1.0, 0.0, 0.0, 1.0);
                this.forward = new Converter();
                this.forward.add((Transformer)save);
                if (this.imageScaler != null) {
                    this.forward.add((Transformer)this.imageScaler);
                    this.forward.add((Transformer)tiler);
                    this.forward.add((Transformer)this.imageScaler.inverse());
                }
                if (drawLon) {
                    for (double qlon = lonValues[0]; qlon <= lonMax; qlon += lonValues[1]) {
                        double lon = qlon;
                        if (lon > 360.0) {
                            lon -= 360.0;
                        }
                        if (Math.abs(lon - 360.0) < 1.0E-8) {
                            lon = 0.0;
                        }
                        if (this.sexagesimal) {
                            fm.setSeparators(new String[]{"h", "m", "s"});
                            this.setLabel(fm.format(lon / 15.0, lonPrec));
                        } else {
                            fm.setSeparators(new String[]{"\u00b0", "'", "\""});
                            this.setLabel(fm.format(lon, lonPrec));
                        }
                        this.drawLine(lon + 1.0E-10, lon + 1.0E-10, this.latLimits[0], this.latLimits[1]);
                        this.drawLine(lon - 1.0E-10, lon - 1.0E-10, this.latLimits[0], this.latLimits[1]);
                    }
                }
                if (!drawLat) continue;
                for (double lat = latValues[0]; lat <= this.latLimits[1]; lat += latValues[1]) {
                    fm.setSeparators(new String[]{"\u00b0", "'", "\""});
                    this.setLabel(fm.format(lat, latPrec));
                    this.drawLine(this.lonLimits[0], this.lonLimits[1], lat, lat);
                }
            }
        }
    }

    private double[] scaling(AngScale ang, boolean isTime, double min, double max, double crowd) {
        double delt = max - min;
        if (min > max) {
            delt = !isTime ? (delt += 360.0) : (delt += 24.0);
        }
        max = min + delt / crowd;
        return ang.scaling(min, max);
    }

    private void setLabel(String label) {
        if (label != null && label != null) {
            label = label.trim();
            if ((label = label.replace(',', '.')).indexOf(".") > 0) {
                while (label.endsWith("0")) {
                    label = label.substring(0, label.length() - 1);
                }
                if (label.endsWith(".")) {
                    label = label.substring(0, label.length() - 1);
                }
            }
            label = label.replaceFirst("^(?<=[-+]?)0+(?=[0-9].*)", "");
        }
        this.label = label;
    }

    private void extendLimits(double amount) {
        double db = amount / 2.0 * (this.latLimits[1] - this.latLimits[0]);
        this.latLimits[0] = this.latLimits[0] - db;
        this.latLimits[1] = this.latLimits[1] + db;
        if (this.latLimits[0] < -90.0) {
            this.latLimits[0] = -90.0;
        }
        if (this.latLimits[1] > 90.0) {
            this.latLimits[1] = 90.0;
        }
        if (this.lonLimits[0] > this.lonLimits[1]) {
            db = 0.5 * amount * (360.0 + this.lonLimits[1] - this.lonLimits[0]);
            this.lonLimits[0] = this.lonLimits[0] - db;
            this.lonLimits[1] = this.lonLimits[1] + db;
            if (this.lonLimits[1] > this.lonLimits[0]) {
                this.lonLimits[0] = 0.0;
                this.lonLimits[1] = 360.0;
            }
        } else {
            db = 0.5 * amount * (this.lonLimits[1] - this.lonLimits[0]);
            this.lonLimits[0] = this.lonLimits[0] - db;
            this.lonLimits[1] = this.lonLimits[1] + db;
            if (this.lonLimits[1] - this.lonLimits[0] > 360.0) {
                this.lonLimits[0] = 0.0;
                this.lonLimits[1] = 360.0;
            } else {
                if (this.lonLimits[0] < 0.0) {
                    this.lonLimits[0] = this.lonLimits[0] + 360.0;
                }
                if (this.lonLimits[1] > 360.0) {
                    this.lonLimits[1] = this.lonLimits[1] - 360.0;
                }
            }
        }
    }

    private void drawLine(double l0, double l1, double b0, double b1) {
        int npt;
        double[][] line = null;
        for (npt = 8; npt <= 1024; npt *= 2) {
            line = this.getLine(line, l0, l1, b0, b1, npt);
            if (npt >= 1024 || !this.curvature(line)) break;
        }
        this.parseLine(line, l0, l1, b0, b1, npt);
    }

    private double[][] getLine(double[][] oldLine, double l0, double l1, double b0, double b1, int npt) {
        int i;
        double dl = l1 - l0;
        if (l0 > l1) {
            dl += 360.0;
        }
        double db = b1 - b0;
        dl /= (double)npt;
        db /= (double)npt;
        double[][] newLine = new double[npt + 1][2];
        int istart = 0;
        int idelt = 1;
        if (oldLine != null) {
            for (i = 0; i < oldLine.length; ++i) {
                newLine[2 * i] = oldLine[i];
            }
            istart = 1;
            idelt = 2;
        }
        for (i = istart; i < npt + 1; ++i) {
            double[] coords = Util.unit((double)Math.toRadians(l0 + dl * (double)i), (double)Math.toRadians(b0 + db * (double)i));
            this.forward.transform(coords, newLine[i]);
        }
        return newLine;
    }

    private boolean curvature(double[][] points) {
        int i;
        int nx = this.width;
        int ny = this.height;
        int consec = 0;
        int maxConsec = 0;
        int realCount = 0;
        for (i = 0; i < points.length; ++i) {
            if (Double.isNaN(points[i][1])) {
                consec = 0;
                continue;
            }
            if (++consec > maxConsec) {
                maxConsec = consec;
            }
            ++realCount;
        }
        if (realCount > 0 && consec < 3) {
            return true;
        }
        if (realCount == 0) {
            return false;
        }
        for (i = 2; i < points.length; ++i) {
            double costh;
            double[] q = points[i - 1];
            double[] p = points[i - 2];
            double dx0 = q[0] - p[0];
            double[] r = points[i];
            double dx1 = r[0] - q[0];
            double dy0 = q[1] - p[1];
            double dy1 = r[1] - q[1];
            if (Double.isNaN(dx0 + dx1 + dy0 + dy1) || Math.abs(dx0) + Math.abs(dy0) < 1.0 || Math.abs(dx1) + Math.abs(dy1) < 1.0 || (p[0] < 0.0 || p[0] > (double)nx) && (p[1] < 0.0 || p[1] > (double)ny) && (q[0] < 0.0 || q[0] > (double)nx) && (q[1] < 0.0 || q[1] > (double)ny) && (r[0] < 0.0 || r[0] > (double)nx) && (r[1] < 0.0 || r[1] > (double)ny) || !((costh = (dx0 * dx1 + dy0 * dy1) / (Math.sqrt(dx0 * dx0 + dy0 * dy0) * Math.sqrt(dx1 * dx1 + dy1 * dy1))) < MAX_CURVE)) continue;
            return true;
        }
        return false;
    }

    private void parseLine(double[][] line, double l0, double l1, double b0, double b1, int npt) {
        int min = 0;
        int nx = this.width;
        int ny = this.height;
        double dl = l1 - l0;
        if (l0 > l1) {
            dl = 360.0 + dl;
        }
        dl /= (double)npt;
        double db = (b1 - b0) / (double)npt;
        int segStart = -1;
        boolean beginning = true;
        while (min < npt + 1) {
            int i;
            beginning = true;
            double lastDistSq = -1.0;
            for (i = min; i < npt + 1; ++i) {
                double bx;
                double lxx;
                double lx;
                double[] p = line[i];
                if (p[0] > 0.0 && p[0] < (double)nx && p[1] > 0.0 && p[1] < (double)ny) {
                    if (beginning) {
                        if (i != min) {
                            lx = (l0 + (double)(i - 1) * dl) % 360.0;
                            lxx = (lx + dl) % 360.0;
                            bx = b0 + (double)(i - 1) * db;
                            if (Double.isNaN(line[i - 1][0] + line[i - 1][1])) {
                                this.fixNaN(lxx, bx + db, lx, bx, line[i], line[i - 1]);
                            } else {
                                this.fixOut(lxx, bx + db, lx, bx, line[i], line[i - 1]);
                            }
                            segStart = i - 1;
                        } else {
                            segStart = i;
                        }
                        beginning = false;
                        continue;
                    }
                    double[] pm = line[i - 1];
                    double distSq = (pm[0] - p[0]) * (pm[0] - p[0]) + (pm[1] - p[1]) * (pm[1] - p[1]);
                    if (lastDistSq > 0.0 && distSq / lastDistSq > 100.0) {
                        this.addSegment(line, segStart, i - 1, null);
                        beginning = true;
                        lastDistSq = -1.0;
                        --i;
                        break;
                    }
                    lastDistSq = distSq;
                    continue;
                }
                if (beginning) continue;
                lx = (l0 + (double)(i - 1) * dl) % 360.0;
                lxx = (lx + dl) % 360.0;
                bx = b0 + (double)(i - 1) * db;
                double[] newpt = (double[])line[i].clone();
                if (Double.isNaN(line[i][0] + line[i][1])) {
                    this.fixNaN(lx, bx, lxx, bx + db, line[i - 1], newpt);
                } else if (lastDistSq > 0.0) {
                    double dx = line[i][0] - line[i - 1][0];
                    double dy = line[i][1] - line[i - 1][1];
                    if ((dx * dx + dy * dy) / lastDistSq > 100.0) {
                        newpt = null;
                    } else {
                        this.fixOut(lx, bx, lxx, bx + db, line[i - 1], newpt);
                    }
                } else {
                    this.fixOut(lx, bx, lxx, bx + db, line[i - 1], newpt);
                }
                this.addSegment(line, segStart, i - 1, newpt);
                beginning = true;
                min = i + 1;
                break;
            }
            min = i + 1;
        }
        if (!beginning) {
            this.addSegment(line, segStart, npt, null);
        }
    }

    private void addSegment(double[][] line, int segStart, int segEnd, double[] lastPt) {
        if (segEnd - segStart > 2) {
            double[] p = line[segStart];
            double[] q = line[segStart + 1];
            double[] r = line[segStart + 2];
            double sq1 = (p[0] - q[0]) * (p[0] - q[0]) + (p[1] - q[1]) * (p[1] - q[1]);
            double sq2 = (r[0] - q[0]) * (r[0] - q[0]) + (r[1] - q[1]) * (r[1] - q[1]);
            if (sq2 > 0.0 && sq1 / sq2 > 100.0) {
                ++segStart;
            }
        }
        int npt = segEnd - segStart + 1;
        if (lastPt != null) {
            ++npt;
        }
        if (npt < 3) {
            return;
        }
        if (segStart == segEnd && lastPt == null) {
            return;
        }
        double[][] seg = lastPt == null ? new double[segEnd - segStart + 1][] : new double[segEnd - segStart + 2][];
        for (int i = segStart; i <= segEnd; ++i) {
            seg[i - segStart] = new double[]{line[i][0] + (double)this.xoff, line[i][1] + (double)this.yoff};
        }
        if (lastPt != null) {
            seg[segEnd - segStart + 1] = new double[]{lastPt[0] + (double)this.xoff, lastPt[1] + (double)this.yoff};
        }
        GridLine gl = new GridLine();
        gl.line = seg;
        gl.label = this.label;
        for (GridLine gl1 : this.lines) {
            if (!GridLiner.isEqualLines(gl, gl1)) continue;
            return;
        }
        this.lines.add(gl);
    }

    private void fixNaN(double l0, double b0, double l1, double b1, double[] goodPt, double[] bound) {
        int nx = this.width;
        int ny = this.height;
        double db = b1 - b0;
        double dl = l1 - l0;
        if (Math.abs(dl) > 180.0) {
            dl = dl > 0.0 ? 360.0 - dl : -360.0 - dl;
        }
        double lastGoodL = l0;
        double lastGoodB = b0;
        double[] lastGoodPix = (double[])goodPt.clone();
        double[] pix = new double[2];
        while (Math.abs(dl) > 1.0E-5 || Math.abs(db) > 1.0E-5) {
            dl /= 2.0;
            db /= 2.0;
            double testL = lastGoodL + dl;
            if (testL > 360.0) {
                testL -= 360.0;
            }
            if (testL < 0.0) {
                testL += 360.0;
            }
            double testB = lastGoodB + db;
            double[] unit = Util.unit((double)Math.toRadians(testL), (double)Math.toRadians(testB));
            this.forward.transform(unit, pix);
            if (Double.isNaN(pix[0] + pix[1])) continue;
            if (pix[0] < 0.0 || pix[0] > (double)nx || pix[1] < 0.0 || pix[1] > (double)ny) {
                bound[0] = pix[0];
                bound[1] = pix[1];
                this.fixOut(l0, b0, testL, testB, goodPt, bound);
                return;
            }
            lastGoodL = testL;
            lastGoodB = testB;
            lastGoodPix[0] = pix[0];
            lastGoodPix[1] = pix[1];
        }
        bound[0] = lastGoodPix[0];
        bound[1] = lastGoodPix[1];
    }

    private void fixOut(double l0, double b0, double l1, double b1, double[] goodPt, double[] bound) {
        double frac;
        double nx = this.width;
        double ny = this.height;
        double minFrac = 1.0;
        if (bound[0] < 0.0) {
            double frac2 = goodPt[0] / (goodPt[0] - bound[0]);
            if (frac2 < minFrac) {
                minFrac = frac2;
            }
        } else if (bound[0] > nx) {
            double frac3 = (nx - goodPt[0]) / (bound[0] - goodPt[0]);
            if (frac3 < minFrac) {
                minFrac = frac3;
            }
        } else if (bound[1] < 0.0) {
            double frac4 = goodPt[1] / (goodPt[1] - bound[1]);
            if (frac4 < minFrac) {
                minFrac = frac4;
            }
        } else if (bound[1] > ny && (frac = (ny - goodPt[1]) / (bound[1] - goodPt[1])) < minFrac) {
            minFrac = frac;
        }
        bound[0] = goodPt[0] + minFrac * (bound[0] - goodPt[0]);
        bound[1] = goodPt[1] + minFrac * (bound[1] - goodPt[1]);
    }

    private void getLimits() throws TransformationException {
        for (int npt = 10; npt <= 400; npt *= 2) {
            if (!this.getLimitGrid(npt, npt == 400)) continue;
            return;
        }
    }

    private boolean getLimitGrid(int npts, boolean tryRegardless) throws TransformationException {
        Converter reverse = this.forward.inverse();
        int nx = this.width;
        int ny = this.height;
        double dx = nx / (npts - 1);
        double dy = ny / (npts - 1);
        int g2 = npts * npts;
        double[] x = new double[g2];
        double[] y = new double[g2];
        double[] z = new double[g2];
        int count = 0;
        int okCount = 0;
        double[] unscaled = new double[2];
        for (int ix = 0; ix < npts; ++ix) {
            for (int iy = 0; iy < npts; ++iy) {
                double[] tt = new double[]{(double)ix * dx, (double)iy * dy};
                double[] vec = reverse.transform(tt);
                if (!Double.isNaN(vec[2])) {
                    ++okCount;
                    if (this.tileDx > 0.0 || this.tileDy > 0.0) {
                        int test;
                        unscaled = this.imageScaler.transform(tt);
                        if (this.tileDx > 0.0) {
                            test = (int)((unscaled[0] + Math.signum(unscaled[0]) * this.tileDx / 2.0) / this.tileDx);
                            if (test > this.tileXMax) {
                                this.tileXMax = test;
                            } else if (test < this.tileXMin) {
                                this.tileXMin = test;
                            }
                        }
                        if (this.tileDy > 0.0) {
                            test = (int)((unscaled[1] + Math.signum(unscaled[1]) * this.tileDy / 2.0) / this.tileDy);
                            if (test > this.tileYMax) {
                                this.tileYMax = test;
                            }
                            if (test < this.tileYMin) {
                                this.tileYMin = test;
                            }
                        }
                    }
                }
                x[count] = vec[0];
                y[count] = vec[1];
                z[count] = vec[2];
                ++count;
            }
        }
        if (okCount < 100 && !tryRegardless) {
            return false;
        }
        double minz = 2.0;
        double maxz = -2.0;
        for (int i = 0; i < g2; ++i) {
            if (Double.isNaN(z[i])) continue;
            if (z[i] < minz) {
                minz = z[i];
            }
            if (!(z[i] > maxz)) continue;
            maxz = z[i];
        }
        double minLat = Math.toDegrees(Math.asin(minz));
        double maxLat = Math.toDegrees(Math.asin(maxz));
        double minLon = 720.0;
        double maxLon = -720.0;
        double maxLon180 = -720.0;
        double minLon180 = 720.0;
        boolean pole = false;
        for (int i = 0; i < g2; ++i) {
            if (Double.isNaN(z[i])) continue;
            double fac = 1.0 - z[i] * z[i];
            if (fac <= 0.0) {
                pole = true;
                break;
            }
            double lon = Math.toDegrees(Math.atan2(y[i], x[i]));
            if (lon < 0.0) {
                lon += 360.0;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lon > maxLon) {
                maxLon = lon;
            }
            if (lon < 180.0 && lon > maxLon180) {
                maxLon180 = lon;
            }
            if (!(lon > 180.0) || !(lon < minLon180)) continue;
            minLon180 = lon;
        }
        if (pole) {
            minLon = 0.0;
            maxLon = 359.999;
        } else if (maxLon - minLon > 240.0) {
            boolean noNegatives = true;
            for (int i = 0; i < g2; ++i) {
                if (!(x[i] < 0.0)) continue;
                noNegatives = false;
                break;
            }
            if (noNegatives) {
                minLon = minLon180;
                maxLon = maxLon180;
            }
        }
        if (minLon < maxLon && maxLon - minLon > 200.0) {
            minLon = 0.0;
            maxLon = 359.999;
        }
        if (maxLat - minLat > 100.0) {
            minLat = -90.0;
            maxLat = 90.0;
        }
        this.setLimits(new double[]{minLon, maxLon}, new double[]{minLat, maxLat});
        return true;
    }

    private void setLimits(double[] lon, double[] lat) {
        if (lat == null || lon == null || lat.length != 2 || lon.length != 2) {
            System.err.println("Warning: Invalid limit arrays for grid");
        }
        this.latLimits = lat;
        this.lonLimits = lon;
    }

    private static boolean isEqualLines(GridLine gl1, GridLine gl2) {
        if (!gl1.label.equals(gl2.label)) {
            return false;
        }
        double[][] line1 = gl1.line;
        double[][] line2 = gl2.line;
        if (line1.length != line2.length) {
            return false;
        }
        int ns = line1.length;
        for (int is = 0; is < ns; ++is) {
            double[] seg1 = line1[is];
            double[] seg2 = line2[is];
            assert (seg1.length == 2 && seg2.length == 2);
            double dx = seg2[0] - seg1[0];
            double dy = seg2[1] - seg1[1];
            if (!(dx * dx + dy * dy > 1.0)) continue;
            return false;
        }
        return true;
    }

    public void setSexigesimal(boolean flag) {
        this.sexagesimal = flag;
    }

    public void dumpLines() {
        DecimalFormat fm = new DecimalFormat("####.#");
        for (GridLine g : this.lines) {
            int i;
            System.out.print(g.label + ":\n  ");
            for (i = 0; i < g.line.length; ++i) {
                System.out.print(fm.format(g.line[i][0]) + " ");
            }
            System.out.print("\n  ");
            for (i = 0; i < g.line.length; ++i) {
                System.out.print(fm.format(g.line[i][1]) + " ");
            }
            System.out.println("");
        }
    }

    public String[] getLabels() {
        String[] labels = new String[this.lines.size()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.lines.get((int)i).label;
        }
        return labels;
    }

    public double[][][] getLines() {
        double[][][] points = new double[this.lines.size()][][];
        for (int i = 0; i < points.length; ++i) {
            points[i] = this.lines.get((int)i).line;
        }
        return points;
    }
}

