/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.geom.BandDecoration;

public class NavDecorations {
    private static final int BASE_SIZE = 32;
    private static final int BAND_SIZE = 16;
    private static final int CENTER_SIZE = 5;
    private static final double WHEEL_MAG = 2.0;
    private static final Color COLOR = new Color(0x3030F0);
    private static final Icon CENTER = new CenterIcon(5);

    private NavDecorations() {
    }

    public static Decoration createCenterDecoration(Point p) {
        return NavDecorations.center(CENTER, p);
    }

    public static Decoration createWheelDecoration(Point p, double xfact, double yfact, boolean xuse, boolean yuse, Rectangle bounds) {
        if (xuse && yuse) {
            return NavDecorations.center(new WheelZoomIcon2d(32, xfact, yfact), p);
        }
        if (xuse) {
            return NavDecorations.center1d(new WheelZoomIcon1d(32, false, xfact, bounds), false, p, bounds);
        }
        if (yuse) {
            return NavDecorations.center1d(new WheelZoomIcon1d(32, true, yfact, bounds), true, p, bounds);
        }
        return null;
    }

    public static Decoration createDragDecoration(Point p, double xfact, double yfact, boolean xuse, boolean yuse, Rectangle bounds) {
        if (xuse && yuse) {
            return NavDecorations.center(new DragZoomIcon2d(32, xfact, yfact), p);
        }
        if (xuse) {
            return NavDecorations.center1d(new DragZoomIcon1d(32, false, xfact, bounds), false, p, bounds);
        }
        if (yuse) {
            return NavDecorations.center1d(new DragZoomIcon1d(32, true, yfact, bounds), true, p, bounds);
        }
        return null;
    }

    public static BandDecoration createBandDecoration(Point p1, Point p2, boolean xuse, boolean yuse, Rectangle bounds) {
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        if (xuse && yuse) {
            if (dx > 0) {
                return new PlusBandZoomIcon2d(dx, dy).createBandDecoration(p1, bounds);
            }
            if (dx < 0) {
                return new MinusBandZoomIcon2d(16, -dx, -dy).createBandDecoration(p1, bounds);
            }
            return null;
        }
        if (xuse && dx != 0) {
            return ((BandIcon)((Object)(dx > 0 ? new PlusBandZoomIcon1d(false, dx, bounds) : new MinusBandZoomIcon1d(16, false, -dx, bounds)))).createBandDecoration(p1, bounds);
        }
        if (yuse && dy != 0) {
            return ((BandIcon)((Object)(dy < 0 ? new PlusBandZoomIcon1d(true, -dy, bounds) : new MinusBandZoomIcon1d(16, true, dy, bounds)))).createBandDecoration(p1, bounds);
        }
        return null;
    }

    public static Decoration center(Icon icon, Point p) {
        return new Decoration(icon, p.x - icon.getIconWidth() / 2, p.y - icon.getIconHeight() / 2);
    }

    public static Decoration center1d(Icon icon, boolean isY, Point p, Rectangle bounds) {
        Point cp = isY ? new Point(bounds.x, p.y - icon.getIconHeight() / 2) : new Point(p.x - icon.getIconWidth() / 2, bounds.y);
        return new Decoration(icon, cp.x, cp.y);
    }

    public static void drawArrow(Graphics g, int x0, int y0, int x1, int y1) {
        if (x0 != x1 || y0 != y1) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform trans0 = g2.getTransform();
            g2.drawLine(x0, y0, x1, y1);
            g2.translate(x1, y1);
            g2.rotate(Math.atan2(y1 - y0, x1 - x0));
            g2.drawPolyline(new int[]{-5, 0, -5}, new int[]{-5, 0, 5}, 3);
            g2.setTransform(trans0);
        }
    }

    public static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(COLOR);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2;
    }

    private static Rectangle createMinusZoomTarget(Rectangle outer, Rectangle inner, Rectangle bounds) {
        int w = (int)((double)(bounds.width * outer.width) * 1.0 / (double)inner.width);
        int h = (int)((double)(bounds.height * outer.height) * 1.0 / (double)inner.height);
        int x = bounds.x + (bounds.width - w) / 2;
        int y = bounds.y + (bounds.height - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    private static class MinusBandZoomIcon2d
    extends ZoomIcon2d
    implements BandIcon {
        MinusBandZoomIcon2d(int baseSize, int dx, int dy) {
            super(baseSize, baseSize + Math.abs(dx), baseSize + Math.abs(dy));
        }

        @Override
        void doPainting(Graphics g, int xc, int yc) {
            g.drawRect(xc - this.baseSize_, yc - this.baseSize_, 2 * this.baseSize_, 2 * this.baseSize_);
            g.drawRect(xc - Math.abs(this.xTo_), yc - Math.abs(this.yTo_), 2 * Math.abs(this.xTo_), 2 * Math.abs(this.yTo_));
        }

        @Override
        public BandDecoration createBandDecoration(Point origin, Rectangle bounds) {
            Rectangle outer = new Rectangle(origin.x - Math.abs(this.xTo_), origin.y - Math.abs(this.yTo_), 2 * this.xTo_, 2 * this.yTo_);
            Rectangle inner = new Rectangle(origin.x - this.baseSize_, origin.y - this.baseSize_, 2 * this.baseSize_, 2 * this.baseSize_);
            Rectangle target = NavDecorations.createMinusZoomTarget(outer, inner, bounds);
            return new BandDecoration(this, origin.x - Math.abs(this.xTo_), origin.y - Math.abs(this.yTo_), target);
        }
    }

    private static class PlusBandZoomIcon2d
    extends ZoomIcon2d
    implements BandIcon {
        PlusBandZoomIcon2d(int dx, int dy) {
            super(0, dx, dy);
        }

        @Override
        void doPainting(Graphics g, int xc, int yc) {
            g.drawRect(this.xTo_ >= 0 ? xc - this.xTo_ : xc + 2 * this.xTo_, this.yTo_ >= 0 ? yc - this.yTo_ : yc + 2 * this.yTo_, Math.abs(this.xTo_), Math.abs(this.yTo_));
        }

        @Override
        public BandDecoration createBandDecoration(Point origin, Rectangle bounds) {
            Rectangle target = new Rectangle(origin.x, origin.y, this.xTo_, this.yTo_);
            return new BandDecoration(this, origin.x, origin.y, target);
        }
    }

    private static class DragZoomIcon2d
    extends ZoomIcon2d {
        DragZoomIcon2d(int baseSize, double xFact, double yFact) {
            super(baseSize, new double[]{xFact, yFact});
        }

        @Override
        void doPainting(Graphics g, int xc, int yc) {
            g.drawRect(xc - this.baseSize_, yc - this.baseSize_, 2 * this.baseSize_, 2 * this.baseSize_);
            g.drawRect(xc - this.xTo_, yc - this.yTo_, 2 * this.xTo_, 2 * this.yTo_);
            this.drawCenterPoint(g, xc, yc);
        }
    }

    private static class WheelZoomIcon2d
    extends ZoomIcon2d {
        WheelZoomIcon2d(int baseSize, double xFact, double yFact) {
            super(baseSize, new double[]{Math.pow(xFact, 2.0), Math.pow(yFact, 2.0)});
        }

        @Override
        void doPainting(Graphics g, int xc, int yc) {
            this.drawCenterPoint(g, xc, yc);
            g.drawRect(xc - this.baseSize_, yc - this.baseSize_, 2 * this.baseSize_, 2 * this.baseSize_);
            NavDecorations.drawArrow(g, xc - this.baseSize_, yc, xc - this.xTo_, yc);
            NavDecorations.drawArrow(g, xc + this.baseSize_, yc, xc + this.xTo_, yc);
            NavDecorations.drawArrow(g, xc, yc - this.baseSize_, xc, yc - this.yTo_);
            NavDecorations.drawArrow(g, xc, yc + this.baseSize_, xc, yc + this.yTo_);
        }
    }

    @Equality
    private static abstract class ZoomIcon2d
    implements Icon {
        final int baseSize_;
        final int xTo_;
        final int yTo_;

        ZoomIcon2d(int baseSize, int xTo, int yTo) {
            this.baseSize_ = baseSize;
            this.xTo_ = xTo;
            this.yTo_ = yTo;
        }

        ZoomIcon2d(int baseSize, double[] xyFactors) {
            this(baseSize, (int)Math.round((double)baseSize * xyFactors[0]), (int)Math.round((double)baseSize * xyFactors[1]));
        }

        @Override
        public int getIconWidth() {
            return 2 * Math.max(this.baseSize_, Math.abs(this.xTo_));
        }

        @Override
        public int getIconHeight() {
            return 2 * Math.max(this.baseSize_, Math.abs(this.yTo_));
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations.prepareGraphics(g);
            this.doPainting(g, x + this.getIconWidth() / 2, y + this.getIconHeight() / 2);
            g.dispose();
        }

        abstract void doPainting(Graphics var1, int var2, int var3);

        void drawCenterPoint(Graphics g, int xc, int yc) {
            g.drawLine(xc, yc - 5, xc, yc + 5);
            g.drawLine(xc - 5, yc, xc + 5, yc);
        }

        public int hashCode() {
            int code = 44321;
            code = 23 * code + this.getClass().hashCode();
            code = 23 * code + this.baseSize_;
            code = 23 * code + this.xTo_;
            code = 23 * code + this.yTo_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ZoomIcon2d) {
                ZoomIcon2d other = (ZoomIcon2d)o;
                return this.getClass().equals(other.getClass()) && this.baseSize_ == other.baseSize_ && this.xTo_ == other.xTo_ && this.yTo_ == other.yTo_;
            }
            return false;
        }
    }

    private static class MinusBandZoomIcon1d
    extends ZoomIcon1d
    implements BandIcon {
        MinusBandZoomIcon1d(int baseSize, boolean isY, int dc, Rectangle bounds) {
            super(baseSize, isY, baseSize + dc, bounds);
        }

        @Override
        void doPainting(Graphics g, int c0) {
            this.drawSpan(g, c0 - this.baseSize_);
            this.drawSpan(g, c0 + this.baseSize_);
            this.drawSpan(g, c0 - this.cTo_);
            this.drawSpan(g, c0 + this.cTo_);
        }

        @Override
        public BandDecoration createBandDecoration(Point origin, Rectangle bounds) {
            int c0 = this.isY_ ? origin.y : origin.x;
            Rectangle outer = this.createSpanRectangle(c0 - this.cTo_, c0 + this.cTo_);
            Rectangle inner = this.createSpanRectangle(c0 - this.baseSize_, c0 + this.baseSize_);
            Rectangle target = NavDecorations.createMinusZoomTarget(outer, inner, bounds);
            int gx = origin.x - this.getIconWidth() / 2;
            int gy = origin.y - this.getIconHeight() / 2;
            return new BandDecoration(this, gx, gy, target);
        }
    }

    private static class PlusBandZoomIcon1d
    extends ZoomIcon1d
    implements BandIcon {
        private final boolean invert_;

        PlusBandZoomIcon1d(boolean isY, int dc, Rectangle bounds) {
            super(0, isY, dc, bounds);
            this.invert_ = isY;
        }

        @Override
        void doPainting(Graphics g, int c0) {
            this.drawSpan(g, c0);
            this.drawSpan(g, this.invert_ ? c0 - this.cTo_ : c0 + this.cTo_);
        }

        @Override
        public BandDecoration createBandDecoration(Point origin, Rectangle bounds) {
            int c0 = this.isY_ ? origin.y : origin.x;
            Rectangle target = this.invert_ ? this.createSpanRectangle(c0 - this.cTo_, c0) : this.createSpanRectangle(c0, c0 + this.cTo_);
            return this.isY_ ? new BandDecoration(this, this.blo_, c0 - this.cTo_, target) : new BandDecoration(this, c0 - this.cTo_, this.blo_, target);
        }
    }

    private static class DragZoomIcon1d
    extends ZoomIcon1d {
        DragZoomIcon1d(int baseSize, boolean isY, double factor, Rectangle bounds) {
            super(baseSize, isY, new double[]{factor}, bounds);
        }

        @Override
        void doPainting(Graphics g, int c0) {
            this.drawCenterLine(g, c0);
            this.drawSpan(g, c0 - this.baseSize_);
            this.drawSpan(g, c0 + this.baseSize_);
            this.drawSpan(g, c0 - this.cTo_);
            this.drawSpan(g, c0 + this.cTo_);
        }
    }

    private static class WheelZoomIcon1d
    extends ZoomIcon1d {
        WheelZoomIcon1d(int baseSize, boolean isY, double factor, Rectangle bounds) {
            super(baseSize, isY, new double[]{Math.pow(factor, 2.0)}, bounds);
        }

        @Override
        void doPainting(Graphics g, int c0) {
            this.drawCenterLine(g, c0);
            this.drawSpan(g, c0 - this.baseSize_);
            this.drawSpan(g, c0 + this.baseSize_);
            if (this.isY_) {
                int x0 = (this.bhi_ + this.blo_) / 2;
                NavDecorations.drawArrow(g, x0, c0 - this.baseSize_, x0, c0 - this.cTo_);
                NavDecorations.drawArrow(g, x0, c0 + this.baseSize_, x0, c0 + this.cTo_);
            } else {
                int y0 = (this.bhi_ + this.blo_) / 2;
                NavDecorations.drawArrow(g, c0 - this.baseSize_, y0, c0 - this.cTo_, y0);
                NavDecorations.drawArrow(g, c0 + this.baseSize_, y0, c0 + this.cTo_, y0);
            }
        }
    }

    @Equality
    private static abstract class ZoomIcon1d
    implements Icon {
        final int baseSize_;
        final boolean isY_;
        final int cTo_;
        final int blo_;
        final int bhi_;
        private static final Stroke CENTER_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 2.0f);

        public ZoomIcon1d(int baseSize, boolean isY, int cTo, Rectangle bounds) {
            this.baseSize_ = baseSize;
            this.isY_ = isY;
            this.cTo_ = cTo;
            this.blo_ = isY ? bounds.x : bounds.y;
            this.bhi_ = isY ? bounds.x + bounds.width : bounds.y + bounds.height;
        }

        public ZoomIcon1d(int baseSize, boolean isY, double[] cfactor, Rectangle bounds) {
            this(baseSize, isY, (int)Math.round((double)baseSize * cfactor[0]), bounds);
        }

        @Override
        public int getIconWidth() {
            return this.isY_ ? this.bhi_ - this.blo_ : 2 * Math.max(this.baseSize_, this.cTo_);
        }

        @Override
        public int getIconHeight() {
            return this.isY_ ? 2 * Math.max(this.baseSize_, this.cTo_) : this.bhi_ - this.blo_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations.prepareGraphics(g);
            this.doPainting(g, this.isY_ ? y + this.getIconHeight() / 2 : x + this.getIconWidth() / 2);
            g.dispose();
        }

        abstract void doPainting(Graphics var1, int var2);

        void drawSpan(Graphics g, int c1) {
            if (this.isY_) {
                g.drawLine(this.blo_, c1, this.bhi_, c1);
            } else {
                g.drawLine(c1, this.blo_, c1, this.bhi_);
            }
        }

        void drawCenterLine(Graphics g, int c0) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            g2.setStroke(CENTER_STROKE);
            this.drawSpan(g, c0);
            g2.setStroke(stroke0);
        }

        Rectangle createSpanRectangle(int clo, int chi) {
            return this.isY_ ? new Rectangle(this.blo_, clo, this.bhi_ - this.blo_, chi - clo) : new Rectangle(clo, this.blo_, chi - clo, this.bhi_ - this.blo_);
        }

        public int hashCode() {
            int code = 65552;
            code = 23 * code + this.getClass().hashCode();
            code = 23 * code + this.baseSize_;
            code = 23 * code + this.cTo_;
            code = 23 * code + this.blo_;
            code = 23 * code + this.bhi_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ZoomIcon1d) {
                ZoomIcon1d other = (ZoomIcon1d)o;
                return this.getClass().equals(other.getClass()) && this.baseSize_ == other.baseSize_ && this.cTo_ == other.cTo_ && this.blo_ == other.blo_ && this.bhi_ == other.bhi_;
            }
            return false;
        }
    }

    @Equality
    private static class CenterIcon
    implements Icon {
        final int size_;

        CenterIcon(int size) {
            this.size_ = size;
        }

        @Override
        public int getIconWidth() {
            return 2 * this.size_;
        }

        @Override
        public int getIconHeight() {
            return 2 * this.size_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations.prepareGraphics(g);
            g.drawLine(x + this.size_, y, x + this.size_, y + 2 * this.size_);
            g.drawLine(x, y + this.size_, x + 2 * this.size_, y + this.size_);
            g.dispose();
        }

        public String toString() {
            return "center";
        }
    }

    private static interface BandIcon {
        public BandDecoration createBandDecoration(Point var1, Rectangle var2);
    }
}

