/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.Orientation;

public class OrientationPolicy {
    private final String name_;
    private final String description_;
    private final Orientation[] xorients_;
    private final Orientation[] yorients_;
    private final Orientation[] x2orients_;
    private final Orientation[] y2orients_;
    private static final double ANGLE = 45.0;
    public static final OrientationPolicy HORIZONTAL = new OrientationPolicy("horizontal", "axis labels are horizontal", new Orientation[]{Orientation.X}, new Orientation[]{Orientation.Y}, new Orientation[]{Orientation.ANTI_X}, new Orientation[]{Orientation.ANTI_Y});
    public static final OrientationPolicy ANGLED = new OrientationPolicy("angled", "axis labels are angled", new Orientation[]{Orientation.createAngledX(45.0, false)}, new Orientation[]{Orientation.Y}, new Orientation[]{Orientation.createAngledX(45.0, true)}, new Orientation[]{Orientation.ANTI_Y});
    public static final OrientationPolicy ADAPTIVE = new OrientationPolicy("adaptive", "axis labels are horizontal if possible, but angled if necessary to fit more in", new Orientation[]{Orientation.X, Orientation.createAngledX(45.0, false)}, new Orientation[]{Orientation.Y}, new Orientation[]{Orientation.ANTI_X, Orientation.createAngledX(45.0, true)}, new Orientation[]{Orientation.ANTI_Y});
    private static final OrientationPolicy[] OPTIONS = new OrientationPolicy[]{HORIZONTAL, ANGLED, ADAPTIVE};

    public OrientationPolicy(String name, String description, Orientation[] xorients, Orientation[] yorients, Orientation[] x2orients, Orientation[] y2orients) {
        this.name_ = name;
        this.description_ = description;
        this.xorients_ = xorients;
        this.yorients_ = yorients;
        this.x2orients_ = x2orients;
        this.y2orients_ = y2orients;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public Orientation[] getOrientationsX() {
        return (Orientation[])this.xorients_.clone();
    }

    public Orientation[] getOrientationsY() {
        return (Orientation[])this.yorients_.clone();
    }

    public Orientation[] getOrientationsX2() {
        return (Orientation[])this.x2orients_.clone();
    }

    public Orientation[] getOrientationsY2() {
        return (Orientation[])this.y2orients_.clone();
    }

    public String toString() {
        return this.name_;
    }

    public static OrientationPolicy[] getOptions() {
        return (OrientationPolicy[])OPTIONS.clone();
    }
}

