/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.SingleGangerFactory;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.CubeAspect;
import uk.ac.starlink.ttools.plot2.geom.CubeSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AreaForm;
import uk.ac.starlink.ttools.plot2.layer.CentralForm;
import uk.ac.starlink.ttools.plot2.layer.ContourPlotter;
import uk.ac.starlink.ttools.plot2.layer.LabelPlotter;
import uk.ac.starlink.ttools.plot2.layer.Line3dPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.PairLinkForm;
import uk.ac.starlink.ttools.plot2.layer.PolygonForms;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.SizeForm;
import uk.ac.starlink.ttools.plot2.layer.SizeXyForm;
import uk.ac.starlink.ttools.plot2.layer.SphereGridPlotter;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;

public class SpherePlotType
implements PlotType<CubeSurfaceFactory.Profile, CubeAspect> {
    private static final CubeSurfaceFactory SURFACE_FACTORY = new CubeSurfaceFactory(true);
    private static final SpherePlotType INSTANCE = new SpherePlotType();
    private final DataGeom[] dataGeoms_ = new DataGeom[]{SphereDataGeom.INSTANCE};

    private SpherePlotType() {
    }

    @Override
    public DataGeom[] getPointDataGeoms() {
        return this.dataGeoms_;
    }

    @Override
    public Plotter<?>[] getPlotters() {
        ArrayList<Plotter> list = new ArrayList<Plotter>();
        ShapeForm[] forms = new ShapeForm[]{MarkForm.SINGLE, SizeForm.getInstance(), SizeXyForm.getInstance(), PairLinkForm.getInstance(), MarkForm.PAIR, PolygonForms.QUAD, MarkForm.QUAD, PolygonForms.ARRAY, AreaForm.SPHERE_INSTANCE, CentralForm.SPHERE_INSTANCE};
        ShapePlotter[] shapePlotters = ShapePlotter.createShapePlotters(forms, ShapeMode.MODES_3D);
        list.addAll(Arrays.asList(shapePlotters));
        list.addAll(Arrays.asList(LabelPlotter.POINT_INSTANCE, LabelPlotter.AREA_SPHERE_INSTANCE, new Line3dPlotter(), new ContourPlotter(true), new SphereGridPlotter()));
        return list.toArray(new Plotter[0]);
    }

    @Override
    public SurfaceFactory<CubeSurfaceFactory.Profile, CubeAspect> getSurfaceFactory() {
        return SURFACE_FACTORY;
    }

    @Override
    public GangerFactory<CubeSurfaceFactory.Profile, CubeAspect> getGangerFactory() {
        return SingleGangerFactory.instance();
    }

    @Override
    public PaperTypeSelector getPaperTypeSelector() {
        return PaperTypeSelector.SELECTOR_3D;
    }

    public String toString() {
        return "sphere";
    }

    public static SpherePlotType getInstance() {
        return INSTANCE;
    }
}

