/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.plot2.Anchor;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabellers;
import uk.ac.starlink.ttools.plot2.geom.SkySys;

public abstract class TickSkyAxisLabeller
implements SkyAxisLabeller {
    private final String name_;
    private final String description_;
    private final boolean labelSys_;
    public static Anchor X_ANCHOR = Anchor.N;
    public static Anchor Y_ANCHOR = Anchor.E;

    public TickSkyAxisLabeller(String name, String description, boolean labelSys) {
        this.name_ = name;
        this.description_ = description;
        this.labelSys_ = labelSys;
    }

    @Override
    public String getLabellerName() {
        return this.name_;
    }

    @Override
    public String getLabellerDescription() {
        return this.description_;
    }

    @Override
    public AxisAnnotation createAxisAnnotation(GridLiner gridLiner, Captioner captioner, SkySys skySys) {
        Caption[] labels = Arrays.stream(gridLiner.getLabels()).map(SkyAxisLabellers::labelCaption).collect(Collectors.toList()).toArray(new Caption[0]);
        SkyTick[] ticks = this.calculateTicks(gridLiner.getLines(), labels, gridLiner.getBounds());
        ticks = this.removeOverlaps(ticks, captioner);
        return new TickAxisAnnotation(ticks, gridLiner.getBounds(), captioner, this.labelSys_ ? skySys : null);
    }

    protected abstract SkyTick[] calculateTicks(double[][][] var1, Caption[] var2, Rectangle var3);

    protected SkyTick[] removeOverlaps(SkyTick[] ticks, Captioner captioner) {
        LinkedHashMap<SkyTick, Rectangle> tickMap = new LinkedHashMap<SkyTick, Rectangle>();
        for (int it = 0; it < ticks.length; ++it) {
            SkyTick tick1 = ticks[it];
            Rectangle box1 = tick1.getCaptionBounds(captioner);
            Iterator tit = tickMap.keySet().iterator();
            while (tit.hasNext() && tick1 != null) {
                SkyTick tick0 = (SkyTick)tit.next();
                Rectangle box0 = tick0.getCaptionBounds(captioner);
                if (!box0.intersects(box1)) continue;
                tick1 = null;
            }
            if (tick1 == null) continue;
            tickMap.put(tick1, box1);
        }
        return tickMap.keySet().toArray(new SkyTick[0]);
    }

    public static SkyTick createExternalTick(Caption label, double[][] line, Rectangle bounds) {
        for (int is = 0; is < line.length; ++is) {
            int y;
            int x;
            double theta;
            double[] seg = line[is];
            double px = seg[0];
            double py = seg[1];
            int iseg1 = is == 0 ? 1 : is;
            int iseg0 = iseg1 - 1;
            assert (iseg0 >= 0);
            if (iseg1 < line.length) {
                double dx = line[iseg1][0] - line[iseg0][0];
                double dy = line[iseg1][1] - line[iseg0][1];
                theta = Math.atan2(dy, dx);
            } else {
                theta = Double.NaN;
            }
            double upness = 1.0 - Math.abs(1.0 - Math.abs(2.0 * theta / Math.PI));
            assert (upness >= 0.0 && upness <= 1.0);
            if (Math.abs(py - (double)bounds.y - (double)bounds.height) < 0.5 && upness >= 0.5 && (x = (int)Math.round(px)) >= bounds.x & x < bounds.x + bounds.width) {
                return new SkyTick(label, x, bounds.y + bounds.height, X_ANCHOR);
            }
            if (!(Math.abs(px - (double)bounds.x) < 0.5) || !(upness <= 0.5) || (y = (int)Math.round(py)) < bounds.y || y >= bounds.y + bounds.height) continue;
            return new SkyTick(label, bounds.x, y, Y_ANCHOR);
        }
        return null;
    }

    public static SkyTick createInternalTick(Caption label, double[][] line) {
        int nseg = line.length;
        double[] dists = new double[nseg];
        for (int is1 = 1; is1 < nseg; ++is1) {
            int is0 = is1 - 1;
            double[] seg0 = line[is0];
            double[] seg1 = line[is1];
            double segleng = Math.hypot(seg1[0] - seg0[0], seg1[1] - seg0[1]);
            dists[is1] = dists[is0] + segleng;
        }
        double halfway = 0.5 * dists[nseg - 1];
        int iseg0 = -1;
        double segfrac = Double.NaN;
        for (int is1 = 1; is1 < nseg && iseg0 < 0; ++is1) {
            int is0 = is1 - 1;
            double d0 = dists[is0];
            double d1 = dists[is1];
            if (!(d1 >= halfway)) continue;
            iseg0 = is0;
            segfrac = d1 == d0 ? 0.0 : (halfway - d0) / (d1 - d0);
        }
        assert (iseg0 >= 0 && iseg0 < nseg - 1 && segfrac >= 0.0 && segfrac <= 1.0);
        int iseg1 = iseg0 + 1;
        double x0 = line[iseg0][0];
        double y0 = line[iseg0][1];
        double x1 = line[iseg1][0];
        double y1 = line[iseg1][1];
        double dx = x1 - x0;
        double dy = y1 - y0;
        int px = (int)Math.round(x0 + segfrac * dx);
        int py = (int)Math.round(y0 + segfrac * dy);
        double theta = Math.atan2(dy, dx);
        if (theta > 1.5707963267948966) {
            theta -= Math.PI;
        } else if (theta < -1.5707963267948966) {
            theta += Math.PI;
        }
        Anchor.HorizontalAnchor onAnchor = new Anchor.HorizontalAnchor(){

            @Override
            protected int[] getOffset(Rectangle bounds, int pad) {
                return new int[]{-bounds.width / 2, -2};
            }
        };
        Anchor anchor = Anchor.createAngledAnchor(theta, onAnchor);
        return new SkyTick(label, px, py, anchor);
    }

    private static Caption textToCaption(String txt) {
        return Caption.createCaption(txt, txt.replace(" ", "\\ "));
    }

    public static class SkyTick {
        private final Caption label_;
        private final int px_;
        private final int py_;
        private final Anchor anchor_;

        public SkyTick(Caption label, int px, int py, Anchor anchor) {
            this.label_ = label;
            this.px_ = px;
            this.py_ = py;
            this.anchor_ = anchor;
        }

        private Rectangle getCaptionBounds(Captioner captioner) {
            return this.getCaptionBoundsAt(this.px_, this.py_, captioner);
        }

        private Rectangle getCaptionBoundsAt(int px, int py, Captioner captioner) {
            return this.anchor_.getCaptionBounds(this.label_, px, py, captioner);
        }
    }

    private static class TickAxisAnnotation
    implements AxisAnnotation {
        private final SkyTick[] ticks_;
        private final Rectangle plotBounds_;
        private final Captioner captioner_;
        private final SkySys skySys_;
        private final Caption lonCaption_;
        private final Caption latCaption_;
        private final int hLon_;
        private final int hLat_;

        TickAxisAnnotation(SkyTick[] ticks, Rectangle plotBounds, Captioner captioner, SkySys skySys) {
            this.ticks_ = ticks;
            this.plotBounds_ = plotBounds;
            this.captioner_ = captioner;
            this.skySys_ = skySys;
            if (skySys != null) {
                this.lonCaption_ = TickSkyAxisLabeller.textToCaption(this.skySys_.getLongitudeName());
                this.latCaption_ = TickSkyAxisLabeller.textToCaption(this.skySys_.getLatitudeName());
                this.hLon_ = this.captioner_.getCaptionBounds((Caption)this.lonCaption_).height;
                this.hLat_ = this.captioner_.getCaptionBounds((Caption)this.latCaption_).height;
            } else {
                this.lonCaption_ = null;
                this.latCaption_ = null;
                this.hLon_ = 0;
                this.hLat_ = 0;
            }
        }

        @Override
        public Surround getSurround(boolean withScroll) {
            Surround surround = this.getTickSurround(withScroll);
            if (this.skySys_ != null) {
                int lonExtra = this.hLon_ + this.hLon_ / 2;
                surround.bottom.extent += lonExtra;
                int latExtra = this.hLat_ + this.hLat_ / 2;
                surround.left.extent += latExtra;
            }
            return surround;
        }

        private Surround getTickSurround(boolean withScroll) {
            boolean isAllExternal = Arrays.stream(this.ticks_).allMatch(t -> ((SkyTick)t).anchor_ == X_ANCHOR || ((SkyTick)t).anchor_ == Y_ANCHOR);
            if (isAllExternal) {
                Surround surround = new Surround();
                for (SkyTick tick : this.ticks_) {
                    Rectangle tickBox = this.getTickBounds(tick, withScroll);
                    boolean isExternal = surround.addExternalRectangle(this.plotBounds_, tickBox);
                    assert (isExternal);
                }
                return surround;
            }
            if (withScroll) {
                return new Surround();
            }
            Rectangle bounds = new Rectangle(this.plotBounds_);
            for (SkyTick tick : this.ticks_) {
                bounds.add(tick.getCaptionBounds(this.captioner_));
            }
            int top = this.plotBounds_.y - bounds.y;
            int left = this.plotBounds_.x - bounds.x;
            int bottom = bounds.y + bounds.height - this.plotBounds_.y - this.plotBounds_.height;
            int right = bounds.x + bounds.width - this.plotBounds_.x - this.plotBounds_.width;
            assert (top >= 0 && left >= 0 && bottom >= 0 && right >= 0);
            return Surround.fromInsets(new Insets(top, left, bottom, right));
        }

        @Override
        public void drawLabels(Graphics g) {
            for (int i = 0; i < this.ticks_.length; ++i) {
                SkyTick tick = this.ticks_[i];
                tick.anchor_.drawCaption(tick.label_, tick.px_, tick.py_, this.captioner_, g);
            }
            if (this.skySys_ != null) {
                Insets insets = this.getTickSurround(false).toInsets();
                Point pLon = new Point(this.plotBounds_.x + this.plotBounds_.width / 2, this.plotBounds_.y + this.plotBounds_.height + insets.bottom);
                Point pLat = new Point(this.plotBounds_.x - insets.left - 2 * this.hLat_, this.plotBounds_.y + this.plotBounds_.height / 2);
                Anchor.N.drawCaption(this.lonCaption_, pLon.x, pLon.y, this.captioner_, g);
                Anchor.createAngledAnchor(-1.5707963267948966, Anchor.N).drawCaption(this.latCaption_, pLat.x, pLat.y, this.captioner_, g);
            }
        }

        private Rectangle getTickBounds(SkyTick tick, boolean withScroll) {
            Rectangle box = tick.getCaptionBounds(this.captioner_);
            if (withScroll) {
                Point[] points;
                Anchor anchor = tick.anchor_;
                if (anchor == X_ANCHOR) {
                    int py = this.plotBounds_.y + this.plotBounds_.height;
                    points = new Point[]{new Point(this.plotBounds_.x, py), new Point(this.plotBounds_.x + this.plotBounds_.width, py)};
                } else if (anchor == Y_ANCHOR) {
                    int px = this.plotBounds_.x;
                    points = new Point[]{new Point(px, this.plotBounds_.y), new Point(px, this.plotBounds_.y + this.plotBounds_.height)};
                } else {
                    points = new Point[]{};
                }
                for (int ip = 0; ip < points.length; ++ip) {
                    Point p = points[ip];
                    box.add(tick.getCaptionBoundsAt(p.x, p.y, this.captioner_));
                }
            }
            return box;
        }
    }
}

