/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.AreaCoord;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.SkyCoord;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PolygonForms;
import uk.ac.starlink.ttools.plot2.layer.PolygonOutliner;
import uk.ac.starlink.ttools.plot2.layer.PolygonShape;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;

public abstract class AreaForm<DG extends DataGeom>
implements ShapeForm {
    private final AreaCoord<DG> areaCoord_;
    private final Coord[] otherCoords_;
    public static final FloatingCoord RADIAL_COORD = FloatingCoord.createCoord(SkyCoord.createRadiusInputMeta(), false);
    public static final AreaForm<PlaneDataGeom> PLANE_INSTANCE = new AreaForm<PlaneDataGeom>(AreaCoord.PLANE_COORD, new Coord[0]){

        @Override
        protected PolygonOutliner createOutliner(PolygonShape polyShape, int minSize, MarkerShape minShape) {
            return PolygonOutliner.createPlaneAreaOutliner(this.getAreaCoord(), 0, polyShape, minSize, minShape);
        }
    };
    public static final AreaForm<SkyDataGeom> SKY_INSTANCE = new AreaForm<SkyDataGeom>(AreaCoord.SKY_COORD, new Coord[0]){

        @Override
        protected PolygonOutliner createOutliner(PolygonShape polyShape, int minSize, MarkerShape minShape) {
            return PolygonOutliner.createSkyAreaOutliner(this.getAreaCoord(), 0, polyShape, minSize, minShape);
        }
    };
    public static final AreaForm<SphereDataGeom> SPHERE_INSTANCE = new AreaForm<SphereDataGeom>(AreaCoord.SPHERE_COORD, new Coord[]{RADIAL_COORD}){

        @Override
        protected PolygonOutliner createOutliner(PolygonShape polyShape, int minSize, MarkerShape minShape) {
            return PolygonOutliner.createSphereAreaOutliner(this.getAreaCoord(), 0, RADIAL_COORD, 1, polyShape, minSize, minShape);
        }
    };
    public static final ConfigKey<PolygonShape> POLYSHAPE_KEY = PolygonForms.POLYSHAPE_KEY;
    public static final ConfigKey<Integer> POLYTHICK_KEY = PolygonForms.POLYTHICK_KEY;

    private AreaForm(AreaCoord<DG> areaCoord, Coord[] otherCoords) {
        this.areaCoord_ = areaCoord;
        this.otherCoords_ = otherCoords;
    }

    @Override
    public String getFormName() {
        return "Area";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_AREA;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a region on the plotting surface", "specified by a string or array of numbers.", "The area may be specified as an STC-S string", "(as for example in an ObsCore or EPN-TAP", "<code>s_region</code> column)", "or using an array of numbers representing a", "polygon, circle or point as flagged using the DALI/VOTable", "extended type (xtype) marker,", "or as an ASCII-encoded MOC.", "</p>", "<p>Areas smaller than a configurable threshold size", "in pixels are by default represented by a replacement marker,", "so the position of even a very small area", "is still visible on the screen.", "</p>", "<p>This plot type is generally intended for displaying", "relatively small shapes such as instrument footprints.", "It can be used for areas that are larger as well,", "but there may be issues with use,", "for instance auto-determination of the initial plot region", "may not work so well,", "and the rendering of shapes that are large relative to the sky", "may be inaccurate.", "These issues may be addressed in future releases.", "</p>"});
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public Coord[] getExtraCoords() {
        return PlotUtil.arrayConcat(new Coord[]{this.areaCoord_}, this.otherCoords_);
    }

    @Override
    public int getExtraPositionCount() {
        return 1;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{POLYSHAPE_KEY, POLYTHICK_KEY, PolygonOutliner.MINSIZE_KEY, PolygonOutliner.MINSHAPE_KEY};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        PolygonShape basicShape = config.get(POLYSHAPE_KEY);
        int nthick = config.get(POLYTHICK_KEY);
        PolygonShape polyShape = nthick == 0 ? basicShape : basicShape.toThicker(nthick);
        int minSize = config.get(PolygonOutliner.MINSIZE_KEY);
        MarkerShape minShape = config.get(PolygonOutliner.MINSHAPE_KEY);
        return this.createOutliner(polyShape, minSize, minShape);
    }

    protected abstract PolygonOutliner createOutliner(PolygonShape var1, int var2, MarkerShape var3);

    public AreaCoord<DG> getAreaCoord() {
        return this.areaCoord_;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        DataGeom tgeom = geom;
        return this.areaCoord_.getAreaDataGeom(tgeom);
    }
}

