/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.FatLineXYShape;
import uk.ac.starlink.ttools.plot2.layer.FillPixer;
import uk.ac.starlink.ttools.plot2.layer.LineGlyph;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.StrokeKit;
import uk.ac.starlink.ttools.plot2.layer.XYShape;

@Equality
public abstract class BasicXYShape
extends XYShape {
    private static final BasicXYShape[] XYSHAPES = BasicXYShape.createXYShapes();

    public BasicXYShape(String name, int maxCacheRadius, Glyph pointGlyph) {
        super(name, maxCacheRadius, pointGlyph);
    }

    @Equality
    public abstract XYShape toThicker(int var1);

    public static BasicXYShape[] getXYShapes() {
        return (BasicXYShape[])XYSHAPES.clone();
    }

    private static BasicXYShape[] createXYShapes() {
        return new BasicXYShape[]{BasicXYShape.createRectangleShape("Open Rectangle", false), BasicXYShape.createTriangleShape("Open Triangle", false, true), BasicXYShape.createTriangleShape("Open Triangle Down", false, false), BasicXYShape.createDiamondShape("Open Diamond", false), BasicXYShape.createEllipseShape("Open Ellipse", false), BasicXYShape.createRectangleShape("Filled Rectangle", true), BasicXYShape.createTriangleShape("Filled Triangle", true, true), BasicXYShape.createTriangleShape("Filled Triangle Down", true, false), BasicXYShape.createDiamondShape("Filled Diamond", true), BasicXYShape.createEllipseShape("Filled Ellipse", true)};
    }

    private static int getPixelMaxCacheRadius(boolean isFill) {
        return isFill ? 16 : 24;
    }

    private static BasicXYShape createEllipseShape(String name, boolean isFill) {
        int rCache = BasicXYShape.getPixelMaxCacheRadius(isFill);
        if (isFill) {
            return new DrawingShape(name, rCache, false){

                @Override
                public LineGlyph createLineGlyph(final int dx, final int dy) {
                    return new LineGlyph(){

                        @Override
                        public Rectangle getPixelBounds() {
                            return new Rectangle(-dx, -dy, dx * 2 + 1, dy * 2 + 1);
                        }

                        @Override
                        public void paintGlyph(Graphics g, StrokeKit skit) {
                            g.fillOval(-dx, -dy, 2 * dx, 2 * dy);
                        }

                        @Override
                        public void drawShape(PixelDrawing d) {
                            d.fillOval(-dx, -dy, 2 * dx, 2 * dy);
                        }
                    };
                }
            };
        }
        return new DrawingShape(name, rCache, true){

            @Override
            public LineGlyph createLineGlyph(final int dx, final int dy) {
                return new LineGlyph(){

                    @Override
                    public Rectangle getPixelBounds() {
                        return new Rectangle(-dx, -dy, dx * 2 + 1, dy * 2 + 1);
                    }

                    @Override
                    public void paintGlyph(Graphics g, StrokeKit skit) {
                        Graphics2D g2 = (Graphics2D)g;
                        Stroke stroke0 = g2.getStroke();
                        g2.setStroke(skit.getRound());
                        g.drawOval(-dx, -dy, 2 * dx, 2 * dy);
                        g2.setStroke(stroke0);
                    }

                    @Override
                    public void drawShape(PixelDrawing d) {
                        d.drawOval(-dx, -dy, 2 * dx, 2 * dy);
                    }
                };
            }
        };
    }

    private static BasicXYShape createRectangleShape(String name, boolean isFill) {
        if (isFill) {
            return new BlockShape(name);
        }
        PolygonFunction polyFunc = (dx, dy) -> new Polygon(new int[]{-dx, -dx, dx, dx}, new int[]{-dy, dy, dy, -dy}, 4);
        return new OpenPolygonShape(name, polyFunc){

            @Override
            public XYShape toThicker(int nthick) {
                PixerFactory kernel = LineGlyph.createKernel(MarkerShape.FILLED_SQUARE, nthick);
                BasicStroke stroke = new BasicStroke(1.0f + (float)(2 * nthick), 0, 0);
                StrokeKit skit = new StrokeKit(stroke, stroke);
                return new FatXYShape(this, nthick, kernel, skit);
            }
        };
    }

    private static BasicXYShape createTriangleShape(String name, boolean isFill, boolean isUp) {
        PolygonFunction polyFunc = (dx, dy) -> {
            int[] nArray;
            int[] xoffs = new int[]{-dx, dx, 0};
            if (isUp) {
                int[] nArray2 = new int[3];
                nArray2[0] = dy;
                nArray2[1] = dy;
                nArray = nArray2;
                nArray2[2] = -dy;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = -dy;
                nArray3[1] = -dy;
                nArray = nArray3;
                nArray3[2] = dy;
            }
            int[] yoffs = nArray;
            return new Polygon(xoffs, yoffs, 3);
        };
        return isFill ? new FillPolygonShape(name, polyFunc) : new OpenPolygonShape(name, polyFunc);
    }

    private static BasicXYShape createDiamondShape(String name, boolean isFill) {
        PolygonFunction polyFunc = (dx, dy) -> new Polygon(new int[]{-dx, 0, dx, 0}, new int[]{0, dy, 0, -dy}, 4);
        return isFill ? new FillPolygonShape(name, polyFunc) : new OpenPolygonShape(name, polyFunc);
    }

    @Equality
    private static class FatXYShape
    extends XYShape {
        private final DrawingShape shape_;
        private final int nthick_;
        private final PixerFactory kernel_;
        private final StrokeKit strokeKit_;

        public FatXYShape(DrawingShape shape, int nthick) {
            this(shape, nthick, LineGlyph.createThickKernel(nthick), LineGlyph.createThickStrokeKit(nthick));
        }

        public FatXYShape(DrawingShape shape, int nthick, PixerFactory kernel, StrokeKit strokeKit) {
            super(shape.getName() + nthick, 10, FatLineXYShape.createPointGlyph(kernel, strokeKit));
            this.shape_ = shape;
            this.nthick_ = nthick;
            this.kernel_ = kernel;
            this.strokeKit_ = strokeKit;
        }

        @Override
        public Glyph createGlyph(short sx, short sy) {
            return this.shape_.createLineGlyph(sx, sy).toThicker(this.kernel_, this.strokeKit_);
        }

        public int hashCode() {
            int code = -66294;
            code = 23 * code + this.shape_.hashCode();
            code = 23 * code + this.nthick_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FatXYShape) {
                FatXYShape other = (FatXYShape)o;
                return this.shape_.equals(other.shape_) && this.nthick_ == other.nthick_;
            }
            return false;
        }
    }

    private static abstract class DrawingShape
    extends BasicXYShape {
        private final boolean canFat_;

        DrawingShape(String name, int maxCacheRadius, boolean canFat) {
            super(name, maxCacheRadius, XYShape.POINT);
            this.canFat_ = canFat;
        }

        abstract LineGlyph createLineGlyph(int var1, int var2);

        @Override
        public Glyph createGlyph(short sx, short sy) {
            short x = sx;
            short y = sy;
            Rectangle bounds = new Rectangle(-x, -y, x * 2 + 1, y * 2 + 1);
            final LineGlyph lineGlyph = this.createLineGlyph(sx, sy);
            if (this.isCached(sx, sy)) {
                final PixerFactory pfact = Pixers.createPixerCopier(lineGlyph.createPixer(bounds));
                return new Glyph(){

                    @Override
                    public void paintGlyph(Graphics g) {
                        lineGlyph.paintGlyph(g);
                    }

                    @Override
                    public Pixer createPixer(Rectangle clip) {
                        return Pixers.createClippedPixer(pfact, clip);
                    }
                };
            }
            return lineGlyph;
        }

        @Override
        public XYShape toThicker(int nthick) {
            return this.canFat_ ? new FatXYShape(this, nthick) : this;
        }
    }

    private static class FillPolygonShape
    extends BasicXYShape {
        private final PolygonFunction polyFunc_;

        FillPolygonShape(String name, PolygonFunction polyFunc) {
            super(name, 16, XYShape.POINT);
            this.polyFunc_ = polyFunc;
        }

        @Override
        public XYShape toThicker(int nthick) {
            return this;
        }

        @Override
        protected Glyph createGlyph(short sx, short sy) {
            if (sx == 0 && sy == 0) {
                return POINT;
            }
            Polygon poly = this.polyFunc_.toPolygon(sx, sy);
            final int[] xs = poly.xpoints;
            final int[] ys = poly.ypoints;
            final int np = poly.npoints;
            return new Glyph(){

                @Override
                public void paintGlyph(Graphics g) {
                    g.fillPolygon(xs, ys, np);
                }

                @Override
                public Pixer createPixer(Rectangle clip) {
                    return new FillPixer(xs, ys, np, clip);
                }
            };
        }
    }

    private static class OpenPolygonShape
    extends DrawingShape {
        private final PolygonFunction polyFunc_;

        OpenPolygonShape(String name, PolygonFunction polyFunc) {
            super(name, BasicXYShape.getPixelMaxCacheRadius(false), true);
            this.polyFunc_ = polyFunc;
        }

        @Override
        public LineGlyph createLineGlyph(final int dx, final int dy) {
            final Polygon polygon = this.polyFunc_.toPolygon(dx, dy);
            return new LineGlyph(){

                @Override
                public Rectangle getPixelBounds() {
                    return new Rectangle(-dx, -dy, dx * 2 + 1, dy * 2 + 1);
                }

                @Override
                public void paintGlyph(Graphics g, StrokeKit skit) {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke stroke0 = g2.getStroke();
                    g2.setStroke(skit.getRound());
                    g2.drawPolygon(polygon);
                    g2.setStroke(stroke0);
                }

                @Override
                public void drawShape(PixelDrawing d) {
                    int n = polygon.npoints;
                    int[] xs = polygon.xpoints;
                    int[] ys = polygon.ypoints;
                    for (int i = 0; i < n - 1; ++i) {
                        d.drawLine(xs[i], ys[i], xs[i + 1], ys[i + 1]);
                    }
                    d.drawLine(xs[n - 1], ys[n - 1], xs[0], ys[0]);
                }
            };
        }
    }

    @FunctionalInterface
    private static interface PolygonFunction {
        public Polygon toPolygon(int var1, int var2);
    }

    private static class BlockShape
    extends BasicXYShape {
        BlockShape(String name) {
            super(name, 6, XYShape.POINT);
        }

        @Override
        public XYShape toThicker(int nthick) {
            return this;
        }

        @Override
        protected Glyph createGlyph(short sx, short sy) {
            if (sx == 0 && sy == 0) {
                return POINT;
            }
            final short ix = sx;
            final short iy = sy;
            return new Glyph(){

                @Override
                public void paintGlyph(Graphics g) {
                    g.fillRect(-ix, -iy, 2 * ix, 2 * iy);
                }

                @Override
                public Pixer createPixer(Rectangle clip) {
                    int xmin = Math.max(-ix, clip.x);
                    int ymin = Math.max(-iy, clip.y);
                    int xmax = Math.min(ix, clip.x + clip.width - 1);
                    int ymax = Math.min(iy, clip.y + clip.height - 1);
                    return new BlockPixer(xmin, xmax, ymin, ymax);
                }
            };
        }

        private static class BlockPixer
        implements Pixer {
            private final int xmin_;
            private final int xmax_;
            private final int ymax_;
            private int x_;
            private int y_;

            BlockPixer(int xmin, int xmax, int ymin, int ymax) {
                this.xmin_ = xmin;
                this.xmax_ = xmax;
                this.ymax_ = ymax;
                this.x_ = xmax;
                this.y_ = ymin - 1;
            }

            @Override
            public boolean next() {
                if (++this.x_ > this.xmax_) {
                    this.x_ = this.xmin_;
                    if (++this.y_ > this.ymax_) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public int getX() {
                return this.x_;
            }

            @Override
            public int getY() {
                return this.y_;
            }
        }
    }
}

