/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.layer.CartesianMultiPointCoordSet;

public class CartesianVectorCoordSet
implements CartesianMultiPointCoordSet {
    private final int ndim_;
    private final FloatingCoord[] componentCoords_;

    public CartesianVectorCoordSet(String[] axisNames) {
        this.ndim_ = axisNames.length;
        this.componentCoords_ = new FloatingCoord[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            String axName = axisNames[id];
            String axname = axName.toLowerCase();
            this.componentCoords_[id] = FloatingCoord.createCoord(new InputMeta(axname + "delta", axName + " Delta").setShortDescription(axName + " component of vector").setXmlDescription(new String[]{"<p>Vector component in the " + axName + " direction.", "</p>"}), true);
        }
    }

    @Override
    public Coord[] getCoords() {
        int nc = this.componentCoords_.length;
        Coord[] coords = new Coord[nc];
        for (int ic = 0; ic < nc; ++ic) {
            coords[ic] = this.componentCoords_[ic];
        }
        return coords;
    }

    @Override
    public int getPointCount() {
        return 1;
    }

    @Override
    public boolean readPoints(Tuple tuple, int icol, double[] xy0, double[][] xyExtras) {
        double[] xy1 = xyExtras[0];
        for (int idim = 0; idim < this.ndim_; ++idim) {
            double delta = this.componentCoords_[idim].readDoubleCoord(tuple, icol + idim);
            if (Double.isNaN(delta)) {
                return false;
            }
            xy1[idim] = xy0[idim] + delta;
        }
        return true;
    }
}

