/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import java.util.function.BiConsumer;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

public class FloatingCoordAuxReader
implements AuxReader {
    private final FloatingCoord coord_;
    private final int icol_;
    private final DataGeom geom_;
    private final boolean visibleOnly_;
    private final Scaling scaling_;

    public FloatingCoordAuxReader(FloatingCoord coord, int icol, DataGeom geom, boolean visibleOnly, Scaling scaling) {
        this.coord_ = coord;
        this.icol_ = icol;
        this.geom_ = geom;
        this.visibleOnly_ = visibleOnly;
        this.scaling_ = scaling;
    }

    @Override
    public int getCoordIndex() {
        return this.icol_;
    }

    @Override
    public ValueInfo getAxisInfo(DataSpec dataSpec) {
        ValueInfo[] infos = dataSpec.getUserCoordInfos(this.icol_);
        return infos.length == 1 ? infos[0] : null;
    }

    @Override
    public Scaling getScaling() {
        return this.scaling_;
    }

    @Override
    public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
        BiConsumer<TupleSequence, Ranger> rangeFiller = (tseq, r) -> {
            if (this.geom_ == null) {
                while (tseq.next()) {
                    r.submitDatum(this.coord_.readDoubleCoord((Tuple)tseq, this.icol_));
                }
            } else {
                double[] dpos = new double[this.geom_.getDataDimCount()];
                Point2D.Double gpos = new Point2D.Double();
                while (tseq.next()) {
                    if (!this.geom_.readDataPos((Tuple)tseq, 0, dpos) || !surface.dataToGraphics(dpos, this.visibleOnly_, gpos) || !this.visibleOnly_ && !PlotUtil.isPointFinite(gpos)) continue;
                    r.submitDatum(this.coord_.readDoubleCoord((Tuple)tseq, this.icol_));
                }
            }
        };
        dataStore.getTupleRunner().rangeData(rangeFiller, ranger, dataSpec, dataStore);
    }
}

