/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.ArrayShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class MarkArrayForm
implements ShapeForm {
    private final FloatingArrayCoord xsCoord_ = FloatingArrayCoord.X;
    private final FloatingArrayCoord ysCoord_ = FloatingArrayCoord.Y;
    private final int icXs_;
    private final int icYs_;
    public static final ConfigKey<Integer> SIZE_KEY = StyleKeys.createMarkSizeKey(new ConfigMeta("size", "Size").setStringUsage("<pixels>").setShortDescription("Marker size in pixels").setXmlDescription(new String[]{"<p>Size of the scatter plot markers.", "The unit is pixels, in most cases the marker", "is approximately twice the size", "of the supplied value.", "</p>"}), 1);
    private static final MarkArrayForm instance_ = new MarkArrayForm();

    private MarkArrayForm() {
        this.icXs_ = 0;
        this.icYs_ = 1;
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public String getFormName() {
        return "Marks";
    }

    @Override
    public String getFormDescription() {
        return String.join((CharSequence)"\n", "<p>Plots <em>N</em> markers for each input row,", "with the X and Y coordinate values each supplied", "by an <em>N</em>-element array value.", "</p>", "");
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_MARK;
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[0];
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{StyleKeys.MARKER_SHAPE, SIZE_KEY};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        MarkerShape shape = config.get(StyleKeys.MARKER_SHAPE);
        int size = config.get(SIZE_KEY);
        return new MarksOutliner(shape, size);
    }

    private Function<Tuple, XYArrayData> createXYArrayReader(DataSpec dataSpec) {
        return ArrayShapePlotter.createXYArrayReader(this.xsCoord_, this.ysCoord_, this.icXs_, this.icYs_, dataSpec);
    }

    public static MarkArrayForm getInstance() {
        return instance_;
    }

    private class MarksOutliner
    extends PixOutliner {
        private final MarkerStyle style_;
        private final Glyph glyph_;
        private final Icon icon_;

        public MarksOutliner(MarkerShape shape, int size) {
            this.style_ = MarkForm.createMarkStyle(shape, size);
            this.glyph_ = MarkForm.createMarkGlyph(shape, size, true);
            this.icon_ = MarkForm.createLegendIcon(shape, size);
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return MarkArrayForm.this.createXYArrayReader(dataSpec) != null;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final Function xyReader = MarkArrayForm.this.createXYArrayReader(dataSpec);
            return new ShapePainter(){
                final double[] dpos = new double[2];
                final Point2D.Double gpos = new Point2D.Double();

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    XYArrayData xyData = (XYArrayData)xyReader.apply(tuple);
                    if (xyData != null) {
                        int np = xyData.getLength();
                        for (int ip = 0; ip < np; ++ip) {
                            this.dpos[0] = xyData.getX(ip);
                            this.dpos[1] = xyData.getY(ip);
                            if (!surface.dataToGraphics(this.dpos, true, this.gpos)) continue;
                            paperType.placeGlyph(paper, this.gpos.x, this.gpos.y, MarksOutliner.this.glyph_, color);
                        }
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(CubeSurface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, PaperType3D paperType) {
            throw new UnsupportedOperationException("No 3d");
        }

        public int hashCode() {
            int code = 69834;
            code = 23 * code + this.style_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof MarksOutliner) {
                MarksOutliner other = (MarksOutliner)o;
                return this.style_.equals(other.style_);
            }
            return false;
        }
    }
}

