/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot.Shader;

public class PixelImage {
    private final Dimension size_;
    private final int[] pixels_;
    private final IndexColorModel colorModel_;
    private static final int NBIT = 8;
    private static final int IMAGE_TYPE = 13;
    private static final int MAP_SIZE = 128;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    public PixelImage(Dimension size, int[] pixels, IndexColorModel colorModel) {
        if (size.width * size.height != pixels.length) {
            throw new IllegalArgumentException("pixel array wrong length");
        }
        this.size_ = new Dimension(size);
        this.pixels_ = pixels;
        this.colorModel_ = colorModel;
    }

    public Dimension getSize() {
        return new Dimension(this.size_);
    }

    public int[] getPixels() {
        return this.pixels_;
    }

    public IndexColorModel getColorModel() {
        return this.colorModel_;
    }

    public void paintPixels(Graphics g, Point origin) {
        this.paintScaledPixels(g, origin, 1);
    }

    public void paintScaledPixels(Graphics g, Point origin, int scale) {
        int width = this.size_.width;
        int height = this.size_.height;
        BufferedImage image = new BufferedImage(width, height, 13, this.colorModel_);
        WritableRaster raster = image.getRaster();
        assert (raster.getNumBands() == 1);
        raster.setSamples(0, 0, width, height, 0, this.pixels_);
        assert (raster.getWidth() == width);
        assert (raster.getHeight() == height);
        if (scale == 1) {
            g.drawImage(image, origin.x, origin.y, null);
        } else {
            g.drawImage(image, origin.x, origin.y, width * scale, height * scale, null);
        }
    }

    public static IndexColorModel createColorModel(Shader shader, boolean zeroTransparent) {
        IndexColorModel model;
        if (!shader.isAbsolute()) {
            logger_.warning("Using non-absolute shader for indexed color map is a bad idea");
        }
        byte[] red = new byte[128];
        byte[] green = new byte[128];
        byte[] blue = new byte[128];
        byte[] alpha = new byte[128];
        float[] rgba = new float[4];
        int iStart = zeroTransparent ? 1 : 0;
        float scale = 0.007874016f;
        int iTransparent = zeroTransparent ? 0 : -1;
        boolean hasAlpha = false;
        for (int i = iStart; i < 128; ++i) {
            assert (i != iTransparent);
            rgba[3] = 1.0f;
            double level = (float)(i - iStart) * scale;
            shader.adjustRgba(rgba, (float)level);
            red[i] = (byte)(rgba[0] * 255.0f);
            green[i] = (byte)(rgba[1] * 255.0f);
            blue[i] = (byte)(rgba[2] * 255.0f);
            alpha[i] = (byte)(rgba[3] * 255.0f);
            hasAlpha = hasAlpha || alpha[i] != -1;
        }
        if (iTransparent >= 0) {
            red[iTransparent] = -1;
            green[iTransparent] = -1;
            blue[iTransparent] = -1;
            alpha[iTransparent] = 0;
        }
        if (hasAlpha) {
            model = new IndexColorModel(8, 128, red, green, blue, alpha);
            assert (model.getTransparency() == 3);
        } else if (iTransparent >= 0) {
            model = new IndexColorModel(8, 128, red, green, blue, iTransparent);
            assert (model.getTransparency() == 2);
            assert (model.getTransparentPixel() == 0);
        } else {
            model = new IndexColorModel(8, 128, red, green, blue);
            assert (model.getTransparency() == 1);
        }
        assert (model.getMapSize() == 128);
        assert (model.getPixelSize() == 8);
        return model;
    }

    public static IndexColorModel createMaskColorModel(Color color) {
        IndexColorModel model = new IndexColorModel(1, 2, new byte[]{0, (byte)color.getRed()}, new byte[]{0, (byte)color.getGreen()}, new byte[]{0, (byte)color.getBlue()}, 0);
        assert (model.getTransparency() == 2);
        assert (model.getTransparentPixel() == 0);
        return model;
    }
}

