/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.layer.AngleUnit;
import uk.ac.starlink.ttools.plot2.layer.MultiPointForm;
import uk.ac.starlink.ttools.plot2.layer.MultiPointReader;
import uk.ac.starlink.ttools.plot2.layer.SkyMultiPointCoordSet;
import uk.ac.starlink.util.SplitCollector;

public class SkyMultiPointForm
extends MultiPointForm {
    private SkyMultiPointCoordSet extraCoordSet_;
    public static final ConfigKey<Double> SCALE_KEY = SkyMultiPointForm.createScaleKey();
    public static final ConfigKey<AngleUnit> UNIT_KEY = SkyMultiPointForm.createUnitKey("marker");
    private static final String UNIT_SHORTNAME = "unit";
    private static final double AUTO_SCALE_DEGREES = 0.1;

    public SkyMultiPointForm(String name, Icon icon, String description, SkyMultiPointCoordSet extraCoordSet, MultiPointConfigKey rendererKey) {
        super(name, icon, description, extraCoordSet, rendererKey, SCALE_KEY, new ConfigKey[]{UNIT_KEY});
        this.extraCoordSet_ = extraCoordSet;
    }

    @Override
    protected MultiPointReader createReader(ConfigMap config) {
        return new SkyMultiPointReader(this.extraCoordSet_, config.get(UNIT_KEY));
    }

    public static String getCoordUnitText() {
        return new StringBuffer().append("The units of this angular extent are determined by the ").append("<code>").append(UNIT_KEY.getMeta().getShortName()).append("</code>").append(" option.").toString();
    }

    public static String getScalingDescription(FloatingCoord[] scaledCoords, String shapename) {
        StringBuffer cbuf = new StringBuffer();
        int nc = scaledCoords.length;
        for (int ic = 0; ic < nc; ++ic) {
            if (ic == nc - 1) {
                cbuf.append(" and ");
            } else if (ic > 0) {
                cbuf.append(", ");
            }
            cbuf.append("<code>").append(scaledCoords[ic].getInput().getMeta().getShortName()).append("</code>");
        }
        String coordsTxt = cbuf.toString();
        return PlotUtil.concatLines(new String[]{"<p>The dimensions of the plotted " + shapename + "s", "are given by the", coordsTxt, "coordinates.", "The units of these values are specified using the", "<code>" + UNIT_KEY.getMeta().getShortName() + "</code> option.", "If only the relative rather than the absolute sizes", "are required on the plot,", "or if the units are not known,", "the special value", "<code>" + UNIT_KEY.getMeta().getShortName() + "=" + UNIT_KEY.valueToString(null) + "</code>", "may be used;", "this applies a non-physical scaling factor", "to make the " + shapename + "s appear at some reasonable size", "in the plot.", "When <code>" + UNIT_KEY.getMeta().getShortName() + "=" + UNIT_KEY.valueToString(null) + "</code>", UNIT_KEY.getDefaultValue() == null ? " (the default)" : "", shapename + "s will keep approximately the same screen size", "during zoom operations;", "when one of the angular units is chosen, they will keep", "the same size in data coordinates.", "</p>", "<p>Additionally, the", "<code>" + SCALE_KEY + "</code> option", "may be used to scale all the plotted " + shapename + "s", "by a given factor to make them all larger or smaller.", "</p>"});
    }

    private static ConfigKey<AngleUnit> createUnitKey(String shapename) {
        String SCALED_OPT = "scaled";
        ConfigMeta meta = new ConfigMeta(UNIT_SHORTNAME, "Unit");
        meta.setXmlDescription(new String[]{"<p>Defines the units in which the angular extents are specified.", "Options are degrees, arcseconds etc.", "If the special value <code>scaled</code> is given", "then a non-physical scaling is applied to the", "input values to make the the largest " + shapename + "s", "appear at a reasonable size (a few tens of pixels)", "in the plot.", "</p>", "<p>Note that the actual plotted size of the " + shapename + "s", "can also be scaled using the", "<code>" + SCALE_KEY.getMeta().getShortName() + "</code> option;", "these two work together to determine the actual plotted sizes.", "</p>"});
        ArrayList<AngleUnit> optList = new ArrayList<AngleUnit>();
        optList.add(null);
        optList.addAll(Arrays.asList(AngleUnit.values()));
        AngleUnit[] opts = optList.toArray(new AngleUnit[0]);
        OptionConfigKey<AngleUnit> key = new OptionConfigKey<AngleUnit>(meta, AngleUnit.class, opts, AngleUnit.DEGREE){

            @Override
            public String getXmlDescription(AngleUnit unit) {
                return unit == null ? PlotUtil.concatLines(new String[]{"a non-physical scaling is applied", "based on the size of values present"}) : unit.getFullName();
            }

            @Override
            public String valueToString(AngleUnit unit) {
                return unit == null ? "scaled" : super.valueToString(unit);
            }

            @Override
            public AngleUnit stringToValue(String str) throws ConfigException {
                AngleUnit unit = AngleUnit.getNamedUnit(str);
                if (unit != null) {
                    return unit;
                }
                if ("scaled".equalsIgnoreCase(str) || str == null) {
                    return null;
                }
                throw new ConfigException(this, "No known unit: " + str);
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static ConfigKey<Double> createScaleKey() {
        ConfigMeta meta = new ConfigMeta("scale", "Scale");
        meta.setStringUsage("<number>");
        meta.setShortDescription("Size multiplier");
        meta.setXmlDescription(new String[]{"<p>Scales the size of variable-sized markers", "like vectors and ellipses.", "The default value is 1, smaller or larger values", "multiply the visible sizes accordingly.", "</p>", "<p>The main purpose of this option is to tweak", "the visible sizes of the plotted markers for better visibility.", "The <code>unit</code> option", "should be used to account for the units in which the", "angular extent coordinates are supplied.", "If the markers are supposed to be plotted with their", "absolute angular extents visible, this option should be set", "to its default value of 1.", "</p>"});
        return new DoubleConfigKey(meta, 1.0){

            @Override
            public Specifier<Double> createSpecifier() {
                return new SliderSpecifier(1.0E-4, 10000.0, true, 1.0, false, SliderSpecifier.TextOption.ENTER_ECHO);
            }
        };
    }

    private static class MaxSizeCollector
    implements SplitCollector<TupleSequence, double[]> {
        private final SkyMultiPointCoordSet extraCoordSet_;
        private final Surface surface_;
        private final DataGeom geom_;

        MaxSizeCollector(SkyMultiPointCoordSet extraCoordSet, Surface surface, DataGeom geom) {
            this.extraCoordSet_ = extraCoordSet;
            this.geom_ = geom;
            this.surface_ = surface;
        }

        public double[] createAccumulator() {
            return new double[1];
        }

        public double[] combine(double[] d1, double[] d2) {
            return new double[]{d1[0] + d2[0]};
        }

        public void accumulate(TupleSequence tseq, double[] dval) {
            double max = 0.0;
            int icExtra = MultiPointForm.getExtrasCoordIndex(this.geom_);
            double[] dpos0 = new double[this.geom_.getDataDimCount()];
            Point2D.Double gpos0 = new Point2D.Double();
            while (tseq.next()) {
                double tsize;
                if (!this.geom_.readDataPos(tseq, 0, dpos0) || !this.surface_.dataToGraphics(dpos0, true, gpos0) || !((tsize = this.extraCoordSet_.readSize(tseq, icExtra, dpos0)) > max)) continue;
                max = tsize;
            }
            dval[0] = Math.max(dval[0], max);
        }
    }

    private static class SkyMultiPointReader
    implements MultiPointReader {
        private final SkyMultiPointCoordSet extraCoordSet_;
        private final AngleUnit unit_;

        SkyMultiPointReader(SkyMultiPointCoordSet extraCoordSet, AngleUnit unit) {
            this.extraCoordSet_ = extraCoordSet;
            this.unit_ = unit;
        }

        @Override
        public SkyMultiPointCoordSet getExtraCoordSet() {
            return this.extraCoordSet_;
        }

        @Override
        public boolean isAutoscale() {
            return this.unit_ == null;
        }

        @Override
        public double getBaseScale(Surface surface, Span sizeSpan) {
            if (sizeSpan == null) {
                return 1.0;
            }
            double pixelSizeRadian = Math.sqrt(((SkySurface)surface).pixelAreaSteradians());
            return pixelSizeRadian * 32.0 / Math.toRadians(0.1);
        }

        @Override
        public MultiPointReader.ExtrasReader createExtrasReader(final DataGeom geom, Span sizeSpan) {
            double unitInDegrees;
            if (this.unit_ == null) {
                double maxSize = sizeSpan == null ? 0.0 : sizeSpan.getHigh();
                unitInDegrees = maxSize > 0.0 ? 0.1 / maxSize : 1.0E-6;
            } else {
                unitInDegrees = this.unit_.getValueInDegrees();
            }
            final int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            return new MultiPointReader.ExtrasReader(){

                @Override
                public boolean readPoints(Tuple tuple, double[] dpos0, double[][] dposExtras) {
                    return extraCoordSet_.readPoints(tuple, icExtra, dpos0, unitInDegrees, (SkyDataGeom)geom, dposExtras);
                }
            };
        }

        @Override
        public AuxReader createSizeReader(final DataGeom geom) {
            int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            return new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return -1;
                }

                @Override
                public ValueInfo getAxisInfo(DataSpec dataSpec) {
                    return null;
                }

                @Override
                public Scaling getScaling() {
                    return null;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
                    int ndim = geom.getDataDimCount();
                    MaxSizeCollector maxCollector = new MaxSizeCollector(extraCoordSet_, surface, geom);
                    double maxSize = PlotUtil.tupleCollect(maxCollector, dataSpec, dataStore)[0];
                    ranger.submitDatum(maxSize);
                }
            };
        }

        public int hashCode() {
            int code = 6629511;
            code = 23 * code + this.extraCoordSet_.hashCode();
            code = 23 * PlotUtil.hashCode((Object)this.unit_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SkyMultiPointReader) {
                SkyMultiPointReader other = (SkyMultiPointReader)o;
                return this.extraCoordSet_.equals(other.extraCoordSet_) && PlotUtil.equals((Object)this.unit_, (Object)other.unit_);
            }
            return false;
        }
    }
}

