/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.HealpixDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyPlotType;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.layer.HealpixPlotter;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;

public class SkyPlot2Task
extends TypedPlot2Task<SkySurfaceFactory.Profile, SkyAspect> {
    private final SkyPlotContext skyContext_ = (SkyPlotContext)this.getPlotContext();
    private static final String viewsysName_ = SkySurfaceFactory.VIEWSYS_KEY.getMeta().getShortName();

    public SkyPlot2Task() {
        super(SkyPlotType.getInstance(), null, new SkyPlotContext());
        Parameter<?> viewsysParam = null;
        for (Parameter<?> param : super.getParameters()) {
            Parameter<?> vp;
            if (!viewsysName_.equals(param.getName())) continue;
            viewsysParam = vp = param;
        }
        viewsysParam.setNullPermitted(true);
        viewsysParam.setStringDefault(null);
        this.skyContext_.setViewsysParameter(viewsysParam);
    }

    @Override
    public ConfigMap createCustomConfigMap(Environment env) throws TaskException {
        ConfigMap config = super.createCustomConfigMap(env);
        config.put(SkySurfaceFactory.VIEWSYS_KEY, this.skyContext_.viewsysParam_.objectValue(env));
        return config;
    }

    private static class SkyPlotContext
    extends PlotContext<SkySurfaceFactory.Profile, SkyAspect> {
        private static final SkyPlotType SKY_TYPE = SkyPlotType.getInstance();
        private Parameter<SkySys> viewsysParam_;

        SkyPlotContext() {
            super(SKY_TYPE, new DataGeom[]{SkyDataGeom.GENERIC});
        }

        public void setViewsysParameter(Parameter<SkySys> viewsysParam) {
            this.viewsysParam_ = viewsysParam;
        }

        @Override
        public Parameter<?> getGeomParameter(String suffix) {
            return this.createDataSysParameter(suffix);
        }

        @Override
        public DataGeom getGeom(Environment env, String suffix) throws TaskException {
            SkySys viewsys = (SkySys)this.viewsysParam_.objectValue(env);
            ConfigParameter datasysParam = (ConfigParameter)((Object)new ParameterFinder<ConfigParameter<SkySys>>(){

                @Override
                public ConfigParameter<SkySys> createParameter(String sfix) {
                    return this.createDataSysParameter(sfix);
                }
            }.getParameter(env, suffix));
            datasysParam.setNullPermitted(viewsys == null);
            datasysParam.setDefaultOption(viewsys);
            SkySys datasys = (SkySys)datasysParam.objectValue(env);
            if (viewsys == null && datasys != null) {
                String msg = new StringBuffer().append(datasysParam.getName()).append(" must be null if ").append(this.viewsysParam_.getName()).append(" is null").toString();
                throw new TaskException(msg);
            }
            LayerType layer = (LayerType)AbstractPlot2Task.createLayerTypeParameter(suffix, this).objectValue(env);
            if (layer.getPlotter(env, suffix) instanceof HealpixPlotter) {
                boolean isNest = true;
                int level = (Integer)((ConfigParameter)((Object)new ParameterFinder<ConfigParameter<Integer>>(){

                    @Override
                    public ConfigParameter<Integer> createParameter(String sfix) {
                        return ConfigParameter.createLayerSuffixedParameter(HealpixPlotter.DATALEVEL_KEY, sfix, false);
                    }
                }.getParameter(env, suffix))).objectValue(env);
                return HealpixDataGeom.createGeom(level, isNest, datasys, viewsys);
            }
            return SkyDataGeom.createGeom(datasys, viewsys);
        }

        private ConfigParameter<SkySys> createDataSysParameter(String suffix) {
            ConfigParameter<SkySys> datasysParam = ConfigParameter.createLayerSuffixedParameter(SkySurfaceFactory.DATASYS_KEY, suffix, false);
            datasysParam.setDefaultOption(null);
            return datasysParam;
        }
    }
}

