/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.util.ArrayList;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plottask.StyleParameter;

public class ShaderParameter
extends StyleParameter<Shader> {
    private static final Shader[] SHADERS = new Shader[]{Shaders.LUT_RAINBOW, Shaders.LUT_PASTEL, Shaders.LUT_STANDARD, Shaders.LUT_HEAT, Shaders.LUT_COLOR, Shaders.FIX_HUE, Shaders.WHITE_BLACK, Shaders.RED_BLUE, Shaders.HSV_H, Shaders.HSV_S, Shaders.HSV_V, Shaders.FIX_INTENSITY, Shaders.FIX_RED, Shaders.FIX_GREEN, Shaders.FIX_BLUE, Shaders.FIX_Y, Shaders.FIX_U, Shaders.FIX_V, Shaders.TRANSPARENCY};
    private static final Shader[] ABS_SHADERS;
    private static final Shader[] MOD_SHADERS;

    public ShaderParameter(String name) {
        super(name, SHADERS);
        this.setPrompt("Shader defining how aux axes are coloured");
        this.setDescription(new String[]{"<p>Determines how data from auxiliary axes will be displayed.", "Generally this is some kind of colour ramp.", "These are the available <em>colour fixing</em> options:", ShaderParameter.formatShaderList(ABS_SHADERS), "and these are the available <em>colour modifying</em> options:", ShaderParameter.formatShaderList(MOD_SHADERS), "</p>"});
    }

    public Shader shaderValue(Environment env) throws TaskException {
        return (Shader)this.objectValue(env);
    }

    public String getName(Shader option) {
        return ShaderParameter.getShaderName(option);
    }

    public static String[] getDefaultValues(int count) {
        if (count == 1) {
            return new String[]{ShaderParameter.getShaderName(ABS_SHADERS[0])};
        }
        String[] dflts = new String[count];
        for (int i = 0; i < count; ++i) {
            dflts[i] = ShaderParameter.getShaderName(MOD_SHADERS[i % MOD_SHADERS.length]);
        }
        return dflts;
    }

    private static String formatShaderList(Shader[] shaders) {
        StringBuffer sbuf = new StringBuffer().append("<ul>").append('\n');
        for (int i = 0; i < shaders.length; ++i) {
            sbuf.append("<li>").append("<code>").append(ShaderParameter.getShaderName(shaders[i])).append("</code>").append("</li>").append('\n');
        }
        sbuf.append("</ul>").append('\n');
        return sbuf.toString();
    }

    private static String getShaderName(Shader shader) {
        return shader.getName().toLowerCase().replaceAll(" ", "_");
    }

    static {
        ArrayList<Shader> absList = new ArrayList<Shader>();
        ArrayList modList = new ArrayList();
        for (int i = 0; i < SHADERS.length; ++i) {
            Shader shader = SHADERS[i];
            (shader.isAbsolute() ? absList : modList).add(shader);
        }
        ABS_SHADERS = absList.toArray(new Shader[0]);
        MOD_SHADERS = modList.toArray(new Shader[0]);
    }
}

