/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ForkJoinPool;
import java.util.function.UnaryOperator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.plot2.SplitRunner;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.DiskCache;
import uk.ac.starlink.ttools.plot2.data.PersistentDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.task.TableFactoryParameter;
import uk.ac.starlink.ttools.task.TableLocator;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.SplitPolicy;
import uk.ac.starlink.util.URLDataSource;

public class StiltsContext {
    private final ServletContext context_;
    public static final String TASKBASE_PARAM = "stiltsTaskBase";
    public static final String TASKLIST_PARAM = "stiltsTasks";
    public static final String TABLEFACTORY_PARAM = "tableFactory";
    public static final String CACHEDIR_PARAM = "cacheDir";
    public static final String CACHELIMIT_PARAM = "cacheLimit";
    public static final String PLOTPARALLELISM_PARAM = "plotParallelism";
    public static final String ALLOWORIGINS_PARAM = "allowOrigins";

    public StiltsContext(ServletContext context) {
        this.context_ = context;
    }

    public StarTableFactory getTableFactory() throws ServletException {
        String tfactSpec = this.context_.getInitParameter(TABLEFACTORY_PARAM);
        if (tfactSpec == null || tfactSpec.trim().length() == 0) {
            final StarTableFactory tfact = new StarTableFactory();
            Stilts.addStandardSchemes(tfact);
            boolean allowAbsolute = true;
            return TableFactoryParameter.createTableFactory(new TableLocator(){

                @Override
                public StarTable getTable(String loc) throws IOException {
                    return StiltsContext.this.getServletTable(tfact, loc, true);
                }
            });
        }
        try {
            return TableFactoryParameter.createTableFactory(tfactSpec);
        }
        catch (UsageException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getTaskBase() {
        return this.context_.getInitParameter(TASKBASE_PARAM);
    }

    public DataStoreFactory getDataStoreFactory() throws ServletException {
        DiskCache cache = this.createCache(dir -> PersistentDataStoreFactory.toCacheDir(dir), 0.9);
        TupleRunner tupleRunner = this.createTupleRunner();
        return new PersistentDataStoreFactory(cache, tupleRunner);
    }

    public DiskCache getImageCache() throws ServletException {
        return this.createCache(dir -> DiskCache.toCacheDir(dir, "plot2-img"), 0.1);
    }

    public String getAllowOrigins() throws ServletException {
        return this.context_.getInitParameter(ALLOWORIGINS_PARAM);
    }

    private TupleRunner createTupleRunner() throws ServletException {
        int ncore;
        String ncoreTxt = this.context_.getInitParameter(PLOTPARALLELISM_PARAM);
        if (ncoreTxt == null || ncoreTxt.trim().length() == 0) {
            return null;
        }
        try {
            ncore = Integer.parseInt(ncoreTxt);
        }
        catch (RuntimeException e) {
            throw new ServletException("Unsuitable value \"" + ncoreTxt + "\" for " + PLOTPARALLELISM_PARAM);
        }
        if (ncore == ForkJoinPool.getCommonPoolParallelism()) {
            return null;
        }
        SplitPolicy policy = new SplitPolicy(() -> new ForkJoinPool(ncore), -1, -1);
        return new TupleRunner(SplitRunner.createStandardRunner(policy));
    }

    private DiskCache createCache(UnaryOperator<File> dirMapping, double proportion) throws ServletException {
        long cacheLimit;
        String cacheTxt = this.context_.getInitParameter(CACHEDIR_PARAM);
        String cachelimitTxt = this.context_.getInitParameter(CACHELIMIT_PARAM);
        File cacheDir = cacheTxt == null ? DiskCache.getSystemTmpDir() : new File(cacheTxt);
        File subDir = (File)dirMapping.apply(cacheDir);
        if (cachelimitTxt == null || cachelimitTxt.trim().length() == 0) {
            cacheLimit = 0L;
        } else {
            try {
                cacheLimit = Long.parseLong(cachelimitTxt);
            }
            catch (RuntimeException e) {
                throw new ServletException("Unsuitable value \"" + cachelimitTxt + "\" for " + CACHELIMIT_PARAM);
            }
        }
        long pCacheLimit = cacheLimit > 0L ? (long)(proportion * (double)cacheLimit) : cacheLimit;
        return new DiskCache(subDir, cacheLimit);
    }

    private StarTable getServletTable(StarTableFactory tfact, String loc, boolean allowAbsolute) throws IOException {
        URL resource;
        if (StarTableFactory.parseSchemeLocation((String)loc) != null) {
            return tfact.makeStarTable(loc);
        }
        String fsPath = allowAbsolute && loc.length() > 0 && loc.charAt(0) == '/' ? loc : this.context_.getRealPath("/" + loc);
        File file = new File(fsPath);
        if (file.exists()) {
            return tfact.makeStarTable((DataSource)new FileDataSource(file));
        }
        try {
            resource = this.context_.getResource("/" + loc);
        }
        catch (Throwable e) {
            resource = null;
        }
        if (resource != null) {
            return tfact.makeStarTable((DataSource)new URLDataSource(resource));
        }
        throw new FileNotFoundException("No such resource in servlet: " + loc);
    }
}

