/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.net.URL;
import java.util.Arrays;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.util.ContentType;

public class ContentTypeOptions {
    private final ContentType[] permittedTypes_;

    public ContentTypeOptions(ContentType[] permittedTypes) {
        this.permittedTypes_ = permittedTypes;
    }

    public void checkType(Reporter reporter, String declaredTypeTxt, URL url) {
        if (declaredTypeTxt == null || declaredTypeTxt.trim().length() == 0) {
            reporter.report(FixedCode.W_NOCT, "No Content-Type header for " + url);
        } else {
            ContentType declaredType = ContentType.parseContentType((String)declaredTypeTxt);
            if (declaredType == null) {
                reporter.report(FixedCode.E_BMIM, "Bad Content-Type syntax: " + declaredTypeTxt);
            } else if (!this.isPermitted(declaredType)) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("Incorrect Content-Type \"").append(declaredTypeTxt).append("\"").append(", should match ");
                if (this.permittedTypes_.length == 1) {
                    sbuf.append(this.permittedTypes_[0]);
                } else {
                    sbuf.append("one of ").append(Arrays.asList(this.permittedTypes_));
                }
                sbuf.append(" for ").append(url);
                reporter.report(FixedCode.E_GMIM, sbuf.toString());
            }
        }
    }

    private boolean isPermitted(ContentType declaredType) {
        for (ContentType typ : this.permittedTypes_) {
            if (!declaredType.matches(typ.getType(), typ.getSubtype())) continue;
            return true;
        }
        return false;
    }
}

