/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.IvoaSchemaResolver;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.ReporterErrorHandler;
import uk.ac.starlink.ttools.taplint.TextOutputReporter;
import uk.ac.starlink.util.URLUtils;

public class XsdValidation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result validateDoc(Reporter reporter, URL docUrl, String topElName, String topElNamespaceUri, boolean includeSummary) {
        Validator val;
        InputStream docStream;
        try {
            docStream = AuthManager.getInstance().openStream(docUrl);
        }
        catch (FileNotFoundException e) {
            return Result.NOT_FOUND;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_DCER, "Error reading document", e);
            return Result.FAILURE;
        }
        try {
            val = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema().newValidator();
        }
        catch (SAXException e) {
            reporter.report(FixedCode.F_XVAL, "Can't prepare validator", e);
            return Result.FAILURE;
        }
        boolean nsUrlDflt = false;
        IvoaSchemaResolver resolver = new IvoaSchemaResolver(nsUrlDflt);
        val.setResourceResolver(resolver);
        ReporterErrorHandler errHandler = new ReporterErrorHandler(reporter);
        val.setErrorHandler(errHandler);
        TopElementHandler topelHandler = new TopElementHandler();
        try {
            Object msg;
            val.validate(new SAXSource(new InputSource(new BufferedInputStream(docStream))), new SAXResult(topelHandler));
            for (String unresolved : resolver.getUnresolvedNamespaces()) {
                reporter.report(FixedCode.W_UNSC, "Schema from unknown namespace during validation: " + unresolved);
            }
            if (topElName != null && !topElName.equals(topelHandler.topName_)) {
                msg = new StringBuffer().append("Wrong top-level element: ").append("{").append(topelHandler.topUri_).append("}").append(topelHandler.topName_).append(" != ").append("{").append(topElNamespaceUri).append("}").append(topElName).toString();
                reporter.report(FixedCode.E_ELDF, (String)msg);
            }
            if (resolver.getResolvedNamespaces().size() == 0) {
                msg = new StringBuffer().append("No resources from known namespaces resolved").append("; resolver not used??").toString();
                reporter.report(FixedCode.W_ZRES, (String)msg);
            }
            msg = Result.SUCCESS;
            return msg;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_IOER, "Error reading document to parse");
            Result result = Result.FAILURE;
            return result;
        }
        catch (SAXException e) {
            if (errHandler.getFatalCount() == 0) {
                reporter.report(FixedCode.F_SXER, "Unexpected document parse error", e);
                Result result = Result.SUCCESS;
                return result;
            }
            Result result = Result.FAILURE;
            return result;
        }
        finally {
            if (includeSummary) {
                if (reporter instanceof OutputReporter) {
                    OutputReporter orep = (OutputReporter)reporter;
                    orep.summariseUnreportedMessages(orep.getSectionCode());
                }
                reporter.report(FixedCode.S_VALI, errHandler.getSummary());
            }
        }
    }

    public static void main(String[] args) throws IOException {
        URL url = URLUtils.newURL((String)args[0]);
        String topElName = args.length > 1 ? args[1] : null;
        TextOutputReporter reporter = new TextOutputReporter(System.out, ReportType.values(), 10, false, 1024);
        Result result = XsdValidation.validateDoc(reporter, url, topElName, "??", false);
        System.out.println((Object)result);
    }

    private static class TopElementHandler
    extends DefaultHandler {
        private boolean isTop_;
        String topUri_;
        String topName_;

        private TopElementHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (!this.isTop_) {
                this.isTop_ = true;
                this.topUri_ = uri;
                this.topName_ = localName;
            }
        }
    }

    public static enum Result {
        NOT_FOUND,
        FAILURE,
        SUCCESS;

    }
}

