/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.concurrent.ForkJoinPool;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.util.SplitPolicy;
import uk.ac.starlink.util.SplitProcessor;

public class RowRunnerParameter
extends ChoiceParameter<RowRunner> {
    private static final String CLASSIC = "classic";
    private static final String SEQUENTIAL = "sequential";
    private static final String PARALLEL = "parallel";
    private static final String PARALLEL_ALL = "parallel-all";
    private static final String PARTEST = "partest";
    public static final RowRunner DFLT_MATCH_RUNNER = RowRunnerParameter.createParallelRowRunner(RowMatcher.DFLT_PARALLELISM);

    private RowRunnerParameter(String name) {
        super(name, RowRunner.class);
    }

    public RowRunner stringToObject(Environment env, String sval) throws TaskException {
        if (sval.matches("parallel[0-9]+")) {
            int nThread;
            String nTxt = sval.substring(PARALLEL.length());
            try {
                nThread = Integer.parseInt(nTxt);
            }
            catch (NumberFormatException e) {
                String msg = "Bad thread count specifier \"" + nTxt + "\"";
                throw new ParameterValueException((Parameter)this, msg);
            }
            return RowRunnerParameter.createParallelRowRunner(nThread);
        }
        return (RowRunner)super.stringToObject(env, sval);
    }

    public static RowRunnerParameter createScanRunnerParameter(String name) {
        RowRunnerParameter param = new RowRunnerParameter(name);
        param.setNullPermitted(false);
        param.addOption(RowRunner.SEQUENTIAL, SEQUENTIAL);
        param.addOption(RowRunner.DEFAULT, PARALLEL);
        param.addOption(RowRunner.PARTEST, PARTEST);
        param.setStringDefault(PARALLEL);
        param.setPrompt("Threading implementation");
        param.setUsage(String.join((CharSequence)"|", SEQUENTIAL, PARALLEL, "parallel<n>", PARTEST));
        param.setDescription(new String[]{"<p>Selects the threading implementation,", "i.e. to what extent processing is done in parallel.", "The options are currently:", "<ul>", "<li><code>sequential</code>:", "runs using only a single thread", "</li>", "<li><code>parallel</code>:", "runs using multiple threads for large tables,", "with parallelism given by the number of available processors", "</li>", "<li><code>parallel&lt;n&gt;</code>:", "runs using multiple threads for large tables,", "with parallelism given by the supplied value", "<code>&lt;n&gt;</code>", "</li>", "<li><code>partest</code>:", "runs using multiple threads even when tables are small", "(only intended for testing purposes)", "</li>", "</ul>", "</p>", "<p>Using parallel processing can speed up execution considerably;", "however, depending on the I/O operations required,", "it can also slow it down by disrupting patterns of disk access.", "If the content of a file is on a solid state disk,", "or is already in cache for instance because a similar command", "has been run recently,", "then <code>parallel</code> will probably be faster.", "However, if the data is being read directly from a spinning disk,", "for instance because the file is too large to fit in RAM, then", "<code>sequential</code> or", "<code>parallel&lt;n&gt;</code> with a small", "<code>&lt;n&gt;</code> may be faster.", "</p>", "<p>The value of this parameter should make only very tiny", "differences to the output table.", "If you notice significant discrepancies", "<strong>please report them</strong>.", "</p>"});
        return param;
    }

    public static RowRunnerParameter createMatchRunnerParameter(String name) {
        int dfltParallelismLimit = 6;
        RowRunner dfltParallelRunner = DFLT_MATCH_RUNNER;
        RowRunnerParameter param = new RowRunnerParameter(name);
        param.setNullPermitted(true);
        param.addOption(dfltParallelRunner, PARALLEL);
        param.addOption(RowRunner.DEFAULT, PARALLEL_ALL);
        param.addOption(RowRunner.SEQUENTIAL, SEQUENTIAL);
        param.addOption(null, CLASSIC);
        param.addOption(RowRunner.PARTEST, PARTEST);
        param.setStringDefault(PARALLEL);
        param.setPrompt("Threading implementation");
        param.setUsage(String.join((CharSequence)"|", PARALLEL, "parallel<n>", PARALLEL_ALL, SEQUENTIAL, CLASSIC, PARTEST));
        param.setDescription(new String[]{"<p>Selects the threading implementation.", "The options are currently:", "<ul>", "<li><code>parallel</code>:", "uses multithreaded implementation for large tables,", "with default parallelism,", "which is the smaller of 6", "and the number of available processors", "</li>", "<li><code>parallel&lt;n&gt;</code>:", "uses multithreaded implementation for large tables,", "with parallelism given by the supplied value", "<code>&lt;n&gt;</code>", "</li>", "<li><code>parallel-all</code>:", "uses multithreaded implementation for large tables,", "with a parallelism given by the number of", "available processors", "</li>", "<li><code>sequential</code>:", "uses multithreaded implementation", "but with only a single thread", "</li>", "<li><code>classic</code>:", "uses legacy sequential implementation", "</li>", "<li><code>partest</code>:", "uses multithreaded implementation even when tables are small", "</li>", "</ul>", "The <code>parallel*</code> options", "should normally run faster than", "<code>sequential</code> or <code>classic</code>", "(which are provided mainly for testing purposes),", "at least for large matches", "and where multiple processing cores are available.", "</p>", "<p>The default value \"<code>parallel</code>\"", "is currently limited to a parallelism of 6", "since larger values yield diminishing returns given that", "some parts of the matching algorithms run sequentially", "(Amdahl's Law), and using too many threads", "can sometimes end up doing more work", "or impacting on other operations on the same machine.", "But you can experiment with other concurrencies,", "e.g. \"<code>parallel16</code>\" to run on 16 cores", "(if available) or \"<code>parallel-all</code>\"", "to run on all available cores.", "</p>", "<p>The value of this parameter should make no difference", "to the matching results.", "If you notice any discrepancies", "<strong>please report them</strong>.", "</p>"});
        return param;
    }

    private static RowRunner createParallelRowRunner(final int nThread) {
        SplitPolicy policy = new SplitPolicy(() -> new ForkJoinPool(nThread), 100000, 8);
        boolean isPool = false;
        SplitProcessor splitProcessor = SplitProcessor.createStandardProcessor((SplitPolicy)policy, (boolean)isPool);
        return new RowRunner(splitProcessor){

            public String toString() {
                return RowRunnerParameter.PARALLEL + Integer.toString(nThread);
            }
        };
    }
}

