/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.task.Aggregator;
import uk.ac.starlink.ttools.task.Aggregators;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.RowRunnerParameter;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class TableGroup
extends SingleMapperTask {
    private final StringMultiParameter keysParam_ = new StringMultiParameter("keys", ' ');
    private final StringMultiParameter aggcolsParam_;
    private final RowRunnerParameter runnerParam_;
    private final BooleanParameter sortParam_;
    private final BooleanParameter cacheParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    public static final char AGGCOL_DELIM = ';';

    public TableGroup() {
        super("Calculates aggregate functions on groups of rows", new ChoiceMode(), true, true);
        this.keysParam_.setUsage("<expr> ...");
        this.keysParam_.setPrompt("Expressions for grouping key values");
        this.keysParam_.setDescription(new String[]{"<p>List of one or more space-separated words", "defining the groups within which aggregation should be done.", "Each word can be a column name or an expression using the", "<ref id='jel'>expression language</ref>.", "Each expression will appear as one of the columns", "in the output table.", "This list corresponds to the contents of an ADQL/SQL", "<code>GROUP BY</code> clause.", "</p>"});
        this.aggcolsParam_ = new StringMultiParameter("aggcols", ' ');
        this.aggcolsParam_.setPrompt("Aggregate column definitions");
        this.aggcolsParam_.setUsage("<expr>;<aggregator>[;<name>] ...");
        this.aggcolsParam_.setDescription(new String[]{"<p>Defines the aggregate quantities to be calculated", "for each group of input rows.", "Each quantity is defined by one entry in this list;", "entries are space-separated, or can be given by multiple", "instances of this parameter on the command line.", "</p>", "<p>Each entry is composed of two or three tokens,", "separated by semicolon (\"<code>;</code>\") characters:", "<ul>", "<li><code>&lt;expr&gt;</code>: <em>(required)</em>", "    column name, or expression using the", "    <ref id='jel'>expression language</ref>,", "    for the quantity to be aggregated", "    </li>", "<li><code>&lt;aggregator&gt;</code>: <em>(required)</em>", "    aggregation method", "    </li>", "<li><code>&lt;name&gt;</code>: <em>(optional)</em>", "    name of output column; if omitted,", "    a name based on the <code>&lt;expr&gt;</code> value", "    will be used", "    </li>", "</ul>", "</p>", "<p>The available <code>&lt;aggregator&gt;</code> values", "are as follows:", Aggregators.getOptionsDescription(), "</p>"});
        this.aggcolsParam_.setNullPermitted(true);
        this.runnerParam_ = RowRunnerParameter.createScanRunnerParameter("runner");
        this.sortParam_ = new BooleanParameter("sort");
        this.sortParam_.setBooleanDefault(true);
        this.sortParam_.setPrompt("Sort results by keys?");
        this.sortParam_.setDescription(new String[]{"<p>Determines whether an attempt is made to sort the output table", "by the values of the <code>" + this.keysParam_.getName() + "</code>", "expressions.", "This may not be possible if no sort order is defined on the keys.", "</p>", "<p>In most cases such sorting will be a small overhead", "on the rest of the work done by this task,", "so the default is <code>true</code>", "but if ordering by key is not useful", "you may save some resources by setting it <code>false</code>.", "If no sorting is done, the output row order is undefined.", "</p>"});
        this.cacheParam_ = new BooleanParameter("cache");
        this.cacheParam_.setBooleanDefault(true);
        this.cacheParam_.setPrompt("Cache results?");
        this.cacheParam_.setDescription(new String[]{"<p>Determines whether the results of the aggregation operation", "will be cached in random-access storage before output.", "This is set true by default, since accessing rows of", "the calculated table may be somewhat expensive,", "and most uses of the results will need all of the cells.", "But if you anticipate making only a small number of", "accesses to the output table cells,", "it could be more efficient to set this false.", "</p>"});
        this.getParameterList().addAll(Arrays.asList(new Parameter[]{this.keysParam_, this.aggcolsParam_, this.runnerParam_, this.sortParam_, this.cacheParam_}));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        final String[] keyExprs = this.keysParam_.stringsValue(env);
        String[] aggcols = this.aggcolsParam_.stringsValue(env);
        final RowRunner runner = (RowRunner)this.runnerParam_.objectValue(env);
        final boolean isCache = this.cacheParam_.booleanValue(env);
        final boolean isSort = this.sortParam_.booleanValue(env);
        int nagg = aggcols.length;
        final AggSpec[] aggSpecs = new AggSpec[nagg];
        try {
            for (int iagg = 0; iagg < nagg; ++iagg) {
                aggSpecs[iagg] = TableGroup.parseAggSpec(aggcols[iagg], ';');
            }
        }
        catch (UsageException e) {
            throw new ParameterValueException((Parameter)this.aggcolsParam_, e.getMessage());
        }
        final TableProducer inProd = this.createInputProducer(env);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return TableGroup.aggregateRows(inProd.getTable(), keyExprs, aggSpecs, runner, isSort, isCache);
            }
        };
    }

    public static AggSpec parseAggSpec(String aggSpecTxt, char delimChr) throws UsageException {
        String delimRegex = "\\Q" + delimChr + "\\E";
        String[] fields = aggSpecTxt.split(delimRegex, 3);
        int nf = fields.length;
        assert (nf > 0 && nf <= 3);
        if (nf < 2) {
            String msg = new StringBuffer().append("Column specifier \"").append(aggSpecTxt).append("\" not of form ").append("<expr>").append(delimChr).append("<aggregator>").append("[").append(delimChr).append("<name>]").toString();
            throw new UsageException(msg);
        }
        String expr = fields[0];
        String aggTxt = fields[1];
        Aggregator aggregator = Aggregators.getAggregator(aggTxt);
        if (aggregator == null) {
            throw new UsageException("No such aggregation type \"" + aggTxt + "\"");
        }
        String outName = nf > 2 ? fields[2] : null;
        return new AggSpec(expr, aggregator, outName);
    }

    public static StarTable aggregateRows(StarTable inTable, String[] keyExprs, AggSpec[] aggSpecs, RowRunner runner, boolean isSort, boolean isCache) throws IOException, TaskException {
        Collection keyCollection;
        Comparator<List<Object>> keyComparator;
        StarTable jelTable;
        final int nkey = keyExprs.length;
        final int nagg = aggSpecs.length;
        boolean ik0 = false;
        final int ia0 = nkey;
        String[] exprs = new String[nkey + nagg];
        for (int ik = 0; ik < nkey; ++ik) {
            exprs[0 + ik] = keyExprs[ik];
        }
        for (int ia = 0; ia < nagg; ++ia) {
            exprs[ia0 + ia] = aggSpecs[ia].getExpression();
        }
        try {
            jelTable = JELTable.createJELTable(inTable, exprs);
        }
        catch (CompilationException e) {
            throw new ExecutionException("Bad expression", (Throwable)e);
        }
        Aggregator.Aggregation[] aggregations = new Aggregator.Aggregation[nagg];
        for (int ia = 0; ia < nagg; ++ia) {
            ColumnInfo inInfo;
            Aggregator aggregator = aggSpecs[ia].getAggregator();
            Aggregator.Aggregation aggregation = aggregator.createAggregation((ValueInfo)(inInfo = jelTable.getColumnInfo(ia0 + ia)));
            if (aggregation == null) {
                throw new ExecutionException("Aggregator " + aggregator.getName() + " cannot be applied to value " + inInfo);
            }
            aggregations[ia] = aggregation;
        }
        final ColumnInfo[] outInfos = new ColumnInfo[nkey + nagg];
        for (int ik = 0; ik < nkey; ++ik) {
            outInfos[0 + ik] = jelTable.getColumnInfo(0 + ik);
        }
        for (int ia = 0; ia < nagg; ++ia) {
            ColumnInfo cinfo = new ColumnInfo(aggregations[ia].getResultInfo());
            String outName = aggSpecs[ia].getOutputName();
            if (outName != null && outName.trim().length() > 0) {
                cinfo.setName(outName);
            }
            outInfos[ia0 + ia] = cinfo;
        }
        final Map accMap = (Map)runner.collect((RowCollector)new GroupCollector(nkey, aggregations), jelTable);
        if (isSort) {
            Class[] keyClazzes = new Class[nkey];
            for (int ik = 0; ik < nkey; ++ik) {
                keyClazzes[ik] = outInfos[0 + ik].getContentClass();
            }
            boolean nullsFirst = true;
            keyComparator = TableGroup.getListComparator(keyClazzes, nullsFirst);
            if (keyComparator == null) {
                logger_.warning("Can't sort keys (not Comparable)");
            }
        } else {
            keyComparator = null;
        }
        Set keySet = accMap.keySet();
        if (keyComparator == null) {
            keyCollection = keySet;
        } else {
            ArrayList keyList = new ArrayList(keySet);
            try {
                keyList.sort(keyComparator);
            }
            catch (RuntimeException e) {
                logger_.log(Level.WARNING, "Sort failed", e);
            }
            keyCollection = keyList;
        }
        AbstractStarTable outTable = new AbstractStarTable(){

            public int getColumnCount() {
                return outInfos.length;
            }

            public long getRowCount() {
                return accMap.size();
            }

            public ColumnInfo getColumnInfo(int icol) {
                return outInfos[icol];
            }

            public RowSequence getRowSequence() {
                final Iterator keyIt = keyCollection.iterator();
                return new RowSequence(){
                    List<Object> keyList_;
                    Aggregator.Accumulator[] aggaccs_;

                    public boolean next() {
                        if (keyIt.hasNext()) {
                            this.keyList_ = (List)keyIt.next();
                            this.aggaccs_ = (Aggregator.Accumulator[])accMap.get(this.keyList_);
                            return true;
                        }
                        this.keyList_ = null;
                        this.aggaccs_ = null;
                        return false;
                    }

                    public Object[] getRow() {
                        if (this.keyList_ != null) {
                            Object[] row = new Object[nkey + nagg];
                            for (int ik = 0; ik < nkey; ++ik) {
                                row[0 + ik] = this.keyList_.get(ik);
                            }
                            for (int ia = 0; ia < nagg; ++ia) {
                                row[ia0 + ia] = this.aggaccs_[ia].getResult();
                            }
                            return row;
                        }
                        throw new IllegalStateException("No current row");
                    }

                    public Object getCell(int ic) {
                        if (this.keyList_ != null) {
                            return ic < nkey ? this.keyList_.get(ic) : this.aggaccs_[ic - ia0].getResult();
                        }
                        throw new IllegalStateException("No current row");
                    }

                    public void close() {
                    }
                };
            }
        };
        return isCache ? StoragePolicy.getDefaultPolicy().copyTable((StarTable)outTable) : outTable;
    }

    private static Comparator<List<Object>> getListComparator(Class<?>[] clazzes, boolean nullsFirst) {
        final int n = clazzes.length;
        final boolean nullsLast = !nullsFirst;
        for (Class<?> clazz : clazzes) {
            if (Comparable.class.isAssignableFrom(clazz)) continue;
            return null;
        }
        return new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> list1, List<Object> list2) {
                for (int i = 0; i < n; ++i) {
                    int cmp = this.compareValues(list1.get(i), list2.get(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return list1.equals(list2) ? 0 : Integer.compare(list1.hashCode(), list2.hashCode());
            }

            private int compareValues(Object o1, Object o2) {
                boolean null2;
                boolean null1 = o1 == null;
                boolean bl = null2 = o2 == null;
                if (null1 && null2) {
                    return 0;
                }
                if (null1) {
                    return nullsLast ? 1 : -1;
                }
                if (null2) {
                    return nullsLast ? -1 : 1;
                }
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
        };
    }

    public static class AggSpec {
        private final String expr_;
        private final Aggregator aggregator_;
        private final String outName_;

        public AggSpec(String expr, Aggregator aggregator, String outName) {
            this.expr_ = expr;
            this.aggregator_ = aggregator;
            this.outName_ = outName;
        }

        public String getExpression() {
            return this.expr_;
        }

        public Aggregator getAggregator() {
            return this.aggregator_;
        }

        public String getOutputName() {
            return this.outName_;
        }
    }

    private static class GroupCollector
    extends RowCollector<Map<List<Object>, Aggregator.Accumulator[]>> {
        private final int nkey_;
        private final int nagg_;
        private final int ia0_;
        private final Aggregator.Aggregation[] aggregations_;

        GroupCollector(int nkey, Aggregator.Aggregation[] aggregations) {
            this.nkey_ = nkey;
            this.nagg_ = aggregations.length;
            this.aggregations_ = aggregations;
            this.ia0_ = nkey;
        }

        public Map<List<Object>, Aggregator.Accumulator[]> createAccumulator() {
            return new HashMap<List<Object>, Aggregator.Accumulator[]>();
        }

        public void accumulateRows(RowSplittable rseq, Map<List<Object>, Aggregator.Accumulator[]> map) throws IOException {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                Object[] keys = new Object[this.nkey_];
                for (int ik = 0; ik < this.nkey_; ++ik) {
                    keys[ik] = row[ik];
                }
                List<Object> keyList = Arrays.asList(keys);
                Aggregator.Accumulator[] aggaccs = map.computeIfAbsent(keyList, k -> this.createAggregateAccumulators());
                for (int ia = 0; ia < this.nagg_; ++ia) {
                    aggaccs[ia].submit(row[this.ia0_ + ia]);
                }
            }
        }

        public Map<List<Object>, Aggregator.Accumulator[]> combine(Map<List<Object>, Aggregator.Accumulator[]> map1, Map<List<Object>, Aggregator.Accumulator[]> map2) {
            Map<List<Object>, Aggregator.Accumulator[]> mapB;
            Map<List<Object>, Aggregator.Accumulator[]> mapA;
            if (map1.size() > map2.size()) {
                mapA = map1;
                mapB = map2;
            } else {
                mapA = map2;
                mapB = map1;
            }
            for (Map.Entry<List<Object>, Aggregator.Accumulator[]> entry : mapB.entrySet()) {
                List<Object> keyList = entry.getKey();
                Aggregator.Accumulator[] aggaccsB = entry.getValue();
                Aggregator.Accumulator[] aggaccsA = mapA.get(keyList);
                if (aggaccsA == null) {
                    mapA.put(keyList, aggaccsB);
                    continue;
                }
                for (int ia = 0; ia < this.nagg_; ++ia) {
                    aggaccsA[ia].add(aggaccsB[ia]);
                }
            }
            return mapA;
        }

        private Aggregator.Accumulator[] createAggregateAccumulators() {
            Aggregator.Accumulator[] aggaccs = new Aggregator.Accumulator[this.nagg_];
            for (int ia = 0; ia < this.nagg_; ++ia) {
                aggaccs[ia] = this.aggregations_[ia].createAccumulator();
            }
            return aggaccs;
        }
    }
}

