/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.join.Match1Type;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.join.Match1Mapping;
import uk.ac.starlink.ttools.join.Match1TypeParameter;
import uk.ac.starlink.ttools.join.MatchEngineParameter;
import uk.ac.starlink.ttools.join.ProgressIndicatorParameter;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.RowRunnerParameter;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.WordsParameter;

public class TableMatch1
extends SingleMapperTask {
    private final MatchEngineParameter matcherParam_;
    private final WordsParameter<String> tupleParam_;
    private final Match1TypeParameter type1Param_;
    private final ProgressIndicatorParameter progressParam_;
    private final Parameter<RowRunner> runnerParam_;

    public TableMatch1() {
        super("Performs a crossmatch internal to a single table", new ChoiceMode(), true, true);
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.matcherParam_ = new MatchEngineParameter("matcher");
        paramList.add(this.matcherParam_);
        paramList.add(this.matcherParam_.getMatchParametersParameter());
        paramList.add(this.matcherParam_.getTuningParametersParameter());
        this.tupleParam_ = this.matcherParam_.createMatchTupleParameter("");
        paramList.add(this.tupleParam_);
        this.type1Param_ = new Match1TypeParameter("action");
        paramList.add((Object)this.type1Param_);
        this.progressParam_ = new ProgressIndicatorParameter("progress");
        paramList.add((Object)this.progressParam_);
        this.runnerParam_ = RowRunnerParameter.createMatchRunnerParameter("runner");
        paramList.add(this.runnerParam_);
        this.getParameterList().addAll(0, paramList);
    }

    public Parameter<Match1Type> getMatch1TypeParameter() {
        return this.type1Param_;
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        MatchEngine matcher = this.matcherParam_.matchEngineValue(env);
        MatchEngineParameter.configureTupleParameter(this.tupleParam_, matcher);
        String[] tupleExprs = this.tupleParam_.wordsValue(env);
        Match1Type type1 = this.type1Param_.typeValue(env);
        ProgressIndicator progger = this.progressParam_.progressIndicatorValue(env);
        RowRunner runner = (RowRunner)this.runnerParam_.objectValue(env);
        final Match1Mapping mapping = new Match1Mapping(matcher, type1, tupleExprs, progger, runner);
        final TableProducer inProd = this.createInputProducer(env);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return mapping.map(inProd.getTable());
            }
        };
    }
}

