/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.stream.Collectors;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.task.WordParser;

public class WordsParameter<W>
extends Parameter<W[]> {
    private int nWords_ = -1;
    private final WordParser<W> parser_;

    public WordsParameter(String name, Class<W[]> arrayClazz, WordParser<W> parser) {
        super(name, arrayClazz, false);
        this.parser_ = parser;
    }

    public void setRequiredWordCount(int nWords) {
        this.nWords_ = nWords;
    }

    public int getRequiredWordCount() {
        return this.nWords_;
    }

    public WordParser<W> getWordParser() {
        return this.parser_;
    }

    public void setWordUsage(String wordUsage) {
        StringBuffer ubuf = new StringBuffer(wordUsage);
        if (this.nWords_ > 0) {
            for (int i = 1; i < this.nWords_; ++i) {
                ubuf.append(' ').append(wordUsage);
            }
        } else {
            ubuf.append(" ...");
        }
        this.setUsage(ubuf.toString());
    }

    public W[] wordsValue(Environment env) throws TaskException {
        return (Object[])this.objectValue(env);
    }

    public W[] stringToObject(Environment env, String sval) throws TaskException {
        return this.parseWords(this.stringToWords(sval));
    }

    public String objectToString(Environment env, W[] words) {
        return Arrays.stream(words).map(String::valueOf).collect(Collectors.joining(" "));
    }

    private String[] stringToWords(String sval) throws TaskException {
        String[] words = Tokenizer.tokenizeWords(sval);
        if (this.nWords_ >= 0 && this.nWords_ != words.length) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("Wrong number of words - wanted ").append(this.nWords_).append(", got ").append(words.length);
            throw new ParameterValueException((Parameter)this, sbuf.toString());
        }
        return words;
    }

    private W[] parseWords(String[] words) throws TaskException {
        if (words == null) {
            return null;
        }
        int nw = words.length;
        Class arrayClazz = this.getValueClass();
        Object[] parsedWords = (Object[])arrayClazz.cast(Array.newInstance(arrayClazz.getComponentType(), nw));
        for (int iw = 0; iw < nw; ++iw) {
            try {
                parsedWords[iw] = this.parser_.parseWord(words[iw]);
                continue;
            }
            catch (TaskException e) {
                StringBuffer msg = new StringBuffer(e.getMessage()).append(" in word \"").append(words[iw]).append('\"');
                throw new ParameterValueException((Parameter)this, msg.toString(), (Throwable)e);
            }
        }
        return parsedWords;
    }

    public static WordsParameter<String> createStringWordsParameter(String name) {
        return new WordsParameter<String>(name, String[].class, s -> s);
    }

    public static WordsParameter<Integer> createIntegerWordsParameter(String name) {
        return new WordsParameter<Integer>(name, Integer[].class, new WordParser<Integer>(){

            @Override
            public Integer parseWord(String word) throws TaskException {
                try {
                    return Integer.valueOf(word);
                }
                catch (NumberFormatException e) {
                    throw new UsageException("Bad integer format \"" + word + "\"", (Throwable)e);
                }
            }
        });
    }

    public static WordsParameter<Double> createDoubleWordsParameter(String name) {
        return new WordsParameter<Double>(name, Double[].class, new WordParser<Double>(){

            @Override
            public Double parseWord(String word) throws TaskException {
                try {
                    return Double.valueOf(word);
                }
                catch (NumberFormatException e) {
                    throw new UsageException("Bad number format \"" + word + "\"", (Throwable)e);
                }
            }
        });
    }

    public static WordsParameter<Boolean> createBooleanWordsParameter(String name) {
        return new WordsParameter<Boolean>(name, Boolean[].class, new WordParser<Boolean>(){

            @Override
            public Boolean parseWord(String cWord) throws TaskException {
                String word = cWord.toLowerCase();
                if ("true".equals(word) || "yes".equals(word) || "t".equals(word) || "y".equals(word)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(word) || "no".equals(word) || "f".equals(word) || "n".equals(word)) {
                    return Boolean.FALSE;
                }
                throw new UsageException("Not true/false/yes/no \"" + cWord + "\"");
            }
        });
    }
}

