/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.fits.CardType;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.HeaderValueException;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;

public class FitsHeader {
    private final ParsedCard<?>[] cards_;
    private final Map<String, CommentedValue> map_;
    private final Set<String> usedSet_;
    private final boolean isLax_;
    public final String[] BORING_KEYS = new String[]{"XTENSION", "PCOUNT", "GCOUNT", "BITPIX", "NAXIS", "END"};
    private static final BigInteger BIG_INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger BIG_INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BIG_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger BIG_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public FitsHeader(ParsedCard<?>[] cards) {
        this.cards_ = cards;
        this.map_ = FitsHeader.createMap(cards);
        this.usedSet_ = new HashSet<String>();
        this.isLax_ = true;
    }

    public ParsedCard<?>[] getCards() {
        return this.cards_;
    }

    public Object getValue(String key) {
        if (this.map_.containsKey(key)) {
            this.useKey(key);
            return this.map_.get((Object)key).value_;
        }
        return null;
    }

    public DescribedValue getDescribedValue(String key) {
        CommentedValue cvalue = this.map_.get(key);
        if (cvalue == null) {
            return null;
        }
        this.useKey(key);
        return FitsHeader.toDescribedValue(key, cvalue);
    }

    public Integer getIntValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String && this.isLax_) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Long getLongValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String && this.isLax_) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Double getDoubleValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String && this.isLax_) {
            try {
                return Double.parseDouble(((String)value).replace('D', 'E'));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Number getNumberValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String && this.isLax_) {
            try {
                return new BigDecimal(((String)value).replace('D', 'E'));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Boolean getBooleanValue(String key) {
        Object value = this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && this.isLax_) {
            String sval = ((String)value).trim();
            if ("T".equals(sval)) {
                return Boolean.TRUE;
            }
            if ("F".equals(sval)) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    public String getStringValue(String key) {
        Object value = this.getValue(key);
        return value == null ? null : value.toString();
    }

    public int getRequiredIntValue(String key) throws HeaderValueException {
        Integer valObj = this.getIntValue(key);
        if (valObj == null) {
            throw new HeaderValueException("Missing header " + key);
        }
        return valObj;
    }

    public long getRequiredLongValue(String key) throws HeaderValueException {
        Long valObj = this.getLongValue(key);
        if (valObj == null) {
            throw new HeaderValueException("Missing header " + key);
        }
        return valObj;
    }

    public String getRequiredStringValue(String key) throws HeaderValueException {
        String val = this.getStringValue(key);
        if (val == null) {
            throw new HeaderValueException("Missing header " + key);
        }
        return val;
    }

    public void useKey(String key) {
        this.usedSet_.add(key);
    }

    public long getHeaderBlockCount() {
        return FitsUtil.roundUp(this.cards_.length * 80, 2880) / 2880L;
    }

    public long getDataBlockCount() throws HeaderValueException {
        int i;
        Integer nAxis = this.getIntValue("NAXIS");
        Integer bitPix = this.getIntValue("BITPIX");
        if (nAxis == null || bitPix == null) {
            return 0L;
        }
        int naxis = nAxis;
        if (naxis == 0) {
            return 0L;
        }
        int bitpix = bitPix;
        Integer nAxis1 = this.getIntValue("NAXIS1");
        boolean isRandomGroups = nAxis1 != null && nAxis1 == 0 && Boolean.TRUE.equals(this.getBooleanValue("SIMPLE")) && Boolean.TRUE.equals(this.getBooleanValue("GROUPS"));
        long nel = 1L;
        int n = i = isRandomGroups ? 2 : 1;
        while (i <= naxis) {
            Long nAxisI = this.getLongValue("NAXIS" + i);
            if (nAxisI == null) {
                throw new HeaderValueException("Missing NAXIS" + i);
            }
            nel *= nAxisI.longValue();
            ++i;
        }
        long pcount = 0L;
        long gcount = 1L;
        if (this.getStringValue("XTENSION") != null || isRandomGroups) {
            Long pCount = this.getLongValue("PCOUNT");
            Long gCount = this.getLongValue("GCOUNT");
            if (pCount != null) {
                pcount = pCount;
            }
            if (gCount != null) {
                gCount = (long)gCount;
            }
        }
        long nbyte = (nel + pcount) * gcount * (long)Math.abs(bitpix) / 8L;
        return FitsUtil.roundUp(nbyte, 2880) / 2880L;
    }

    public long getHeaderByteCount() {
        return 2880L * this.getHeaderBlockCount();
    }

    public long getDataByteCount() throws HeaderValueException {
        return 2880L * this.getDataBlockCount();
    }

    public DescribedValue[] getUnusedParams() {
        ArrayList<DescribedValue> paramList = new ArrayList<DescribedValue>();
        HashSet<String> excludes = new HashSet<String>(this.usedSet_);
        excludes.addAll(Arrays.asList(this.BORING_KEYS));
        for (Map.Entry<String, CommentedValue> entry : this.map_.entrySet()) {
            String key = entry.getKey();
            CommentedValue cvalue = entry.getValue();
            if (excludes.contains(key)) continue;
            paramList.add(FitsHeader.toDescribedValue(key, cvalue));
        }
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<String> histories = new ArrayList<String>();
        for (ParsedCard<?> card : this.cards_) {
            CardType<?> type = card.getType();
            if (type.equals(CardType.HISTORY)) {
                histories.add(card.getComment());
                continue;
            }
            if (!type.equals(CardType.COMMENT)) continue;
            comments.add(card.getComment());
        }
        if (comments.size() > 0) {
            paramList.add(FitsHeader.toDescribedValue("COMMENT", comments));
        }
        if (histories.size() > 0) {
            paramList.add(FitsHeader.toDescribedValue("HISTORY", histories));
        }
        return paramList.toArray(new DescribedValue[0]);
    }

    private static DescribedValue toDescribedValue(String key, CommentedValue cvalue) {
        Object value = cvalue.value_;
        String comment = cvalue.comment_;
        DefaultValueInfo info = new DefaultValueInfo(key, value.getClass(), comment);
        return new DescribedValue(info, value);
    }

    private static DescribedValue toDescribedValue(String key, List<String> lines) {
        DefaultValueInfo info = new DefaultValueInfo(key, String[].class, "FITS " + key + " card values");
        return new DescribedValue(info, lines.toArray(new String[0]));
    }

    private static Number toCompactNumber(Number value) {
        if (value instanceof BigInteger) {
            BigInteger ibig = (BigInteger)value;
            if (ibig.compareTo(BIG_INT_MIN) >= 0 && ibig.compareTo(BIG_INT_MAX) <= 0) {
                return ibig.intValue();
            }
            if (ibig.compareTo(BIG_LONG_MIN) >= 0 && ibig.compareTo(BIG_LONG_MAX) <= 0) {
                return ibig.longValue();
            }
            return ibig;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        return value;
    }

    private static Map<String, CommentedValue> createMap(ParsedCard<?>[] cards) {
        int ncard = cards.length;
        LinkedHashMap<String, CommentedValue> map = new LinkedHashMap<String, CommentedValue>(ncard);
        for (int ic = 0; ic < ncard; ++ic) {
            ParsedCard<?> card = cards[ic];
            String key = card.getKey();
            Object value = card.getValue();
            String comment = card.getComment();
            if (key == null || value == null) continue;
            if (value instanceof String) {
                StringBuffer vbuf = new StringBuffer((String)value);
                StringBuffer cbuf = new StringBuffer();
                if (comment != null && comment.trim().length() > 0) {
                    cbuf.append(comment);
                }
                while (vbuf.length() > 0 && vbuf.charAt(vbuf.length() - 1) == '&' && ic < ncard - 1 && cards[ic + 1].getType() == CardType.CONTINUE) {
                    ParsedCard<?> card1 = cards[++ic];
                    Object value1 = card1.getValue();
                    String comment1 = card1.getComment();
                    if (value1 instanceof String) {
                        vbuf.setLength(vbuf.length() - 1);
                        vbuf.append((String)value1);
                    }
                    if (comment1 == null || comment1.trim().length() <= 0) continue;
                    if (cbuf.length() > 0) {
                        cbuf.append(' ');
                    }
                    cbuf.append(comment1);
                }
                map.put(key, new CommentedValue(vbuf.toString(), cbuf.length() > 0 ? cbuf.toString() : null));
                continue;
            }
            if (value instanceof Number) {
                value = FitsHeader.toCompactNumber((Number)value);
            }
            map.put(key, new CommentedValue(value, comment));
        }
        return map;
    }

    private static class CommentedValue {
        final Object value_;
        final String comment_;

        CommentedValue(Object value, String comment) {
            this.value_ = value;
            this.comment_ = comment;
        }
    }
}

