/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.Cell;
import uk.ac.starlink.table.join.MatchEngine;

public abstract class AbstractCartesianMatchEngine
implements MatchEngine {
    private final int ndim_;
    private final double[] scales_;
    private final double[] rBinSizes_;
    private final DescribedValue binFactorParam_;
    private double binFactor_;
    private static final double DEFAULT_BIN_FACTOR = 8.0;
    private static final DefaultValueInfo BINFACT_INFO = new DefaultValueInfo("Bin Factor", Double.class, "Scaling factor to adjust bin size; larger values mean larger bins");

    public AbstractCartesianMatchEngine(int ndim) {
        this.ndim_ = ndim;
        this.scales_ = new double[this.ndim_];
        this.rBinSizes_ = new double[this.ndim_];
        this.binFactor_ = 8.0;
        this.binFactorParam_ = new BinFactorParameter();
    }

    public int getNdim() {
        return this.ndim_;
    }

    public void setBinFactor(double binFactor) {
        if (!(binFactor > 0.0)) {
            throw new IllegalArgumentException("Bin factor must be >0");
        }
        this.binFactor_ = binFactor;
        for (int id = 0; id < this.ndim_; ++id) {
            this.configureScale(id);
        }
    }

    public double getBinFactor() {
        return this.binFactor_;
    }

    public void setIsotropicScale(double scale) {
        for (int id = 0; id < this.ndim_; ++id) {
            this.setScale(id, scale);
        }
    }

    public double getIsotropicScale() {
        return this.scales_[0];
    }

    protected void setScale(int idim, double scale) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("Scale must be >0");
        }
        this.scales_[idim] = scale;
        this.configureScale(idim);
    }

    protected double getScale(int idim) {
        return this.scales_[idim];
    }

    private void configureScale(int idim) {
        this.rBinSizes_[idim] = 1.0 / (this.scales_[idim] * this.binFactor_);
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return new DescribedValue[]{this.binFactorParam_};
    }

    Supplier<CartesianBinner> createBinnerFactory() {
        int ndim = this.ndim_;
        double[] scales = (double[])this.scales_.clone();
        double[] rBinSizes = (double[])this.rBinSizes_.clone();
        return () -> new CartesianBinner(ndim, scales, rBinSizes);
    }

    static double matchScore(int ndim, double[] coords1, double[] coords2, double err) {
        double err2 = err * err;
        double dist2 = 0.0;
        for (int id = 0; id < ndim; ++id) {
            double d = coords2[id] - coords1[id];
            if ((dist2 += d * d) <= err2) continue;
            return -1.0;
        }
        double score = Math.sqrt(dist2);
        assert (score >= 0.0 && score <= err);
        return score;
    }

    ValueInfo createCoordinateInfo(int idim) {
        DefaultValueInfo info = new DefaultValueInfo(this.getCoordinateName(idim), Number.class, this.getCoordinateDescription(idim));
        info.setNullable(false);
        return info;
    }

    String getCoordinateName(int idim) {
        return this.ndim_ <= 3 ? (new String[]{"X", "Y", "Z"})[idim] : "Co-ord #" + (idim + 1);
    }

    String getCoordinateDescription(int idim) {
        return "Cartesian co-ordinate #" + (idim + 1);
    }

    public abstract String toString();

    static double getNumberValue(Object numobj) {
        return numobj instanceof Number ? ((Number)numobj).doubleValue() : Double.NaN;
    }

    private static Labeller createLabeller(int ndim) {
        switch (ndim) {
            case 1: {
                return array -> {
                    long val = array[0];
                    int ival = (int)val;
                    return (long)ival == val ? (long)Integer.valueOf(ival).intValue() : Long.valueOf(val);
                };
            }
            case 2: {
                return array -> {
                    long x = array[0];
                    long y = array[1];
                    int ix = (int)x;
                    int iy = (int)y;
                    return (long)ix == x && (long)iy == y ? Long.valueOf(x << 32 | y & 0xFFFFFFFFL) : new Cell((long[])array.clone());
                };
            }
        }
        return array -> new Cell((long[])array.clone());
    }

    @FunctionalInterface
    private static interface Labeller {
        public Object createLabel(long[] var1);
    }

    class IsotropicScaleParameter
    extends DescribedValue {
        public IsotropicScaleParameter(ValueInfo info) {
            super(info);
        }

        @Override
        public Object getValue() {
            return AbstractCartesianMatchEngine.this.getIsotropicScale();
        }

        @Override
        public void setValue(Object value) {
            AbstractCartesianMatchEngine.this.setIsotropicScale(((Number)value).doubleValue());
        }
    }

    class BinFactorParameter
    extends DescribedValue {
        BinFactorParameter() {
            super(BINFACT_INFO);
        }

        @Override
        public Object getValue() {
            return AbstractCartesianMatchEngine.this.getBinFactor();
        }

        @Override
        public void setValue(Object value) {
            AbstractCartesianMatchEngine.this.setBinFactor(((Number)value).doubleValue());
        }
    }

    static class CartesianBinner {
        private final int ndim_;
        private final double[] scales_;
        private final double[] rBinSizes_;
        private final Labeller labeller_;
        private final long[] llo_;
        private final long[] lhi_;
        private static final Object[] NO_BINS = new Object[0];

        CartesianBinner(int ndim, double[] scales, double[] rBinSizes) {
            this.ndim_ = ndim;
            this.scales_ = scales;
            this.rBinSizes_ = rBinSizes;
            this.labeller_ = AbstractCartesianMatchEngine.createLabeller(ndim);
            this.llo_ = new long[ndim];
            this.lhi_ = new long[ndim];
        }

        public int getNdim() {
            return this.ndim_;
        }

        public Object[] getRadiusBins(double[] coords, double radius) {
            return radius >= 0.0 ? this.doGetBins(coords, radius) : NO_BINS;
        }

        public Object[] getScaleBins(double[] coords) {
            return this.doGetBins(coords, Double.NaN);
        }

        public void toCoords(Object[] tuple, double[] coords) {
            for (int id = 0; id < this.ndim_; ++id) {
                coords[id] = AbstractCartesianMatchEngine.getNumberValue(tuple[id]);
            }
        }

        private Object[] doGetBins(double[] coords, double radius) {
            boolean useScale = Double.isNaN(radius);
            int ncell = 1;
            for (int id = 0; id < this.ndim_; ++id) {
                double c0 = coords[id];
                if (Double.isNaN(c0)) {
                    return NO_BINS;
                }
                double r = useScale ? this.scales_[id] : radius;
                this.llo_[id] = this.getLabelComponent(id, c0 - r);
                this.lhi_[id] = this.getLabelComponent(id, c0 + r);
                long extent = this.lhi_[id] - this.llo_[id] + 1L;
                assert ((long)((int)extent) == extent);
                ncell *= (int)extent;
            }
            Object[] cells = new Object[ncell];
            long[] indices = (long[])this.llo_.clone();
            block1: for (int ic = 0; ic < ncell; ++ic) {
                cells[ic] = this.labeller_.createLabel(indices);
                for (int jd = 0; jd < this.ndim_; ++jd) {
                    int n = jd;
                    indices[n] = indices[n] + 1L;
                    if (indices[n] <= this.lhi_[jd]) continue block1;
                    indices[jd] = this.llo_[jd];
                }
            }
            assert (Arrays.equals(indices, this.llo_));
            assert (new HashSet<Object>(Arrays.asList(cells)).size() == cells.length);
            return cells;
        }

        private long getLabelComponent(int idim, double coord) {
            return (long)Math.floor(coord * this.rBinSizes_[idim]);
        }
    }
}

