/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import cds.healpix.FlatHashIterator;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import java.util.function.Supplier;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.FixedRadiusConePixer;
import uk.ac.starlink.table.join.HealpixSkyPixellator;
import uk.ac.starlink.table.join.VariableRadiusConePixer;

public class CdsHealpixSkyPixellator
extends HealpixSkyPixellator {
    private int depth_;
    private static final int DEFAULT_SCALE_FACTOR = 8;

    public CdsHealpixSkyPixellator() {
        super(29);
    }

    @Override
    protected void configureK(int k) {
        this.depth_ = k;
    }

    @Override
    public Supplier<VariableRadiusConePixer> createVariableRadiusPixerFactory() {
        int depth = this.depth_;
        return () -> new CdsHealpixVariablePixer(depth);
    }

    @Override
    public Supplier<FixedRadiusConePixer> createFixedRadiusPixerFactory(double radius) {
        int depth = this.depth_;
        return () -> new CdsHealpixFixedPixer(depth, radius);
    }

    @Override
    public int calculateDefaultK(double scale) {
        return Math.max(0, Healpix.getBestStartingDepth(8.0 * scale));
    }

    private static class CdsHealpixFixedPixer
    implements FixedRadiusConePixer {
        final int depth_;
        final HealpixNestedFixedRadiusConeComputer coneComputer_;

        CdsHealpixFixedPixer(int depth, double radius) {
            this.depth_ = depth;
            this.coneComputer_ = Healpix.getNested(this.depth_).newConeComputerApprox(radius);
        }

        public Long[] getPixels(double alpha, double delta) {
            HealpixNestedBMOC bmoc = this.coneComputer_.overlappingCells(alpha, delta);
            assert (bmoc.getDepthMax() == this.depth_);
            int npix = Tables.checkedLongToInt(bmoc.computeDeepSize());
            Long[] pixels = new Long[npix];
            FlatHashIterator flit = bmoc.flatHashIterator();
            for (int ipix = 0; ipix < npix; ++ipix) {
                assert (flit.hasNext());
                pixels[ipix] = flit.next();
            }
            assert (!flit.hasNext());
            return pixels;
        }
    }

    private static class CdsHealpixVariablePixer
    implements VariableRadiusConePixer {
        final int depth_;
        final HealpixNested healpixNested_;

        CdsHealpixVariablePixer(int depth) {
            this.depth_ = depth;
            this.healpixNested_ = Healpix.getNested(this.depth_);
        }

        public Long[] getPixels(double alpha, double delta, double radius) {
            HealpixNestedBMOC bmoc = this.healpixNested_.newConeComputerApprox(radius).overlappingCells(alpha, delta);
            assert (bmoc.getDepthMax() == this.depth_);
            int npix = Tables.checkedLongToInt(bmoc.computeDeepSize());
            Long[] pixels = new Long[npix];
            FlatHashIterator flit = bmoc.flatHashIterator();
            for (int ipix = 0; ipix < npix; ++ipix) {
                assert (flit.hasNext());
                pixels[ipix] = flit.next();
            }
            assert (!flit.hasNext());
            return pixels;
        }
    }
}

