/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchKit;

public class HumanMatchEngine
implements MatchEngine {
    private final MatchEngine baseEngine_;
    private final ValueInfo[] tupleInfos_;
    private final DescribedValue[] matchParams_;
    private final DescribedValue[] tuningParams_;
    private final ValueWrapper[] tupleWrappers_;
    private final ValueWrapper scoreWrapper_;
    private final ValueInfo scoreInfo_;
    private final int nval_;
    private final boolean isIdentity_;
    private static final double DEGREE_RADIANS = Math.PI / 180;
    private static final double ARC_SECOND_RADIANS = 4.84813681109536E-6;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.join");
    private static ValueWrapper NULL_WRAPPER = new ValueWrapper(){

        @Override
        public Object wrapValue(Object value) {
            return value;
        }

        @Override
        public Object unwrapValue(Object value) {
            return value;
        }

        @Override
        public double wrapDouble(double value) {
            return value;
        }

        @Override
        public ValueInfo wrapValueInfo(ValueInfo info) {
            return info;
        }

        @Override
        public DescribedValue wrapDescribedValue(DescribedValue dval) {
            return dval;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }
    };

    public HumanMatchEngine(MatchEngine baseEngine) {
        this.baseEngine_ = baseEngine;
        boolean isIdentity = true;
        ValueInfo[] tinfos = baseEngine.getTupleInfos();
        this.nval_ = tinfos.length;
        this.tupleWrappers_ = new ValueWrapper[this.nval_];
        this.tupleInfos_ = new ValueInfo[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            this.tupleWrappers_[i] = this.createWrapper(tinfos[i]);
            this.tupleInfos_[i] = this.tupleWrappers_[i].wrapValueInfo(tinfos[i]);
            isIdentity &= this.tupleWrappers_[i].isIdentity();
        }
        DescribedValue[] mParams = baseEngine.getMatchParameters();
        this.matchParams_ = new DescribedValue[mParams.length];
        for (int i = 0; i < mParams.length; ++i) {
            DescribedValue param = mParams[i];
            ValueWrapper pWrapper = this.createWrapper(param.getInfo());
            this.matchParams_[i] = pWrapper.wrapDescribedValue(param);
            isIdentity &= pWrapper.isIdentity();
        }
        DescribedValue[] tParams = baseEngine.getTuningParameters();
        this.tuningParams_ = new DescribedValue[tParams.length];
        for (int i = 0; i < tParams.length; ++i) {
            DescribedValue param = tParams[i];
            ValueWrapper tWrapper = this.createWrapper(param.getInfo());
            this.tuningParams_[i] = tWrapper.wrapDescribedValue(param);
            isIdentity &= tWrapper.isIdentity();
        }
        ValueInfo minfo = baseEngine.getMatchScoreInfo();
        if (minfo != null) {
            this.scoreWrapper_ = this.createWrapper(minfo);
            this.scoreInfo_ = this.scoreWrapper_.wrapValueInfo(minfo);
            isIdentity &= this.scoreWrapper_.isIdentity();
        } else {
            this.scoreWrapper_ = NULL_WRAPPER;
            this.scoreInfo_ = null;
        }
        this.isIdentity_ = isIdentity;
    }

    public boolean isIdentity() {
        return this.isIdentity_;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return this.tuningParams_;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return this.tupleInfos_;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        final Supplier<MatchKit> baseKitFact = this.baseEngine_.createMatchKitFactory();
        return () -> new MatchKit(){
            final MatchKit baseKit;
            {
                this.baseKit = (MatchKit)baseKitFact.get();
            }

            @Override
            public Object[] getBins(Object[] tuple) {
                return this.baseKit.getBins(HumanMatchEngine.this.unwrapTuple(tuple));
            }

            @Override
            public double matchScore(Object[] tuple1, Object[] tuple2) {
                return HumanMatchEngine.this.scoreWrapper_.wrapDouble(this.baseKit.matchScore(HumanMatchEngine.this.unwrapTuple(tuple1), HumanMatchEngine.this.unwrapTuple(tuple2)));
            }
        };
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        final Supplier<Coverage> baseFact = this.baseEngine_.createCoverageFactory();
        return () -> new Coverage(){
            final Coverage baseCoverage;
            {
                this.baseCoverage = (Coverage)baseFact.get();
            }

            @Override
            public boolean isEmpty() {
                return this.baseCoverage.isEmpty();
            }

            @Override
            public void intersection(Coverage other) {
                this.baseCoverage.intersection(other);
            }

            @Override
            public void union(Coverage other) {
                this.baseCoverage.union(other);
            }

            @Override
            public void extend(Object[] tuple) {
                this.baseCoverage.extend(HumanMatchEngine.this.unwrapTuple(tuple));
            }

            @Override
            public Supplier<Predicate<Object[]>> createTestFactory() {
                Predicate<Object[]> baseTest = this.baseCoverage.createTestFactory().get();
                return () -> tuple -> baseTest.test(HumanMatchEngine.this.unwrapTuple(tuple));
            }

            @Override
            public String coverageText() {
                return "WRONG UNITS[" + this.baseCoverage.coverageText() + "]";
            }
        };
    }

    @Override
    public double getScoreScale() {
        return this.scoreWrapper_.wrapDouble(this.baseEngine_.getScoreScale());
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return this.scoreInfo_;
    }

    private Object[] unwrapTuple(Object[] wrapped) {
        Object[] unwrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            unwrapped[i] = this.tupleWrappers_[i].unwrapValue(wrapped[i]);
        }
        return unwrapped;
    }

    private Object[] wrapTuple(Object[] unwrapped) {
        Object[] wrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            wrapped[i] = this.tupleWrappers_[i].wrapValue(unwrapped[i]);
        }
        return wrapped;
    }

    private ValueWrapper createWrapper(ValueInfo info) {
        Class<?> clazz;
        String units = info == null ? null : info.getUnitString();
        Class<?> clazz2 = clazz = info == null ? null : info.getContentClass();
        if (("radians".equals(units) || "radian".equals(units) || "rad".equals(units)) && (clazz == Double.class || clazz == Number.class)) {
            if (this.isSmallAngle(info)) {
                return new DoubleFactorWrapper(4.84813681109536E-6, "arcsec");
            }
            if (this.isLargeAngle(info)) {
                return new DoubleFactorWrapper(Math.PI / 180, "deg");
            }
            logger_.warning("Unknown angular quantity " + info + " - convert to degrees");
            return new DoubleFactorWrapper(Math.PI / 180, "deg");
        }
        return NULL_WRAPPER;
    }

    public boolean isLargeAngle(ValueInfo info) {
        String ucd = info.getUCD();
        if (ucd == null) {
            return false;
        }
        String lucd = ucd.toLowerCase();
        return lucd.matches("pos[\\._](eq|az|earth|ecliptic|galactic|supergalactic)[\\._].*") || lucd.startsWith("pos.posAng".toLowerCase());
    }

    public boolean isSmallAngle(ValueInfo info) {
        String ucd = info.getUCD();
        if (ucd == null) {
            return false;
        }
        String lucd = ucd.toLowerCase();
        return lucd.startsWith("pos.angDistance".toLowerCase()) || lucd.startsWith("pos.angResolution".toLowerCase()) || lucd.startsWith("phys.angSize".toLowerCase());
    }

    public static MatchEngine getHumanMatchEngine(MatchEngine base) {
        HumanMatchEngine human = new HumanMatchEngine(base);
        return human.isIdentity() ? base : human;
    }

    private static class DoubleFactorWrapper
    extends ValueWrapper {
        final double factor_;
        final String units_;

        DoubleFactorWrapper(double factor, String units) {
            this.factor_ = factor;
            this.units_ = units;
        }

        @Override
        public Object wrapValue(Object value) {
            return value instanceof Number ? Double.valueOf(((Number)value).doubleValue() / this.factor_) : null;
        }

        @Override
        public Object unwrapValue(Object value) {
            return value instanceof Number ? Double.valueOf(((Number)value).doubleValue() * this.factor_) : null;
        }

        @Override
        public double wrapDouble(double value) {
            return value / this.factor_;
        }

        @Override
        public ValueInfo wrapValueInfo(ValueInfo info) {
            DefaultValueInfo vinfo = new DefaultValueInfo(info);
            vinfo.setUnitString(this.units_);
            return vinfo;
        }

        @Override
        public DescribedValue wrapDescribedValue(final DescribedValue dval) {
            return new DescribedValue(this.wrapValueInfo(dval.getInfo()), this.wrapValue(dval.getValue())){

                @Override
                public Object getValue() {
                    return this.wrapValue(dval.getValue());
                }

                @Override
                public void setValue(Object value) {
                    dval.setValue(this.unwrapValue(value));
                }
            };
        }

        @Override
        public boolean isIdentity() {
            return false;
        }
    }

    private static abstract class ValueWrapper {
        private ValueWrapper() {
        }

        public abstract Object unwrapValue(Object var1);

        public abstract Object wrapValue(Object var1);

        public abstract double wrapDouble(double var1);

        public abstract ValueInfo wrapValueInfo(ValueInfo var1);

        public abstract DescribedValue wrapDescribedValue(DescribedValue var1);

        public abstract boolean isIdentity();
    }
}

