/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import org.json.JSONArray;
import org.json.JSONObject;

public interface HapiBins {
    public String getName();

    public double[] getCenters();

    public double[][] getRanges();

    public String getUnits();

    public String getLabel();

    public String getDescription();

    public static HapiBins fromJson(JSONObject json) {
        Object ranges;
        JSONArray rangesArray;
        double[] centers;
        final String name = json.optString("name", null);
        String units = json.optString("units", null);
        String label = json.optString("label", null);
        String description = json.optString("description", null);
        JSONArray centersArray = json.optJSONArray("centers");
        if (centersArray != null) {
            int nc = centersArray.length();
            centers = new double[nc];
            for (int ic = 0; ic < nc; ++ic) {
                centers[ic] = centersArray.optDouble(ic);
            }
        } else {
            centers = null;
        }
        if ((rangesArray = json.optJSONArray("ranges")) != null) {
            int nr = rangesArray.length();
            ranges = new double[nr][];
            for (int ir = 0; ir < nr; ++ir) {
                double hi;
                double lo;
                JSONArray rangeArray = rangesArray.optJSONArray(ir);
                if (rangeArray == null || rangeArray.length() != 2 || !((lo = rangeArray.optDouble(0)) < (hi = rangeArray.optDouble(1)))) continue;
                ranges[ir] = new double[]{lo, hi};
            }
        } else {
            ranges = null;
        }
        return new HapiBins((double[][])ranges, units, label, description){
            final /* synthetic */ double[][] val$ranges;
            final /* synthetic */ String val$units;
            final /* synthetic */ String val$label;
            final /* synthetic */ String val$description;
            {
                this.val$ranges = dArray2;
                this.val$units = string2;
                this.val$label = string3;
                this.val$description = string4;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public double[] getCenters() {
                return centers;
            }

            @Override
            public double[][] getRanges() {
                return this.val$ranges;
            }

            @Override
            public String getUnits() {
                return this.val$units;
            }

            @Override
            public String getLabel() {
                return this.val$label;
            }

            @Override
            public String getDescription() {
                return this.val$description;
            }
        };
    }
}

