/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.ValueType;

public class MessageDefinition {
    private final URI id_;
    private final ValueType[] argTypes_;
    private final ValueType returnType_;
    private final int requiredArgs_;
    public static final MessageDefinition TEST_ECHO = new MessageDefinition(MessageId.TEST_ECHO.toString(), new ValueType[]{ValueType.STRING}, ValueType.STRING);
    public static final MessageDefinition INFO_GETIVORN;
    public static final MessageDefinition INFO_GETNAME;
    public static final MessageDefinition INFO_GETDESCRIPTION;
    public static final MessageDefinition INFO_GETVERSION;
    public static final MessageDefinition INFO_GETICONURL;
    public static final MessageDefinition HUB_APPREG;
    public static final MessageDefinition HUB_APPUNREG;
    public static final MessageDefinition HUB_STOPPING;
    public static final MessageDefinition VOT_LOAD;
    public static final MessageDefinition VOT_LOADURL;
    public static final MessageDefinition VOT_SHOWOBJECTS;
    public static final MessageDefinition VOT_HIGHLIGHTOBJECT;
    public static final MessageDefinition FITS_LOADLINE;
    public static final MessageDefinition FITS_LOADIMAGE;
    public static final MessageDefinition FITS_LOADCUBE;
    public static final MessageDefinition SKY_POINT;
    public static final MessageDefinition SPECTRUM_LOADURL;
    private static final Map MESSAGE_MAP;
    private static final MessageDefinition[] KNOWN_MESSAGES;

    public MessageDefinition(String id, ValueType[] argTypes, ValueType returnType, int requiredArgs) {
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad URI: " + id).initCause(e);
        }
        this.argTypes_ = argTypes;
        this.returnType_ = returnType;
        this.requiredArgs_ = requiredArgs;
    }

    public MessageDefinition(String id, ValueType[] argTypes, ValueType returnType) {
        this(id, argTypes, returnType, argTypes.length);
    }

    public URI getId() {
        return this.id_;
    }

    public ValueType[] getArgTypes() {
        return (ValueType[])this.argTypes_.clone();
    }

    public ValueType getReturnType() {
        return this.returnType_;
    }

    public int getRequiredArgs() {
        return this.requiredArgs_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getReturnType().toString());
        sbuf.append(' ');
        sbuf.append(this.getId());
        sbuf.append("(");
        ValueType[] types = this.getArgTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sbuf.append(',');
            }
            sbuf.append(types[i]);
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    public static MessageDefinition[] getKnownMessages() {
        return (MessageDefinition[])KNOWN_MESSAGES.clone();
    }

    public static MessageDefinition getMessage(URI id) {
        return (MessageDefinition)MESSAGE_MAP.get(id);
    }

    static {
        KNOWN_MESSAGES = new MessageDefinition[]{TEST_ECHO, INFO_GETIVORN = new MessageDefinition(MessageId.INFO_GETIVORN.toString(), new ValueType[0], ValueType.STRING_IVORN), INFO_GETNAME = new MessageDefinition(MessageId.INFO_GETNAME.toString(), new ValueType[0], ValueType.STRING), INFO_GETDESCRIPTION = new MessageDefinition(MessageId.INFO_GETDESCRIPTION.toString(), new ValueType[0], ValueType.STRING), INFO_GETVERSION = new MessageDefinition(MessageId.INFO_GETVERSION.toString(), new ValueType[0], ValueType.STRING), INFO_GETICONURL = new MessageDefinition(MessageId.INFO_GETICONURL.toString(), new ValueType[0], ValueType.STRING_URL), HUB_APPREG = new MessageDefinition(MessageId.HUB_APPREG.toString(), new ValueType[]{ValueType.STRING_URI}, ValueType.VOID), HUB_APPUNREG = new MessageDefinition(MessageId.HUB_APPUNREG.toString(), new ValueType[]{ValueType.STRING_URI}, ValueType.VOID), HUB_STOPPING = new MessageDefinition(MessageId.HUB_STOPPING.toString(), new ValueType[0], ValueType.VOID), VOT_LOAD = new MessageDefinition(MessageId.VOT_LOAD.toString(), new ValueType[]{ValueType.STRING, ValueType.STRING}, ValueType.BOOLEAN), VOT_LOADURL = new MessageDefinition(MessageId.VOT_LOADURL.toString(), new ValueType[]{ValueType.STRING_URL}, ValueType.BOOLEAN), VOT_SHOWOBJECTS = new MessageDefinition(MessageId.VOT_SHOWOBJECTS.toString(), new ValueType[]{ValueType.STRING, ValueType.LIST_INTS}, ValueType.BOOLEAN), VOT_HIGHLIGHTOBJECT = new MessageDefinition(MessageId.VOT_HIGHLIGHTOBJECT.toString(), new ValueType[]{ValueType.STRING, ValueType.INT}, ValueType.BOOLEAN), FITS_LOADLINE = new MessageDefinition(MessageId.FITS_LOADLINE.toString(), new ValueType[]{ValueType.STRING_URL, ValueType.STRING, ValueType.INT}, ValueType.BOOLEAN, 1), FITS_LOADIMAGE = new MessageDefinition(MessageId.FITS_LOADIMAGE.toString(), new ValueType[]{ValueType.STRING_URL, ValueType.STRING, ValueType.INT}, ValueType.BOOLEAN, 1), FITS_LOADCUBE = new MessageDefinition(MessageId.FITS_LOADCUBE.toString(), new ValueType[]{ValueType.STRING_URL, ValueType.STRING, ValueType.INT}, ValueType.BOOLEAN, 1), SKY_POINT = new MessageDefinition(MessageId.SKY_POINT.toString(), new ValueType[]{ValueType.DOUBLE, ValueType.DOUBLE}, ValueType.BOOLEAN), SPECTRUM_LOADURL = new MessageDefinition(MessageId.SPECTRUM_LOADURL.toString(), new ValueType[]{ValueType.STRING_URL, ValueType.STRING, ValueType.MAP}, ValueType.BOOLEAN)};
        HashMap<URI, MessageDefinition> map = new HashMap<URI, MessageDefinition>();
        for (int i = 0; i < KNOWN_MESSAGES.length; ++i) {
            MessageDefinition def = KNOWN_MESSAGES[i];
            map.put(def.getId(), def);
        }
        MESSAGE_MAP = Collections.unmodifiableMap(map);
    }
}

