/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class JSamp {
    static final String[] COMMAND_CLASSES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JSamp() {
    }

    public static int runMain(String[] args) {
        StringBuffer ubuf = new StringBuffer().append("\n   Usage:").append("\n      ").append(JSamp.class.getName()).append(" [-help]").append(" [-version]").append(" <command>").append(" [-help]").append(" <cmd-args>").append("\n      ").append("<command-class>").append(" [-help]").append(" <cmd-args>").append("\n").append("\n   Commands (command-classes) are:");
        for (int ic = 0; ic < COMMAND_CLASSES.length; ++ic) {
            String className = COMMAND_CLASSES[ic];
            ubuf.append("\n      ").append(JSamp.abbrev(className));
            int pad = 14 - JSamp.abbrev(className).length();
            for (int i = 0; i < pad; ++i) {
                ubuf.append(' ');
            }
            ubuf.append("  (").append(className).append(")");
        }
        ubuf.append("\n").append("\n   ").append("Environment Variable:").append("\n      ").append("SAMP_HUB").append("           = ").append("std-lockurl:").append("<url>").append("|").append("web-appname:").append("<name>").append("\n                                            ").append("|").append("jsamp-class:").append("<clientprofile-class>").append("\n").append("\n   ").append("System Properties:").append("\n      ").append("jsamp.hub.profiles   = ").append("std|web|<hubprofile-class>[,...]").append("\n      ").append("jsamp.localhost      = ").append("\"[hostname]\"|\"[hostnumber]\"|<value>").append("\n      ").append("jsamp.server.port    = ").append("<port-number>").append("\n      ").append("jsamp.web.extrahosts = ").append("<host>[,...]").append("\n      ").append("jsamp.xmlrpc.impl    = ").append(JSamp.formatImpls(XmlRpcKit.KNOWN_IMPLS, XmlRpcKit.class)).append("\n");
        String usage = ubuf.toString();
        JSamp.setDefaultProperty("java.awt.Window.locationByPlatform", "true");
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        if (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.toLowerCase().equals("hubrunner")) {
                System.err.println("\"hubrunner\" command is deprecated. Use \"hub\" instead.");
                return 1;
            }
            for (int ic = 0; ic < COMMAND_CLASSES.length; ++ic) {
                String className = COMMAND_CLASSES[ic];
                if (!arg.toLowerCase().equals(JSamp.abbrev(className).toLowerCase())) continue;
                it.remove();
                return JSamp.runCommand(className, argList.toArray(new String[0]));
            }
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return 0;
            }
            if (arg.startsWith("-vers")) {
                System.out.println();
                System.out.println(JSamp.getVersionText());
                System.out.println();
                return 0;
            }
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        System.err.println(JSamp.class.getName() + " invoked with no arguments - running hub");
        System.err.println("Use \"-help\" flag for more options");
        System.err.println("Use \"hub\" argument to suppress this message");
        return JSamp.runCommand(Hub.class.getName(), new String[0]);
    }

    private static int runCommand(String className, String[] args) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class " + className + " not available");
            return 1;
        }
        try {
            JSamp.getMainMethod(clazz).invoke(null, new Object[]{args});
            return 0;
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    static Method getMainMethod(Class clazz) {
        Method method;
        try {
            method = clazz.getMethod("main", String;.class);
        }
        catch (NoSuchMethodException e) {
            throw (IllegalArgumentException)((Throwable)((Object)new AssertionError((Object)("main() method missing for " + clazz.getName())))).initCause(e);
        }
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods) && Modifier.isPublic(mods) && method.getReturnType() == Void.TYPE) {
            return method;
        }
        throw new IllegalArgumentException("Wrong main() method signature for " + clazz.getName());
    }

    private static String abbrev(String className) {
        return className.substring(className.lastIndexOf(".") + 1).toLowerCase();
    }

    private static String formatImpls(Object[] options, Class clazz) {
        StringBuffer sbuf = new StringBuffer();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (sbuf.length() > 0) {
                    sbuf.append('|');
                }
                sbuf.append(options[i]);
            }
        }
        if (clazz != null) {
            if (sbuf.length() > 0) {
                sbuf.append('|');
            }
            sbuf.append('<').append(clazz.getName().replaceFirst("^.*\\.", "").toLowerCase()).append("-class").append('>');
        }
        return sbuf.toString();
    }

    private static String getVersionText() {
        return "   This is JSAMP.\n" + "\n   " + "JSAMP toolkit version:" + "\n      " + SampUtils.getSoftwareVersion() + "\n   " + "SAMP standard version:" + "\n      " + SampUtils.getSampVersion() + "\n   " + "Author:" + "\n      " + "Mark Taylor (m.b.taylor@bristol.ac.uk)" + "\n   " + "WWW:" + "\n      " + "http://www.star.bristol.ac.uk/~mbt/jsamp";
    }

    private static void setDefaultProperty(String key, String value) {
        String existingVal = System.getProperty(key);
        if (existingVal == null || existingVal.trim().length() == 0) {
            try {
                System.setProperty(key, value);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        int status = JSamp.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    static {
        $assertionsDisabled = !JSamp.class.desiredAssertionStatus();
        COMMAND_CLASSES = new String[]{"org.astrogrid.samp.hub.Hub", "org.astrogrid.samp.gui.HubMonitor", "org.astrogrid.samp.util.SampLoad", "org.astrogrid.samp.test.Snooper", "org.astrogrid.samp.test.MessageSender", "org.astrogrid.samp.test.HubTester", "org.astrogrid.samp.test.CalcStorm", "org.astrogrid.samp.bridge.Bridge"};
    }
}

