/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlTracker {
    private final Set permittedSet_;
    private final Set blockedSet_;
    private final String[] localhostNames_;
    private final Logger logger_ = Logger.getLogger(UrlTracker.class.getName());

    public UrlTracker() {
        this.permittedSet_ = new HashSet();
        this.blockedSet_ = new HashSet();
        ArrayList<String> localNameList = new ArrayList<String>();
        localNameList.add("localhost");
        localNameList.add("127.0.0.1");
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            localNameList.add(localAddr.getHostName());
            localNameList.add(localAddr.getHostAddress());
            localNameList.add(localAddr.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            this.logger_.log(Level.WARNING, "Can't determine local host name", e);
        }
        this.localhostNames_ = localNameList.toArray(new String[0]);
    }

    public synchronized void noteIncomingUrl(URL url) {
        if (this.isSensitive(url) && !this.blockedSet_.contains(url) && this.permittedSet_.add(url)) {
            this.logger_.config("Mark for translate permission URL " + url);
        }
    }

    public synchronized void noteOutgoingUrl(URL url) {
        if (this.isSensitive(url) && !this.permittedSet_.contains(url) && this.blockedSet_.add(url)) {
            this.logger_.config("Mark for translate blocking URL " + url);
        }
    }

    public synchronized boolean isUrlPermitted(URL url) {
        if (this.isSensitive(url)) {
            if (this.permittedSet_.contains(url)) {
                this.logger_.config("Translation permitted for marked URL " + url);
                return true;
            }
            this.logger_.warning("Translation denied for unmarked URL " + url);
            return false;
        }
        this.logger_.config("Translation permitted for non-sensitive URL " + url);
        return true;
    }

    protected boolean isSensitive(URL url) {
        return true;
    }

    private boolean isLocalHost(String host) {
        if (host == null || host.length() == 0) {
            return true;
        }
        for (int i = 0; i < this.localhostNames_.length; ++i) {
            if (!host.equalsIgnoreCase(this.localhostNames_[i])) continue;
            return true;
        }
        return false;
    }
}

