/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.xml.sax.SAXException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.cea.CeaConfig;
import uk.ac.starlink.ttools.cea.CeaMetadata;
import uk.ac.starlink.ttools.cea.CeaTask;
import uk.ac.starlink.ttools.cea.CeaWriter;
import uk.ac.starlink.ttools.cea.ElementDeclaration;

public class ServiceCeaWriter
extends CeaWriter {
    private static final String AG_SCHEMA_BASE = "http://www.astrogrid.org/schema/";
    private static final String IVOA_SCHEMA_BASE = "http://www.ivoa.net/xml/";
    private static final String VOR_NS = "http://www.ivoa.net/xml/RegistryInterface/v0.1";
    private static final String VRX_NS = "http://www.ivoa.net/xml/VOResource/v0.10";
    private static final String CEAS_NS = "http://www.ivoa.net/xml/CEAService/v0.2";
    private static final String CEAB_NS = "http://www.astrogrid.org/schema/CommonExecutionArchitectureBase/v1";
    private static final String AGPD_NS = "http://www.astrogrid.org/schema/AGParameterDefinition/v1";
    public static final String SCHEMA_LOCATION = "http://software.astrogrid.org/schema/vo-resource-types/CEAService/v0.2/CEAService.xsd";
    private final CeaMetadata meta_;

    public ServiceCeaWriter(PrintStream out, CeaTask[] tasks, CeaMetadata meta, boolean redirects, String cmdline) {
        super(out, ServiceCeaWriter.createServiceConfig(), tasks, redirects, cmdline);
        this.meta_ = meta;
    }

    public static String getUsage() {
        return "";
    }

    @Override
    public int configure(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (!argList.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void writeContent() throws SAXException {
        this.startElement("vor:Resource", ServiceCeaWriter.formatAttribute((String)"xmlns", (String)VRX_NS) + ServiceCeaWriter.formatAttribute((String)"xmlns:vor", (String)VOR_NS) + ServiceCeaWriter.formatAttribute((String)"xmlns:ceas", (String)CEAS_NS) + ServiceCeaWriter.formatAttribute((String)"xmlns:xsi", (String)"http://www.w3.org/2001/XMLSchema-instance") + ServiceCeaWriter.formatAttribute((String)"xmlns:schemaLocation", (String)"http://www.ivoa.net/xml/CEAService/v0.2 http://software.astrogrid.org/schema/vo-resource-types/CEAService/v0.2/CEAService.xsd") + ServiceCeaWriter.formatAttribute((String)"xsi:type", (String)"ceas:CeaApplicationType"));
        this.addElement("title", "", this.meta_.getLongName());
        this.addElement("shortName", "", this.meta_.getShortName());
        this.addElement("identifier", "", this.meta_.getIvorn());
        this.startElement("curation");
        this.addElement("publisher", "", "Astrogrid");
        this.startElement("creator");
        this.addElement("name", "", "Mark Taylor");
        this.endElement("creator");
        this.addElement("date", ServiceCeaWriter.formatAttribute((String)"role", (String)"Resource description generated"), new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        this.addElement("version", "", Stilts.getVersion());
        this.startElement("contact");
        this.addElement("name", "", "Mark Taylor");
        this.addElement("address", "", "Astrophysics Group, Physics Department, Bristol University, UK");
        this.addElement("email", "", "m.b.taylor@bristol.ac.uk");
        this.endElement("contact");
        this.endElement("curation");
        this.startElement("content");
        this.addElement("subject", "", "catalogs tables");
        this.startElement("description");
        this.print(this.meta_.getDescription());
        this.endElement("description");
        this.addElement("referenceURL", "", this.meta_.getRefUrl());
        this.addElement("type", "", "Other");
        this.endElement("content");
        this.startElement("ApplicationDefinition", ServiceCeaWriter.formatAttribute((String)"xmlns", (String)CEAS_NS));
        this.writeParameters();
        this.writeInterfaces();
        this.endElement("ApplicationDefinition");
        this.endElement("vor:Resource");
    }

    @Override
    public String getSchemaLocation() {
        return SCHEMA_LOCATION;
    }

    private static CeaConfig createServiceConfig() {
        ElementDeclaration ifsDecl = new ElementDeclaration("ceas:Interfaces", ServiceCeaWriter.formatAttribute((String)"xmlns", (String)CEAB_NS));
        ElementDeclaration paramsDecl = new ElementDeclaration("Parameters");
        ElementDeclaration paramDecl = new ElementDeclaration("ceas:ParameterDefinition", ServiceCeaWriter.formatAttribute((String)"xmlns", (String)AGPD_NS));
        new ElementDeclaration("ParameterDefinition");
        paramDecl.setAttributeNames(new String[0]);
        return new CeaConfig(ifsDecl, paramsDecl, paramDecl);
    }
}

