/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.func.CoordsDegrees;

public class SexagesimalToDegrees
implements ValueConverter {
    private final boolean hours_;
    private final ValueInfo inInfo_;
    private final DefaultValueInfo outInfo_;

    public SexagesimalToDegrees(ValueInfo sexInfo, boolean hours) {
        if (!String.class.isAssignableFrom(sexInfo.getContentClass())) {
            throw new IllegalArgumentException("Input data must be String, not " + sexInfo.getContentClass().getName());
        }
        this.inInfo_ = sexInfo;
        this.hours_ = hours;
        this.outInfo_ = new DefaultValueInfo(sexInfo);
        this.outInfo_.setContentClass(Double.class);
        this.outInfo_.setUnitString("deg");
        this.outInfo_.setNullable(true);
    }

    @Override
    public ValueInfo getInputInfo() {
        return this.inInfo_;
    }

    @Override
    public ValueInfo getOutputInfo() {
        return this.outInfo_;
    }

    @Override
    public Object convert(Object in) {
        if (in instanceof String) {
            String sex = ((String)in).trim();
            if (sex.length() > 0) {
                double deg = this.hours_ ? CoordsDegrees.hmsToDegrees(sex) : CoordsDegrees.dmsToDegrees(sex);
                return deg;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object unconvert(Object out) {
        if (out instanceof Number) {
            double deg = ((Number)out).doubleValue();
            if (Double.isNaN(deg) || Double.isInfinite(deg)) {
                return null;
            }
            return this.hours_ ? CoordsDegrees.degreesToHms(deg, 3) : CoordsDegrees.degreesToDms(deg, 2);
        }
        return null;
    }

    public String toString() {
        return this.hours_ ? "HMS->degrees" : "DMS->degrees";
    }
}

