/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.copy;

import java.io.StringWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import uk.ac.starlink.ttools.copy.SAXWriter;

public class SquashAttributeHandler
extends SAXWriter {
    private final Writer out_;
    private final String attName_;
    private final boolean removeEmptyElement_;
    private StringWriter buffer_;
    private boolean hasContent_;
    private int level_;

    public SquashAttributeHandler(Writer out, String attName, boolean removeEmptyElement) {
        this.out_ = out;
        this.attName_ = attName;
        this.removeEmptyElement_ = removeEmptyElement;
        this.setOutput(this.out_);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.level_++ == 0) {
            int iRemove = SquashAttributeHandler.getAttIndex(atts, this.attName_);
            if (iRemove >= 0) {
                AttributesImpl a2 = new AttributesImpl(atts);
                a2.removeAttribute(iRemove);
                atts = a2;
            }
            this.buffer_ = new StringWriter();
            this.setOutput(this.buffer_);
            if (atts.getLength() > 0) {
                this.hasContent_ = true;
            }
        }
        super.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (--this.level_ == 0) {
            this.setOutput(this.out_);
            if (this.hasContent_ || !this.removeEmptyElement_) {
                this.out(this.buffer_.toString());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.hasContent_ = true;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
        this.hasContent_ = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        this.hasContent_ = true;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
    }

    @Override
    public void startCDATA() throws SAXException {
        super.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        super.endCDATA();
    }

    private static int getAttIndex(Attributes atts, String attName) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!attName.equals(atts.getLocalName(i)) && !attName.equals(atts.getQName(i))) continue;
            return i;
        }
        return -1;
    }
}

