/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class CacheFilter
extends BasicFilter
implements ProcessingStep {
    public CacheFilter() {
        super("cache", null);
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Stores in memory or on disk a temporary copy of the table at", "this point in the pipeline.", "This can provide improvements in efficiency if there is", "an expensive step upstream and a step which requires", "more than one read of the data downstream.", "If you see an error like \"Can't re-read data from stream\"", "then adding this step near the start of the filters", "might help.", "</p>", "<p>The output table contains no code-level reference", "to the input table, so this filter can also be useful", "when managing tables that have become deeply nested", "as the result of successively applying many STILTS operations.", "</p>", "<p>The result of this filter is guaranteed to be random-access.", "</p>", "<p>See also the <ref id='random'><code>random</code></ref>", "filter, which caches only when the input table is not", "random-access.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) {
        return this;
    }

    @Override
    public StarTable wrap(StarTable baseTable) throws IOException {
        RowStore store = StoragePolicy.getDefaultPolicy().makeRowStore();
        store.acceptMetadata((StarTable)new MetaOnlyTable(baseTable));
        try (RowSequence rseq = baseTable.getRowSequence();){
            while (rseq.next()) {
                store.acceptRow(rseq.getRow());
            }
            store.endRows();
            StarTable starTable = store.getStarTable();
            return starTable;
        }
    }

    private static class MetaOnlyTable
    extends AbstractStarTable {
        private final ColumnInfo[] cinfos_;
        private final List<DescribedValue> dvals_;
        private final long nrow_;

        MetaOnlyTable(StarTable template) {
            int ncol = template.getColumnCount();
            this.cinfos_ = new ColumnInfo[ncol];
            for (int ic = 0; ic < ncol; ++ic) {
                this.cinfos_[ic] = new ColumnInfo((ValueInfo)template.getColumnInfo(ic));
            }
            this.dvals_ = new ArrayList<DescribedValue>();
            for (DescribedValue dval : template.getParameters()) {
                this.dvals_.add(new DescribedValue(dval.getInfo(), dval.getValue()));
            }
            this.nrow_ = template.getRowCount();
            this.setName(template.getName());
            this.setURL(template.getURL());
        }

        public long getRowCount() {
            return this.nrow_;
        }

        public int getColumnCount() {
            return this.cinfos_.length;
        }

        public ColumnInfo getColumnInfo(int ic) {
            return this.cinfos_[ic];
        }

        public RowSequence getRowSequence() {
            throw new UnsupportedOperationException();
        }

        public Object getCell(long irow, int icol) {
            throw new UnsupportedOperationException();
        }

        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException();
        }
    }
}

