/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.AddColumnFilter;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.SupplementData;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class CollapseColsFilter
extends BasicFilter {
    public CollapseColsFilter() {
        super("collapsecols", "[-[no]keepscalars] <array-colname> <col-id0> <ncol>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Adds a new array-valued column", "by using the values from a specified range of scalar columns", "as array elements.", "The new column is named <code>&lt;array-colname&gt;</code>,", "and produced from the sequence of <code>&lt;ncol&gt;</code>", "scalar columns starting with <code>&lt;col-id0&gt;</code>.", "</p>", "<p>The array type of the output column is determined by the type", "of the first input column (<code>&lt;col-id0&gt;</code>).", "If it is of type <code>Double</code>,", "the output array column will be a <code>double[]</code> array,", "and similarly for types <code>Long</code>, <code>Integer</code>,", "<code>Float</code> and <code>Boolean</code>.", "Other integer types are currently mapped to <code>int[]</code>,", "and object types, e.g. <code>String</code>,", "to the corresponding array type.", "Array elements for null or mistyped input values", "are mapped to NaN for floating point types, but", "<strong><em>note</em></strong> that they currently", "just turn into zeros for integer array types", "and <code>false</code> for boolean.", "</p>", "<p>By default the scalar columns that have been used are removed", "from the output table and the new column replaces them", "at the same position.", "However, if you supply the <code>-keepscalars</code> flag", "they will be retained alongside the new array column", "(the new column will appear just after the run of scalar", "columns).", "</p>", "<p>This filter does the opposite of", "<ref id='explodecols'><code>explodecols</code></ref>.", "</p>", CollapseColsFilter.explainSyntax(new String[]{"col-id0"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String colName = null;
        String colId0 = null;
        int ncol = -1;
        boolean keepScalars = false;
        while (argIt.hasNext() && (colName == null || colId0 == null || ncol < 0)) {
            String arg = argIt.next();
            if (arg.toLowerCase().startsWith("-keepscalar")) {
                argIt.remove();
                keepScalars = true;
                continue;
            }
            if (arg.toLowerCase().startsWith("-nokeepscalar")) {
                argIt.remove();
                keepScalars = false;
                continue;
            }
            if (colName == null) {
                argIt.remove();
                colName = arg;
                continue;
            }
            if (colId0 == null) {
                argIt.remove();
                colId0 = arg;
                continue;
            }
            if (ncol >= 0) continue;
            argIt.remove();
            try {
                ncol = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new ArgException("Non-numeric <ncol>: \"" + arg + "\"");
            }
            if (ncol >= 0) continue;
            throw new ArgException("Negative <ncol>: " + ncol);
        }
        if (ncol < 0) {
            throw new ArgException("Bad " + this.getName() + " specification");
        }
        return new CollapseStep(colName, colId0, ncol, keepScalars);
    }

    private static ColumnSupplement createArrayColumnSupplement(StarTable table, String colName, int icol0, int ncol) {
        Class eclazz = table.getColumnInfo(icol0).getContentClass();
        if (Long.class.equals((Object)eclazz)) {
            return new ArrayColumnSupplement<long[]>(table, colName, icol0, ncol, long[].class){

                @Override
                protected void setElement(long[] array, int index, Object value) {
                    array[index] = value instanceof Number ? ((Number)value).longValue() : 0L;
                }
            };
        }
        if (Integer.class.equals((Object)eclazz) || Short.class.equals((Object)eclazz) || Byte.class.equals((Object)eclazz)) {
            return new ArrayColumnSupplement<int[]>(table, colName, icol0, ncol, int[].class){

                @Override
                protected void setElement(int[] array, int index, Object value) {
                    array[index] = value instanceof Number ? ((Number)value).intValue() : 0;
                }
            };
        }
        if (Float.class.equals((Object)eclazz)) {
            return new ArrayColumnSupplement<float[]>(table, colName, icol0, ncol, float[].class){

                @Override
                protected void setElement(float[] array, int index, Object value) {
                    array[index] = value instanceof Number ? ((Number)value).floatValue() : Float.NaN;
                }
            };
        }
        if (Number.class.isAssignableFrom(eclazz)) {
            return new ArrayColumnSupplement<double[]>(table, colName, icol0, ncol, double[].class){

                @Override
                protected void setElement(double[] array, int index, Object value) {
                    array[index] = value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
                }
            };
        }
        if (Boolean.class.equals((Object)eclazz)) {
            return new ArrayColumnSupplement<boolean[]>(table, colName, icol0, ncol, boolean[].class){

                @Override
                protected void setElement(boolean[] array, int index, Object value) {
                    array[index] = Boolean.TRUE.equals(value);
                }
            };
        }
        Class<?> aclazz = Array.newInstance(eclazz, 0).getClass();
        return CollapseColsFilter.createGenericArrayColumnSupplement(table, colName, icol0, ncol, aclazz);
    }

    private static <A> ColumnSupplement createGenericArrayColumnSupplement(StarTable table, String colName, int icol0, int ncol, Class<A> aclazz) {
        final Class<?> eclazz = aclazz.getComponentType();
        return new ArrayColumnSupplement<A>(table, colName, icol0, ncol, aclazz){

            @Override
            protected void setElement(A array, int index, Object value) {
                Array.set(array, index, eclazz.isInstance(value) ? value : null);
            }
        };
    }

    private static abstract class ArrayColumnSupplement<A>
    implements ColumnSupplement {
        private final StarTable table_;
        private final int icol0_;
        private final int ncol_;
        private final Class<A> aclazz_;
        private final Class<?> eclazz_;
        private final ColumnInfo info_;

        ArrayColumnSupplement(StarTable table, String colName, int icol0, int ncol, Class<A> aclazz) {
            this.table_ = table;
            this.icol0_ = icol0;
            this.ncol_ = ncol;
            this.aclazz_ = aclazz;
            this.info_ = new ColumnInfo(colName, aclazz, null);
            this.info_.setShape(new int[]{ncol});
            this.eclazz_ = this.aclazz_.getComponentType();
        }

        protected abstract void setElement(A var1, int var2, Object var3);

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public ColumnInfo getColumnInfo(int icol) {
            if (icol == 0) {
                return this.info_;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object getCell(long irow, int icol) throws IOException {
            if (icol == 0) {
                A array = this.createArray();
                for (int i = 0; i < this.ncol_; ++i) {
                    this.setElement(array, i, this.table_.getCell(irow, this.icol0_ + i));
                }
                return array;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object[] getRow(long irow) throws IOException {
            return new Object[]{this.getCell(irow, 0)};
        }

        @Override
        public SupplementData createSupplementData(final RowData rdata) {
            return new SupplementData(){

                @Override
                public Object getCell(long irow, int icol) throws IOException {
                    if (icol == 0) {
                        Object array = this.createArray();
                        for (int i = 0; i < ncol_; ++i) {
                            this.setElement(array, i, rdata.getCell(icol0_ + i));
                        }
                        return array;
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                public Object[] getRow(long irow) throws IOException {
                    return new Object[]{this.getCell(irow, 0)};
                }
            };
        }

        private A createArray() {
            Object array = Array.newInstance(this.eclazz_, this.ncol_);
            return (A)array;
        }
    }

    private static class CollapseStep
    implements ProcessingStep {
        private final String colName_;
        private final String colId0_;
        private final int ncol_;
        private final boolean keepScalars_;

        CollapseStep(String colName, String colId0, int ncol, boolean keepScalars) {
            this.colName_ = colName;
            this.colId0_ = colId0;
            this.ncol_ = ncol;
            this.keepScalars_ = keepScalars;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            int icol0 = new ColumnIdentifier(base).getColumnIndex(this.colId0_);
            ColumnSupplement arraySup = CollapseColsFilter.createArrayColumnSupplement(base, this.colName_, icol0, this.ncol_);
            int nc0 = base.getColumnCount();
            AddColumnsTable extTable = new AddColumnsTable(base, arraySup, nc0);
            int[] colMap = new int[nc0 + 1 - (this.keepScalars_ ? 0 : this.ncol_)];
            int jc = 0;
            int ic = 0;
            while (ic < icol0) {
                colMap[jc++] = ic++;
            }
            if (this.keepScalars_) {
                for (ic = 0; ic < this.ncol_; ++ic) {
                    colMap[jc++] = icol0 + ic;
                }
            }
            int icArray = jc;
            colMap[jc++] = nc0;
            int ic2 = icol0 + this.ncol_;
            while (ic2 < nc0) {
                colMap[jc++] = ic2++;
            }
            ColumnPermutedStarTable out = new ColumnPermutedStarTable((StarTable)extTable, colMap);
            AddColumnFilter.checkDuplicatedName((StarTable)out, icArray);
            return out;
        }
    }
}

