/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowAccess;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class EveryTable
extends WrapperStarTable {
    private final long step_;
    private final boolean isExact_;

    public EveryTable(StarTable base, long step, boolean isExact) {
        super(base);
        this.step_ = step;
        this.isExact_ = isExact;
    }

    public long getRowCount() {
        long baseCount = super.getRowCount();
        if (baseCount >= 0L) {
            return (baseCount - 1L) / this.step_ + 1L;
        }
        return baseCount;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return super.getCell(irow * this.step_, icol);
    }

    public Object[] getRow(long irow) throws IOException {
        return super.getRow(irow * this.step_);
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){
            boolean started;

            public boolean next() throws IOException {
                if (this.started) {
                    int i = 0;
                    while ((long)i < EveryTable.this.step_) {
                        if (!super.next()) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    this.started = true;
                    return super.next();
                }
                return true;
            }
        };
    }

    public RowAccess getRowAccess() throws IOException {
        return new WrapperRowAccess(super.getRowAccess()){

            public void setRowIndex(long irow) throws IOException {
                super.setRowIndex(irow * EveryTable.this.step_);
            }
        };
    }

    public RowSplittable getRowSplittable() throws IOException {
        RowSplittable baseSplittable = super.getRowSplittable();
        LongSupplier rowIndex = baseSplittable.rowIndex();
        if (rowIndex == null) {
            return this.isExact_ ? new SequentialRowSplittable((StarTable)this) : new ApproxEverySplittable(baseSplittable);
        }
        return new ExactEverySplittable(baseSplittable);
    }

    private class ApproxEverySplittable
    extends WrapperRowSequence
    implements RowSplittable {
        final RowSplittable baseSplit_;
        boolean started_;

        ApproxEverySplittable(RowSplittable baseSplit) {
            super((RowSequence)baseSplit);
            this.baseSplit_ = baseSplit;
        }

        public long splittableSize() {
            long baseSize = this.baseSplit_.splittableSize();
            return baseSize >= 0L ? baseSize / EveryTable.this.step_ : -1L;
        }

        public LongSupplier rowIndex() {
            return null;
        }

        public boolean next() throws IOException {
            if (this.started_) {
                int i = 0;
                while ((long)i < EveryTable.this.step_) {
                    if (!this.baseSplit_.next()) {
                        return false;
                    }
                    ++i;
                }
            } else {
                this.started_ = true;
                return super.next();
            }
            return true;
        }

        public RowSplittable split() {
            RowSplittable spl = (RowSplittable)this.baseSplit_.split();
            return spl == null ? null : new ApproxEverySplittable(spl);
        }
    }

    private class ExactEverySplittable
    extends WrapperRowSequence
    implements RowSplittable {
        final RowSplittable baseSplit_;
        final LongSupplier baseIndex_;
        final LongSupplier rowIndex_;

        ExactEverySplittable(RowSplittable baseSplit) {
            super((RowSequence)baseSplit);
            this.baseSplit_ = baseSplit;
            this.baseIndex_ = this.baseSplit_.rowIndex();
            this.rowIndex_ = () -> this.baseIndex_.getAsLong() / EveryTable.this.step_;
            assert (this.baseIndex_ != null);
        }

        public long splittableSize() {
            long baseSize = this.baseSplit_.splittableSize();
            return baseSize >= 0L ? baseSize / EveryTable.this.step_ : -1L;
        }

        public LongSupplier rowIndex() {
            return this.rowIndex_;
        }

        public boolean next() throws IOException {
            while (this.baseSplit_.next()) {
                if (this.baseIndex_.getAsLong() % EveryTable.this.step_ != 0L) continue;
                return true;
            }
            return false;
        }

        public RowSplittable split() {
            RowSplittable spl = (RowSplittable)this.baseSplit_.split();
            return spl == null ? null : new ExactEverySplittable(spl);
        }
    }
}

