/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class StepFactory {
    private final ObjectFactory<ProcessingFilter> filterFactory_ = new ObjectFactory(ProcessingFilter.class);
    private static StepFactory instance_;

    private StepFactory() {
        String pkg = "uk.ac.starlink.ttools.filter.";
        this.filterFactory_.register("addcol", pkg + "AddColumnFilter");
        this.filterFactory_.register("addpixsample", pkg + "PixSampleFilter");
        this.filterFactory_.register("addresolve", pkg + "ResolverFilter");
        this.filterFactory_.register("addskycoords", pkg + "AddSkyCoordsFilter");
        this.filterFactory_.register("assert", pkg + "AssertFilter");
        this.filterFactory_.register("badval", pkg + "BadValueFilter");
        this.filterFactory_.register("cache", pkg + "CacheFilter");
        this.filterFactory_.register("check", pkg + "CheckFilter");
        this.filterFactory_.register("clearparams", pkg + "ClearParameterFilter");
        this.filterFactory_.register("collapsecols", pkg + "CollapseColsFilter");
        this.filterFactory_.register("colmeta", pkg + "ColumnMetadataFilter");
        this.filterFactory_.register("constcol", pkg + "ConstFilter");
        this.filterFactory_.register("delcols", pkg + "DeleteColumnFilter");
        this.filterFactory_.register("every", pkg + "EveryFilter");
        this.filterFactory_.register("explodecols", pkg + "ExplodeColsFilter");
        this.filterFactory_.register("explodeall", pkg + "ExplodeAllFilter");
        this.filterFactory_.register("fixcolnames", pkg + "FixNamesFilter");
        this.filterFactory_.register("group", pkg + "GroupFilter");
        this.filterFactory_.register("head", pkg + "HeadFilter");
        this.filterFactory_.register("healpixmeta", pkg + "HealpixMetadataFilter");
        this.filterFactory_.register("keepcols", pkg + "KeepColumnFilter");
        this.filterFactory_.register("meta", pkg + "MetadataFilter");
        this.filterFactory_.register("progress", pkg + "ProgressFilter");
        this.filterFactory_.register("random", pkg + "RandomFilter");
        this.filterFactory_.register("randomview", pkg + "RandomViewFilter");
        this.filterFactory_.register("repeat", pkg + "RepeatFilter");
        this.filterFactory_.register("replacecol", pkg + "ReplaceColumnFilter");
        this.filterFactory_.register("replaceval", pkg + "ReplaceValueFilter");
        this.filterFactory_.register("rowrange", pkg + "RangeFilter");
        this.filterFactory_.register("select", pkg + "SelectFilter");
        this.filterFactory_.register("seqview", pkg + "SequentialViewFilter");
        this.filterFactory_.register("setparam", pkg + "SetParameterFilter");
        this.filterFactory_.register("shuffle", pkg + "ShuffleFilter");
        this.filterFactory_.register("sort", pkg + "SortFilter");
        this.filterFactory_.register("sorthead", pkg + "SortHeadFilter");
        this.filterFactory_.register("stats", pkg + "StatsFilter");
        this.filterFactory_.register("tablename", pkg + "NameFilter");
        this.filterFactory_.register("tail", pkg + "TailFilter");
        this.filterFactory_.register("transpose", pkg + "TransposeFilter");
        this.filterFactory_.register("uniq", pkg + "UniqueFilter");
    }

    public ObjectFactory<ProcessingFilter> getFilterFactory() {
        return this.filterFactory_;
    }

    public ProcessingStep[] createSteps(String text) throws TaskException {
        String[] lines = Tokenizer.tokenizeLines(text);
        ArrayList<ProcessingStep> stepList = new ArrayList<ProcessingStep>();
        for (int i = 0; i < lines.length; ++i) {
            ProcessingStep step = this.createStep(lines[i]);
            if (step == null) continue;
            stepList.add(step);
        }
        return stepList.toArray(new ProcessingStep[0]);
    }

    public ProcessingStep createStep(String line) throws TaskException {
        String[] tokens = Tokenizer.tokenizeWords(line);
        if (tokens.length == 0) {
            return null;
        }
        String cmd = tokens[0];
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(tokens));
        argList.remove(0);
        if (this.filterFactory_.isRegistered(cmd)) {
            ProcessingFilter filter;
            try {
                filter = (ProcessingFilter)this.filterFactory_.createObject(cmd);
            }
            catch (LoadException e) {
                throw new TaskException("Trouble loading command " + cmd, (Throwable)e);
            }
            try {
                ProcessingStep step = filter.createStep(argList.iterator());
                if (argList.isEmpty()) {
                    return step;
                }
                boolean containSpace = false;
                StringBuffer msg = new StringBuffer("Unused arguments:");
                for (String arg : argList) {
                    containSpace = containSpace || arg.indexOf(32) >= 0;
                    msg.append(" '").append(arg).append("'");
                }
                if (!containSpace && line.indexOf(39) < 0 && line.indexOf(34) < 0) {
                    msg.append("\n(Hint: arguments containing spaces").append(" must be quoted)");
                }
                throw new ArgException(msg.toString());
            }
            catch (ArgException e) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(e.getMessage()).append('\n').append('\n').append("Command was: ").append(line).append('\n').append('\n').append("Usage: ").append(cmd);
                String pad = ("Usage: " + cmd + " ").replaceAll(".", " ");
                String fusage = filter.getUsage();
                if (fusage != null) {
                    fusage = fusage.replaceAll("\n", "\n" + pad);
                }
                if (fusage != null) {
                    sbuf.append(' ').append(fusage);
                }
                throw new TaskException(sbuf.toString(), (Throwable)e);
            }
        }
        throw new TaskException("Unknown processing command: " + cmd + "\n\n" + this.getFilterUsages());
    }

    private String getFilterUsages() {
        StringBuffer sbuf = new StringBuffer().append("Available filters:\n");
        String[] fnames = this.filterFactory_.getNickNames();
        for (int i = 0; i < fnames.length; ++i) {
            try {
                String fname = fnames[i];
                ProcessingFilter filter = (ProcessingFilter)this.filterFactory_.createObject(fname);
                String fintro = "   " + fname;
                sbuf.append(fintro);
                String fusage = filter.getUsage();
                if (fusage != null) {
                    String pad = fintro.replaceAll(".", " ") + " ";
                    sbuf.append(' ').append(fusage.trim().replaceAll("\n", "\n" + pad));
                }
                sbuf.append('\n');
                continue;
            }
            catch (LoadException loadException) {
                // empty catch block
            }
        }
        return sbuf.toString();
    }

    public static StepFactory getInstance() {
        if (instance_ == null) {
            instance_ = new StepFactory();
        }
        return instance_;
    }
}

