/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.Quantiler;
import uk.ac.starlink.ttools.filter.UnivariateStats;
import uk.ac.starlink.util.IntList;

public class TableStats {
    public static final double MAD_SCALE = 1.4826;
    private final UnivariateStats[] colStats_;
    private long nrow_;

    public TableStats(UnivariateStats[] colStats) {
        this.colStats_ = colStats;
    }

    public UnivariateStats[] getColumnStats() {
        return this.colStats_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public static TableStats calculateStats(StarTable table, RowRunner runner, Supplier<Quantiler> qSupplier, boolean doCard) throws IOException {
        ColumnInfo[] colInfos = Tables.getColumnInfos((StarTable)table);
        StatsCollector collector = new StatsCollector(colInfos, qSupplier, doCard);
        return (TableStats)runner.collect((RowCollector)collector, table);
    }

    public static double[] calculateMads(StarTable table, RowRunner runner, final Supplier<Quantiler> qSupplier, final double[] medians) throws IOException {
        final int ncol = medians.length;
        IntList madIcolList = new IntList();
        for (int ic = 0; ic < ncol; ++ic) {
            if (Double.isNaN(medians[ic])) continue;
            madIcolList.add(ic);
        }
        final int[] madIcols = madIcolList.toIntArray();
        final int njc = madIcols.length;
        RowCollector<Quantiler[]> madCollector = new RowCollector<Quantiler[]>(){

            public Quantiler[] createAccumulator() {
                Quantiler[] quantilers = new Quantiler[ncol];
                for (int jc = 0; jc < njc; ++jc) {
                    int ic = madIcols[jc];
                    quantilers[ic] = (Quantiler)qSupplier.get();
                }
                return quantilers;
            }

            public Quantiler[] combine(Quantiler[] qs1, Quantiler[] qs2) {
                for (int jc = 0; jc < njc; ++jc) {
                    int ic = madIcols[jc];
                    qs1[ic].addQuantiler(qs2[ic]);
                }
                return qs1;
            }

            public void accumulateRows(RowSplittable rseq, Quantiler[] qs) throws IOException {
                while (rseq.next()) {
                    for (int jc = 0; jc < njc; ++jc) {
                        double dval;
                        int ic = madIcols[jc];
                        Object value = rseq.getCell(ic);
                        if (!(value instanceof Number) || Double.isNaN(dval = ((Number)value).doubleValue())) continue;
                        double dm = Math.abs(dval - medians[ic]);
                        qs[ic].acceptDatum(dm);
                    }
                }
            }
        };
        Quantiler[] madQuantilers = (Quantiler[])runner.collect((RowCollector)madCollector, table);
        double[] mads = new double[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            Quantiler quantiler = madQuantilers[ic];
            if (quantiler != null) {
                quantiler.ready();
                mads[ic] = quantiler.getValueAtQuantile(0.5);
                continue;
            }
            mads[ic] = Double.NaN;
        }
        return mads;
    }

    private static class StatsCollector
    extends RowCollector<TableStats> {
        private final ColumnInfo[] colInfos_;
        private final Supplier<Quantiler> qSupplier_;
        private final boolean doCard_;
        private final int ncol_;

        public StatsCollector(ColumnInfo[] colInfos, Supplier<Quantiler> qSupplier, boolean doCard) {
            this.colInfos_ = colInfos;
            this.qSupplier_ = qSupplier;
            this.doCard_ = doCard;
            this.ncol_ = colInfos.length;
        }

        public TableStats createAccumulator() {
            UnivariateStats[] colStats = new UnivariateStats[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                Class clazz = this.colInfos_[icol].getContentClass();
                colStats[icol] = UnivariateStats.createStats(clazz, this.qSupplier_, this.doCard_);
            }
            return new TableStats(colStats);
        }

        public TableStats combine(TableStats ts1, TableStats ts2) {
            TableStats tableStats = ts1;
            tableStats.nrow_ = tableStats.nrow_ + ts2.nrow_;
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ts1.colStats_[icol].addStats(ts2.colStats_[icol]);
            }
            return ts1;
        }

        public void accumulateRows(RowSplittable rseq, TableStats tstats) throws IOException {
            UnivariateStats[] colStats = tstats.colStats_;
            LongSupplier rowIndex = rseq.rowIndex();
            long nr = 0L;
            while (rseq.next()) {
                ++nr;
                Object[] row = rseq.getRow();
                long irow = rowIndex == null ? -1L : rowIndex.getAsLong();
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    colStats[icol].acceptDatum(row[icol], irow);
                }
            }
            TableStats tableStats = tstats;
            tableStats.nrow_ = tableStats.nrow_ + nr;
        }
    }
}

