/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.ConstantResolver;
import uk.ac.starlink.ttools.jel.JELUtils;

public class JELFunction
implements DoubleUnaryOperator {
    private final String xvarname_;
    private final String fexpr_;
    private final XConstant xconst_;
    private final CompiledExpression fCompex_;
    private final Constant<?>[] usedConsts_;
    private final Object[] args_;

    public JELFunction(String xvarname, String fexpr) throws CompilationException {
        this(xvarname, fexpr, null);
    }

    public JELFunction(String xvarname, String fexpr, Map<String, ? extends Constant<?>> constMap) throws CompilationException {
        this.xvarname_ = xvarname;
        this.fexpr_ = fexpr;
        this.xconst_ = new XConstant();
        HashMap<String, Constant<Object>> fconstMap = new HashMap<String, Constant<Object>>();
        if (constMap != null) {
            fconstMap.putAll(constMap);
        }
        fconstMap.put(xvarname, this.xconst_);
        ConstantResolver resolver = new ConstantResolver(fconstMap);
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        Class[] dynamicLib = new Class[]{resolver.getClass()};
        Library lib = JELUtils.createLibrary(staticLib, dynamicLib, resolver);
        this.fCompex_ = Evaluator.compile(fexpr, lib, Double.TYPE);
        this.args_ = new Object[]{resolver};
        HashSet usedConstSet = new HashSet(resolver.getTranslatedConstants());
        usedConstSet.remove(this.xconst_);
        this.usedConsts_ = usedConstSet.toArray(new Constant[0]);
    }

    public Constant<?>[] getReferencedConstants() {
        return (Constant[])this.usedConsts_.clone();
    }

    public double evaluate(double x) {
        this.xconst_.value_ = x;
        try {
            return this.fCompex_.evaluate_double(this.args_);
        }
        catch (Throwable e) {
            return Double.NaN;
        }
    }

    @Override
    public double applyAsDouble(double x) {
        return this.evaluate(x);
    }

    public String getXVarName() {
        return this.xvarname_;
    }

    public String getExpression() {
        return this.fexpr_;
    }

    public static void main(String[] args) {
        String usage = "Usage: " + JELFunction.class.getName() + " <varname> <expr> <varvalue>\n";
        if (args.length != 3) {
            System.err.println(usage);
            System.exit(1);
        }
        String xvarname = args[0];
        String fexpr = args[1];
        String value = args[2];
        try {
            JELFunction f = new JELFunction(xvarname, fexpr);
            double x = Double.parseDouble(value);
            double y = f.evaluate(x);
            System.out.println("f(" + xvarname + ")=" + fexpr + "\nf(" + value + ")=" + y);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("\n" + usage);
            System.exit(1);
        }
    }

    private static class XConstant
    implements Constant<Double> {
        volatile double value_;

        private XConstant() {
        }

        @Override
        public Class<Double> getContentClass() {
            return Double.class;
        }

        @Override
        public Double getValue() {
            return this.value_;
        }

        @Override
        public boolean requiresRowIndex() {
            return false;
        }
    }
}

